/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhoodCursor;

public class RectangleCursor<T>
extends AbstractNeighborhoodCursor<T> {
    protected long[] position;
    protected long count = 0L;
    protected long size;

    public RectangleCursor(AbstractNeighborhood<T> rectangle) {
        super(rectangle);
        this.position = new long[rectangle.source.numDimensions()];
        this.reset();
    }

    public RectangleCursor<T> copy() {
        return this.copyCursor();
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    public void fwd() {
        for (int d = 0; d < this.position.length; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            this.ra.fwd(d);
            if (this.position[d] <= this.neighborhood.center[d] + this.neighborhood.span[d]) break;
            this.position[d] = this.neighborhood.center[d] - this.neighborhood.span[d];
            this.ra.setPosition(this.position[d], d);
        }
        ++this.count;
    }

    public void reset() {
        int d;
        for (d = 0; d < this.position.length; ++d) {
            this.position[d] = this.neighborhood.center[d] - this.neighborhood.span[d];
        }
        this.count = 0L;
        this.position[0] = this.position[0] - 1L;
        this.ra.setPosition(this.position);
        this.size = 1L;
        for (d = 0; d < this.neighborhood.span.length; ++d) {
            this.size *= 2L * this.neighborhood.span[d] + 1L;
        }
    }

    public boolean hasNext() {
        return this.count < this.size;
    }

    @Override
    public T next() {
        this.fwd();
        return this.get();
    }

    public RectangleCursor<T> copyCursor() {
        return new RectangleCursor<T>(this.neighborhood);
    }
}

