/*
 * Decompiled with CFR 0.152.
 */
package org.imagearchive.lsm.toolbox.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.text.html.HTMLEditorKit;
import org.imagearchive.lsm.toolbox.MasterModel;
import org.imagearchive.lsm.toolbox.gui.HtmlPageLoader;

public class AboutDialog
extends JDialog {
    private MasterModel masterModel;
    private JEditorPane about;
    private JEditorPane changelog;
    private JEditorPane iconset;
    private JEditorPane license;
    private JEditorPane help;
    private JScrollPane aboutScroller;
    private JScrollPane changelogScroller;
    private JScrollPane helpScroller;
    private JScrollPane licenseScroller;
    private JScrollPane iconsetScroller;
    private JTabbedPane tabber;
    private JButton okButton;
    private final Dimension ScreenDimension = Toolkit.getDefaultToolkit().getScreenSize();
    private final int ScreenX = (int)this.ScreenDimension.getWidth();
    private final int ScreenY = (int)this.ScreenDimension.getHeight();
    private JLabel infoTitle;
    private final String infoText = "<html><center>LSM_Toolbox ver " + MasterModel.VERSION + " (C) 2003-2009 Patrick Pirrotte </center></html>";

    public AboutDialog(JFrame parent, MasterModel masterModel) throws HeadlessException {
        super((Frame)parent, true);
        this.masterModel = masterModel;
        this.initializeGUI();
        this.loadPages();
    }

    public AboutDialog() throws HeadlessException {
        this.initializeGUI();
    }

    public void initializeGUI() {
        this.setTitle("About");
        this.tabber = new JTabbedPane();
        this.okButton = new JButton(new ImageIcon(this.getClass().getResource("images/ok.png")));
        this.aboutScroller = new JScrollPane();
        this.changelogScroller = new JScrollPane();
        this.about = new JEditorPane();
        this.changelog = new JEditorPane();
        this.license = new JEditorPane();
        this.iconset = new JEditorPane();
        this.help = new JEditorPane();
        this.helpScroller = new JScrollPane();
        this.licenseScroller = new JScrollPane();
        this.iconsetScroller = new JScrollPane();
        this.infoTitle = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.dispose();
            }
        });
        this.tabber.setPreferredSize(new Dimension(this.ScreenX / 2, this.ScreenY / 2));
        this.infoTitle.setText(this.infoText);
        this.aboutScroller.setViewportView(this.about);
        this.changelogScroller.setViewportView(this.changelog);
        this.help.setEditorKit(new HTMLEditorKit());
        this.iconsetScroller.setViewportView(this.iconset);
        this.helpScroller.setViewportView(this.help);
        this.licenseScroller.setViewportView(this.license);
        this.tabber.addTab("About", this.aboutScroller);
        this.tabber.addTab("Changelog", this.changelogScroller);
        this.tabber.addTab("Help", this.helpScroller);
        this.tabber.addTab("LSM_Toolbox Licence", this.licenseScroller);
        this.tabber.addTab("Nuvola Iconset License", this.iconsetScroller);
        String loadingText = "Loading... please wait...";
        this.about.setText("Loading... please wait...");
        this.changelog.setText("Loading... please wait...");
        this.help.setText("Loading... please wait...");
        this.license.setText("Loading... please wait...");
        this.iconset.setText("Loading... please wait...");
        this.about.setContentType("text/html");
        this.about.setEditable(false);
        this.changelog.setContentType("text/html");
        this.changelog.setEditable(false);
        this.iconset.setContentType("text/html");
        this.iconset.setEditable(false);
        this.license.setContentType("text/html");
        this.license.setEditable(false);
        this.help.setContentType("text/html");
        this.help.setEditable(false);
        this.infoTitle.setBorder(BorderFactory.createEtchedBorder());
        this.infoTitle.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.infoTitle, "North");
        this.getContentPane().add((Component)this.tabber, "Center");
        this.getContentPane().add((Component)this.okButton, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        this.pack();
        this.centerWindow();
    }

    public void loadPages() {
        Object[][] pages = new Object[][]{{this.about, "html/about.htm"}, {this.changelog, "html/changelog.htm"}, {this.iconset, "html/lgpl.txt"}, {this.license, "html/licence.txt"}, {this.help, "html/help.htm"}};
        HtmlPageLoader loader = new HtmlPageLoader(this, pages);
        loader.start();
    }

    public void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    public static void main(String[] args) {
        new AboutDialog(new JFrame(), null).setVisible(true);
        System.exit(-1);
    }
}

