/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.AWTEvent;
import mpicbg.ij.plugin.AbstractBlockFilter;

public class RemoveOutliers
extends AbstractBlockFilter {
    protected static double standardDeviations = 3.0;
    protected double stds;
    protected mpicbg.ij.integral.RemoveOutliers[] rmos;

    @Override
    protected String dialogTitle() {
        return "Remove Outliers";
    }

    @Override
    protected void init(ImagePlus imp) {
        super.init(imp);
        this.rmos = imp.getType() == 4 ? new mpicbg.ij.integral.RemoveOutliers[]{new mpicbg.ij.integral.RemoveOutliers(this.fps[0]), new mpicbg.ij.integral.RemoveOutliers(this.fps[1]), new mpicbg.ij.integral.RemoveOutliers(this.fps[2])} : new mpicbg.ij.integral.RemoveOutliers[]{new mpicbg.ij.integral.RemoveOutliers(this.fps[0])};
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        GenericDialog gd = new GenericDialog(this.dialogTitle());
        gd.addNumericField("Block_radius_x : ", (double)blockRadiusX, 0, 6, "pixels");
        gd.addNumericField("Block_radius_y : ", (double)blockRadiusY, 0, 6, "pixels");
        gd.addNumericField("Standard_deviations : ", standardDeviations, 2);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener((DialogListener)this);
        this.init(imp);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)29);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        blockRadiusX = (int)gd.getNextNumber();
        blockRadiusY = (int)gd.getNextNumber();
        standardDeviations = gd.getNextNumber();
        return !gd.invalidNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyParameters() {
        RemoveOutliers removeOutliers = this;
        synchronized (removeOutliers) {
            this.brx = blockRadiusX;
            this.bry = blockRadiusY;
            this.stds = standardDeviations;
        }
    }

    @Override
    protected void process(int i) {
        this.rmos[i].removeOutliers(this.brx, this.bry, (float)this.stds);
    }

    public static void run(ImageProcessor ip, int brx, int bry, float stds) {
        RemoveOutliers rmo = new RemoveOutliers();
        rmo.init(new ImagePlus("", ip));
        for (int i = 0; i < rmo.rmos.length; ++i) {
            rmo.rmos[i].removeOutliers(brx, bry, stds);
        }
        if (FloatProcessor.class.isInstance(ip)) {
            return;
        }
        if (ColorProcessor.class.isInstance(ip)) {
            int[] rgbs = (int[])ip.getPixels();
            rmo.toRGB(rgbs);
        } else if (ByteProcessor.class.isInstance(ip)) {
            byte[] bytes = (byte[])ip.getPixels();
            rmo.toByte(bytes);
        } else if (ShortProcessor.class.isInstance(ip)) {
            short[] shorts = (short[])ip.getPixels();
            rmo.toShort(shorts);
        }
    }
}

