/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Line;
import math3d.Point3d;

public class Plane {
    double a;
    double b;
    double c;
    double d;

    public Plane(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Plane(Point3d p1, Point3d p2, Point3d p3, Point3d insidePoint) {
        double x1 = p1.x;
        double x2 = p2.x;
        double x3 = p3.x;
        double y1 = p1.y;
        double y2 = p2.y;
        double y3 = p3.y;
        double z1 = p1.z;
        double z2 = p2.z;
        double z3 = p3.z;
        this.a = y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2);
        this.b = z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2);
        this.c = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
        this.d = -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1));
        double dist = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        this.a /= dist;
        this.b /= dist;
        this.c /= dist;
        this.d /= dist;
        if (!this.isInside(insidePoint)) {
            this.a *= -1.0;
            this.b *= -1.0;
            this.c *= -1.0;
            this.d *= -1.0;
        }
    }

    boolean isInside(Point3d p) {
        return this.isInside(p.x, p.y, p.z);
    }

    boolean isInside(double x, double y, double z) {
        return this.a * x + this.b * y + this.c * z > 0.0;
    }

    public Point3d intersection(Line l) {
        double x1 = l.p1.x;
        double x2 = l.p2.x;
        double y1 = l.p1.y;
        double y2 = l.p2.y;
        double z1 = l.p1.z;
        double z2 = l.p2.z;
        double denominator = this.a * (x1 - x2) + this.b * (y1 - y2) + this.c * (z1 - z2);
        if (denominator > -1.0E-4 && denominator < 1.0E-4) {
            return null;
        }
        double u = (this.a * x1 + this.b * y1 + this.c * z1 + this.d) / denominator;
        Point3d ret = new Point3d(x1 + u * (x2 - x1), y1 + u * (y2 - y1), z1 + u * (z2 - z1));
        return ret;
    }

    public Point3d getNormal() {
        return new Point3d(this.a, this.b, this.c);
    }
}

