/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nrrd.NrrdHeader;
import nrrd.NrrdInfo;
import vib.FastMatrix;

public class CMTKTransformation {
    File originalFile;
    Inverse inverse;
    int dimsx = -1;
    int dimsy = -1;
    int dimsz = -1;
    double domainx = Double.MIN_VALUE;
    double domainy = Double.MIN_VALUE;
    double domainz = Double.MIN_VALUE;
    double originx = Double.MIN_VALUE;
    double originy = Double.MIN_VALUE;
    double originz = Double.MIN_VALUE;
    double[][] coeffs;
    double deltax = -1.0;
    double deltay = -1.0;
    double deltaz = -1.0;

    public void setOriginalFile(File originalFile) {
        this.originalFile = originalFile;
    }

    public CMTKTransformation() {
    }

    protected CMTKTransformation(int dimsx, int dimsy, int dimsz, double domainx, double domainy, double domainz, double originx, double originy, double originz, double[][] coeffs) {
        this.dimsx = dimsx;
        this.dimsy = dimsy;
        this.dimsz = dimsz;
        this.domainx = domainx;
        this.domainy = domainy;
        this.domainz = domainz;
        this.originx = originx;
        this.originy = originy;
        this.originz = originz;
        this.coeffs = coeffs;
        this.deltax = domainx / (double)(dimsx - 3);
        this.deltay = domainy / (double)(dimsy - 3);
        this.deltaz = domainz / (double)(dimsz - 3);
    }

    public static double degToRad(double d) {
        return d * Math.PI / 180.0;
    }

    public byte trilinearInterpolateByte(double image_x, double image_y, double image_z, int width, int height, int depth, byte[][] v) {
        double ccc;
        double fcc;
        double cfc;
        double ffc;
        double ccf;
        double fcf;
        double cff;
        double fff;
        double x_d = image_x - Math.floor(image_x);
        double y_d = image_y - Math.floor(image_y);
        double z_d = image_z - Math.floor(image_z);
        int x_f = (int)Math.floor(image_x);
        int x_c = (int)Math.ceil(image_x);
        int y_f = (int)Math.floor(image_y);
        int y_c = (int)Math.ceil(image_y);
        int z_f = (int)Math.floor(image_z);
        int z_c = (int)Math.ceil(image_z);
        if (x_f < 0 || x_c < 0 || y_f < 0 || y_c < 0 || z_f < 0 || z_c < 0 || x_f >= width || x_c >= width || y_f >= height || y_c >= height || z_f >= depth || z_c >= depth) {
            fff = 0.0;
            cff = 0.0;
            fcf = 0.0;
            ccf = 0.0;
            ffc = 0.0;
            cfc = 0.0;
            fcc = 0.0;
            ccc = 0.0;
        } else {
            fff = v[z_f][width * y_f + x_f] & 0xFF;
            cff = v[z_c][width * y_f + x_f] & 0xFF;
            fcf = v[z_f][width * y_c + x_f] & 0xFF;
            ccf = v[z_c][width * y_c + x_f] & 0xFF;
            ffc = v[z_f][width * y_f + x_c] & 0xFF;
            cfc = v[z_c][width * y_f + x_c] & 0xFF;
            fcc = v[z_f][width * y_c + x_c] & 0xFF;
            ccc = v[z_c][width * y_c + x_c] & 0xFF;
        }
        double i1 = (1.0 - z_d) * fff + cff * z_d;
        double i2 = (1.0 - z_d) * fcf + ccf * z_d;
        double j1 = (1.0 - z_d) * ffc + cfc * z_d;
        double j2 = (1.0 - z_d) * fcc + ccc * z_d;
        double w1 = i1 * (1.0 - y_d) + i2 * y_d;
        double w2 = j1 * (1.0 - y_d) + j2 * y_d;
        double value_f = w1 * (1.0 - x_d) + w2 * x_d;
        int value = (int)Math.round(value_f);
        if (value < 0 || value > 255) {
            throw new RuntimeException("BUG: Out of range value!");
        }
        return (byte)value;
    }

    public ImagePlus transform(ImagePlus templateImage, ImagePlus modelImage) {
        int modelWidth = modelImage.getWidth();
        int modelHeight = modelImage.getHeight();
        int modelDepth = modelImage.getStackSize();
        double modelXSpacing = 1.0;
        double modelYSpacing = 1.0;
        double modelZSpacing = 1.0;
        Calibration modelCalibration = modelImage.getCalibration();
        if (modelCalibration != null) {
            modelXSpacing = modelCalibration.pixelWidth;
            modelYSpacing = modelCalibration.pixelHeight;
            modelZSpacing = modelCalibration.pixelDepth;
        }
        int templateWidth = templateImage.getWidth();
        int templateHeight = templateImage.getHeight();
        int templateDepth = templateImage.getStackSize();
        double templateXSpacing = 1.0;
        double templateYSpacing = 1.0;
        double templateZSpacing = 1.0;
        Calibration templateCalibration = templateImage.getCalibration();
        if (templateCalibration != null) {
            templateXSpacing = templateCalibration.pixelWidth;
            templateYSpacing = templateCalibration.pixelHeight;
            templateZSpacing = templateCalibration.pixelDepth;
        }
        IJ.showProgress((double)0.0);
        double[] result = new double[3];
        byte[][] imageBytes = new byte[templateDepth][templateWidth * templateHeight];
        ImageStack modelStack = modelImage.getStack();
        byte[][] modelBytes = new byte[modelDepth][];
        for (int z = 0; z < modelDepth; ++z) {
            modelBytes[z] = (byte[])modelStack.getPixels(z + 1);
        }
        for (int zi = 0; zi < templateDepth; ++zi) {
            for (int yi = 0; yi < templateHeight; ++yi) {
                for (int xi = 0; xi < templateWidth; ++xi) {
                    byte value;
                    double x = (double)xi * templateXSpacing;
                    double y = (double)yi * templateYSpacing;
                    double z = (double)zi * templateZSpacing;
                    this.transformPoint(x, y, z, result);
                    double xt = result[0];
                    double yt = result[1];
                    double zt = result[2];
                    imageBytes[zi][yi * templateWidth + xi] = value = this.trilinearInterpolateByte(xt / modelXSpacing, yt / modelYSpacing, zt / modelZSpacing, modelWidth, modelHeight, modelDepth, modelBytes);
                }
            }
            IJ.showProgress((double)((double)zi / (double)(templateDepth + 1)));
        }
        ImageStack newStack = new ImageStack(templateWidth, templateHeight);
        for (int z = 0; z < templateDepth; ++z) {
            ByteProcessor bp = new ByteProcessor(templateWidth, templateHeight);
            bp.setPixels((Object)imageBytes[z]);
            newStack.addSlice("", (ImageProcessor)bp);
        }
        IJ.showProgress((double)1.0);
        ImagePlus resultImage = new ImagePlus("Transformed", newStack);
        resultImage.setCalibration(templateCalibration);
        return resultImage;
    }

    public double bSpline(int l, double u) {
        switch (l) {
            case 0: {
                double oneMinusU = 1.0 - u;
                return oneMinusU * oneMinusU * oneMinusU / 6.0;
            }
            case 1: {
                return (3.0 * u * u * u - 6.0 * u * u + 4.0) / 6.0;
            }
            case 2: {
                return (-3.0 * u * u * u + 3.0 * u * u + 3.0 * u + 1.0) / 6.0;
            }
            case 3: {
                return u * u * u / 6.0;
            }
        }
        throw new RuntimeException("bSpline()'s first parameter must be one of 0, 1, 2 or 3");
    }

    public void transformPoint(double x, double y, double z, double[] result) {
        double cellxD = x / this.deltax;
        double cellyD = y / this.deltay;
        double cellzD = z / this.deltaz;
        int uncappedgridi = (int)cellxD;
        int uncappedgridj = (int)cellyD;
        int uncappedgridk = (int)cellzD;
        int gridi = Math.min(uncappedgridi, this.dimsx - 4);
        int gridj = Math.min(uncappedgridj, this.dimsy - 4);
        int gridk = Math.min(uncappedgridk, this.dimsz - 4);
        double u = cellxD - (double)gridi;
        double v = cellyD - (double)gridj;
        double w = cellzD - (double)gridk;
        result[0] = 0.0;
        result[1] = 0.0;
        result[2] = 0.0;
        for (int l = 0; l < 4; ++l) {
            for (int m = 0; m < 4; ++m) {
                for (int n = 0; n < 4; ++n) {
                    int c = gridi + l + this.dimsx * (gridj + m + this.dimsy * (gridk + n));
                    double splineProduct = this.bSpline(l, u) * this.bSpline(m, v) * this.bSpline(n, w);
                    result[0] = result[0] + splineProduct * this.coeffs[c][0];
                    result[1] = result[1] + splineProduct * this.coeffs[c][1];
                    result[2] = result[2] + splineProduct * this.coeffs[c][2];
                }
            }
        }
    }

    public static FastMatrix parseTypedStreamAffine(File f) {
        double tx = 0.0;
        double ty = 0.0;
        double tz = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rz = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double sz = 0.0;
        double shx = 0.0;
        double shy = 0.0;
        double shz = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String n = "([-\\.0-9]+)";
            String space = "[ \\t]+";
            String re = "^\t\t";
            re = re + "(xlate|rotate|scale|shear|center)";
            re = re + space + n + space + n + space + n;
            Pattern p = Pattern.compile(re);
            String line = br.readLine();
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    double a = Double.parseDouble(m.group(2));
                    double b = Double.parseDouble(m.group(3));
                    double c = Double.parseDouble(m.group(4));
                    String parameter = m.group(1);
                    if (parameter.equals("xlate")) {
                        tx = a;
                        ty = b;
                        tz = c;
                    } else if (parameter.equals("rotate")) {
                        rx = a;
                        ry = b;
                        rz = c;
                    } else if (parameter.equals("scale")) {
                        sx = a;
                        sy = b;
                        sz = c;
                    } else if (parameter.equals("shear")) {
                        shx = a;
                        shy = b;
                        shz = c;
                    } else if (parameter.equals("center")) {
                        cx = a;
                        cy = b;
                        cz = c;
                    }
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            IJ.error((String)("IOException in parseTypedStreamAffine: " + e));
            return null;
        }
        double alpha = CMTKTransformation.degToRad(rx);
        double theta = CMTKTransformation.degToRad(ry);
        double phi = CMTKTransformation.degToRad(rz);
        double cos0 = Math.cos(alpha);
        double sin0 = Math.sin(alpha);
        double cos1 = Math.cos(theta);
        double sin1 = Math.sin(theta);
        double cos2 = Math.cos(phi);
        double sin2 = Math.sin(phi);
        double sin0xsin1 = sin0 * sin1;
        double cos0xsin1 = cos0 * sin1;
        double[][] rval = new double[4][4];
        rval[0][0] = cos1 * cos2 * sx;
        rval[1][0] = -cos1 * sin2 * sx;
        rval[2][0] = -sin1 * sx;
        rval[3][0] = 0.0;
        rval[0][1] = (sin0xsin1 * cos2 + cos0 * sin2) * sy;
        rval[1][1] = (-sin0xsin1 * sin2 + cos0 * cos2) * sy;
        rval[2][1] = sin0 * cos1 * sy;
        rval[3][1] = 0.0;
        rval[0][2] = (cos0xsin1 * cos2 - sin0 * sin2) * sz;
        rval[1][2] = (-cos0xsin1 * sin2 - sin0 * cos2) * sz;
        rval[2][2] = cos0 * cos1 * sz;
        rval[3][2] = 0.0;
        rval[3][3] = 1.0;
        double[] shears = new double[]{shx, shy, shz};
        for (int i = 2; i >= 0; --i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray = rval[j];
                int n = i;
                dArray[n] = dArray[n] + shears[i] * rval[j][(i + 1) % 3];
            }
        }
        double[] cM = new double[]{cx * rval[0][0] + cy * rval[0][1] + cz * rval[0][2], cx * rval[1][0] + cy * rval[1][1] + cz * rval[1][2], cx * rval[2][0] + cy * rval[2][1] + cz * rval[2][2]};
        rval[0][3] = tx - cM[0] + cx;
        rval[1][3] = ty - cM[1] + cy;
        rval[2][3] = tz - cM[2] + cz;
        return new FastMatrix(rval);
    }

    public static CMTKTransformation parseTypedStreamWarp(File f) {
        String n = "([\\-.0-9]+)";
        Pattern pSplineSection = Pattern.compile("^[ \\t]+spline_warp \\{");
        Pattern pEndOfSection = Pattern.compile("^[ \\t]*}");
        Pattern pDims = Pattern.compile("^[ \\t]*dims " + n + " " + n + " " + n);
        Pattern pDomain = Pattern.compile("^[ \\t]*domain " + n + " " + n + " " + n);
        Pattern pOrigin = Pattern.compile("^[ \\t]*origin " + n + " " + n + " " + n);
        Pattern pCoefficients = Pattern.compile("^[ \\t]*coefficients " + n + " " + n + " " + n);
        Pattern pThreeNumbers = Pattern.compile("^[ \\t]+" + n + " " + n + " " + n);
        int dimsx = -1;
        int dimsy = -1;
        int dimsz = -1;
        double domainx = Double.MIN_VALUE;
        double domainy = Double.MIN_VALUE;
        double domainz = Double.MIN_VALUE;
        double originx = Double.MIN_VALUE;
        double originy = Double.MIN_VALUE;
        double originz = Double.MIN_VALUE;
        double[][] coeffs = null;
        try {
            String line;
            Matcher m;
            byte[] buf = new byte[2];
            InputStream is = new FileInputStream(f);
            ((InputStream)is).read(buf, 0, 2);
            ((InputStream)is).close();
            boolean compressed = buf[0] == 31 && buf[1] == -117;
            is = compressed ? new GZIPInputStream(new FileInputStream(f)) : new FileInputStream(f);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            do {
                if ((line = br.readLine()) != null) continue;
                IJ.error((String)("Couldn't find " + pSplineSection));
                br.close();
                return null;
            } while (!(m = pSplineSection.matcher(line)).find());
            do {
                if ((line = br.readLine()) != null) continue;
                IJ.error((String)("Couldn't find " + pEndOfSection));
                br.close();
                return null;
            } while (!(m = pEndOfSection.matcher(line)).find());
            while ((line = br.readLine()) != null) {
                m = pDomain.matcher(line);
                if (m.find()) {
                    domainx = Double.parseDouble(m.group(1));
                    domainy = Double.parseDouble(m.group(2));
                    domainz = Double.parseDouble(m.group(3));
                    continue;
                }
                m = pDims.matcher(line);
                if (m.find()) {
                    dimsx = Integer.parseInt(m.group(1));
                    dimsy = Integer.parseInt(m.group(2));
                    dimsz = Integer.parseInt(m.group(3));
                    continue;
                }
                m = pOrigin.matcher(line);
                if (m.find()) {
                    originx = Double.parseDouble(m.group(1));
                    originy = Double.parseDouble(m.group(2));
                    originz = Double.parseDouble(m.group(3));
                    continue;
                }
                m = pCoefficients.matcher(line);
                if (!m.find()) continue;
                if (dimsx < 0) {
                    IJ.error((String)"Failed: got 'coefficients' before 'dims'");
                    br.close();
                    return null;
                }
                coeffs = new double[dimsx * dimsy * dimsz][3];
                coeffs[0][0] = Double.parseDouble(m.group(1));
                coeffs[0][1] = Double.parseDouble(m.group(2));
                coeffs[0][2] = Double.parseDouble(m.group(3));
                int added = 1;
                while ((m = pThreeNumbers.matcher(line = br.readLine())).find()) {
                    coeffs[added][0] = Double.parseDouble(m.group(1));
                    coeffs[added][1] = Double.parseDouble(m.group(2));
                    coeffs[added][2] = Double.parseDouble(m.group(3));
                    ++added;
                }
                int pointsExpected = dimsx * dimsy * dimsz;
                if (pointsExpected == added) break;
                String error = "Number of coefficients (" + added + ") didn't match expected number (" + pointsExpected + ")";
                IJ.error((String)error);
                System.out.println("Error is: " + error);
                br.close();
                return null;
            }
            br.close();
        }
        catch (IOException e) {
            IJ.error((String)("IOException in parseTypedStreamWarp: " + e));
            return null;
        }
        if (domainx == Double.MIN_VALUE) {
            IJ.error((String)"Failed to find 'domain' line");
            return null;
        }
        if (originx == Double.MIN_VALUE) {
            IJ.error((String)"Failed to find 'origin' line");
            return null;
        }
        if (dimsx < 0) {
            IJ.error((String)"Failed to find 'dims' line");
            return null;
        }
        if (coeffs == null) {
            IJ.error((String)"Failed to find 'coefficients' line");
            return null;
        }
        CMTKTransformation result = new CMTKTransformation(dimsx, dimsy, dimsz, domainx, domainy, domainz, originx, originy, originz, coeffs);
        result.originalFile = f;
        return result;
    }

    public boolean precalculatedInverseExists() {
        if (this.originalFile == null) {
            throw new RuntimeException("Can't use find an inverse without originalFile being set");
        }
        File directoryOfOriginalFile = this.originalFile.getParentFile();
        File headerFile = new File(directoryOfOriginalFile, "inverse.nhdr");
        File xFile = new File(directoryOfOriginalFile, "inverse_x.gz");
        File yFile = new File(directoryOfOriginalFile, "inverse_y.gz");
        File zFile = new File(directoryOfOriginalFile, "inverse_z.gz");
        return headerFile.exists() && xFile.exists() && yFile.exists() && zFile.exists();
    }

    public Inverse inverse(ImagePlus template, ImagePlus model) {
        float[][] distanceSquared;
        short[][] templateZ;
        short[][] templateY;
        short[][] templateX;
        if (this.inverse != null) {
            return this.inverse;
        }
        if (this.originalFile == null) {
            throw new RuntimeException("Can't use CMTKTransformation.inverse without originalFile being set.");
        }
        File directoryOfOriginalFile = this.originalFile.getParentFile();
        File headerFile = new File(directoryOfOriginalFile, "inverse.nhdr");
        File xFile = new File(directoryOfOriginalFile, "inverse_x.gz");
        File yFile = new File(directoryOfOriginalFile, "inverse_y.gz");
        File zFile = new File(directoryOfOriginalFile, "inverse_z.gz");
        if (headerFile.exists() && xFile.exists() && yFile.exists() && zFile.exists()) {
            this.inverse = Inverse.load(headerFile, xFile, yFile, zFile, template, model);
            return this.inverse;
        }
        int modelWidth = model.getWidth();
        int modelHeight = model.getHeight();
        int modelDepth = model.getStackSize();
        int templateWidth = template.getWidth();
        int templateHeight = template.getHeight();
        int templateDepth = template.getStackSize();
        double templatePixelWidth = 1.0;
        double templatePixelHeight = 1.0;
        double templatePixelDepth = 1.0;
        Calibration templateCalibration = template.getCalibration();
        if (templateCalibration != null) {
            templatePixelWidth = templateCalibration.pixelWidth;
            templatePixelHeight = templateCalibration.pixelHeight;
            templatePixelDepth = templateCalibration.pixelDepth;
        }
        double modelPixelWidth = 1.0;
        double modelPixelHeight = 1.0;
        double modelPixelDepth = 1.0;
        Calibration modelCalibration = model.getCalibration();
        if (modelCalibration != null) {
            modelPixelWidth = modelCalibration.pixelWidth;
            modelPixelHeight = modelCalibration.pixelHeight;
            modelPixelDepth = modelCalibration.pixelDepth;
        }
        template.close();
        model.close();
        int pointsEitherSide = 3;
        try {
            templateX = new short[modelDepth][modelWidth * modelHeight];
            templateY = new short[modelDepth][modelWidth * modelHeight];
            templateZ = new short[modelDepth][modelWidth * modelHeight];
            distanceSquared = new float[modelDepth][modelWidth * modelHeight];
        }
        catch (OutOfMemoryError oome) {
            System.out.println("Got an OOME with: " + model + " - trying to struggle on");
            return null;
        }
        double[] transformed = new double[3];
        for (int z = 0; z < modelDepth; ++z) {
            for (int p = 0; p < modelWidth * modelHeight; ++p) {
                distanceSquared[z][p] = Float.MAX_VALUE;
                templateX[z][p] = Short.MIN_VALUE;
                templateY[z][p] = Short.MIN_VALUE;
                templateZ[z][p] = Short.MIN_VALUE;
            }
        }
        for (int tiz = 0; tiz < templateDepth; ++tiz) {
            System.out.println("New template z: " + tiz);
            for (int tiy = 0; tiy < templateHeight; ++tiy) {
                for (int tix = 0; tix < templateWidth; ++tix) {
                    double tx = (double)tix * templatePixelWidth;
                    double ty = (double)tiy * templatePixelHeight;
                    double tz = (double)tiz * templatePixelDepth;
                    this.transformPoint(tx, ty, tz, transformed);
                    double mx = transformed[0];
                    double my = transformed[1];
                    double mz = transformed[2];
                    int mix = (int)Math.round(mx / modelPixelWidth);
                    int miy = (int)Math.round(my / modelPixelHeight);
                    int miz = (int)Math.round(mz / modelPixelDepth);
                    for (int nearmiz = miz - pointsEitherSide; nearmiz <= miz + pointsEitherSide; ++nearmiz) {
                        for (int nearmiy = miy - pointsEitherSide; nearmiy <= miy + pointsEitherSide; ++nearmiy) {
                            for (int nearmix = mix - pointsEitherSide; nearmix <= mix + pointsEitherSide; ++nearmix) {
                                int pi;
                                double nearmz;
                                double zdiff;
                                double nearmy;
                                double ydiff;
                                double nearmx;
                                double xdiff;
                                double doubleDistanceSquared;
                                float ds;
                                if (nearmix < 0 || nearmiy < 0 || nearmiz < 0 || nearmix >= modelWidth || nearmiy >= modelHeight || nearmiz >= modelDepth || !((ds = (float)(doubleDistanceSquared = (xdiff = (nearmx = (double)nearmix * modelPixelWidth) - mx) * xdiff + (ydiff = (nearmy = (double)nearmiy * modelPixelHeight) - my) * ydiff + (zdiff = (nearmz = (double)nearmiz * modelPixelDepth) - mz) * zdiff)) < distanceSquared[nearmiz][pi = nearmiy * modelWidth + nearmix])) continue;
                                distanceSquared[nearmiz][pi] = ds;
                                templateX[nearmiz][pi] = (short)tix;
                                templateY[nearmiz][pi] = (short)tiy;
                                templateZ[nearmiz][pi] = (short)tiz;
                            }
                        }
                    }
                }
            }
        }
        try {
            System.out.println("Writing to " + headerFile.getAbsolutePath());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(headerFile), "UTF-8"));
            pw.println("NRRD0005");
            pw.println("type: short");
            pw.println("endian: big");
            pw.println("dimension: 4");
            pw.println("sizes: " + modelWidth + " " + modelHeight + " " + modelDepth + " 3");
            pw.println("encoding: gz");
            pw.println("data file: LIST");
            pw.println(xFile.getName());
            pw.println(yFile.getName());
            pw.println(zFile.getName());
            pw.close();
            System.out.println("  Writing to " + xFile.getAbsolutePath());
            System.out.println("  Writing to " + yFile.getAbsolutePath());
            System.out.println("  Writing to " + zFile.getAbsolutePath());
            DataOutputStream dosX = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(xFile)));
            DataOutputStream dosY = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(yFile)));
            DataOutputStream dosZ = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(zFile)));
            for (int miz = 0; miz < modelDepth; ++miz) {
                for (int miy = 0; miy < modelHeight; ++miy) {
                    for (int mix = 0; mix < modelWidth; ++mix) {
                        int pi = miy * modelWidth + mix;
                        if (distanceSquared[miz][pi] < Float.MAX_VALUE) {
                            dosX.writeShort(templateX[miz][pi]);
                            dosY.writeShort(templateY[miz][pi]);
                            dosZ.writeShort(templateZ[miz][pi]);
                            continue;
                        }
                        dosX.writeShort(Short.MIN_VALUE);
                        dosY.writeShort(Short.MIN_VALUE);
                        dosZ.writeShort(Short.MIN_VALUE);
                    }
                }
            }
            dosX.close();
            dosY.close();
            dosZ.close();
        }
        catch (IOException e) {
            IJ.error((String)("Writing the inverse to disk failed: " + e));
            e.printStackTrace();
        }
        templateX = null;
        templateY = null;
        templateZ = null;
        distanceSquared = null;
        System.gc();
        System.out.println("Loading back in now:");
        Inverse result = Inverse.load(headerFile, xFile, yFile, zFile, template, model);
        return result;
    }

    public static class Inverse {
        int modelWidth;
        int modelHeight;
        int modelDepth;
        int templateWidth;
        int templateHeight;
        int templateDepth;
        short[][] templateX;
        short[][] templateY;
        short[][] templateZ;
        Calibration templateCalibration;
        Calibration modelCalibration;
        double modelPixelWidth = 1.0;
        double modelPixelHeight = 1.0;
        double modelPixelDepth = 1.0;
        double templatePixelWidth = 1.0;
        double templatePixelHeight = 1.0;
        double templatePixelDepth = 1.0;

        public Inverse(ImagePlus template, ImagePlus model) {
            this.modelWidth = model.getWidth();
            this.modelHeight = model.getHeight();
            this.modelDepth = model.getStackSize();
            this.modelCalibration = model.getCalibration();
            if (this.modelCalibration != null) {
                this.modelPixelWidth = this.modelCalibration.pixelWidth;
                this.modelPixelHeight = this.modelCalibration.pixelHeight;
                this.modelPixelDepth = this.modelCalibration.pixelDepth;
            }
            this.templateWidth = template.getWidth();
            this.templateHeight = template.getHeight();
            this.templateDepth = template.getStackSize();
            this.templateCalibration = template.getCalibration();
            if (this.templateCalibration != null) {
                this.templatePixelWidth = this.templateCalibration.pixelWidth;
                this.templatePixelHeight = this.templateCalibration.pixelHeight;
                this.templatePixelDepth = this.templateCalibration.pixelDepth;
            }
            this.templateX = new short[this.modelDepth][this.modelWidth * this.modelHeight];
            this.templateY = new short[this.modelDepth][this.modelWidth * this.modelHeight];
            this.templateZ = new short[this.modelDepth][this.modelWidth * this.modelHeight];
        }

        public static Inverse load(File headerFile, File xFile, File yFile, File zFile, ImagePlus template, ImagePlus model) {
            int modelWidth = model.getWidth();
            int modelHeight = model.getHeight();
            int modelDepth = model.getStackSize();
            System.out.println("On loading, model is: " + model);
            System.out.println("Got modelDepth: " + modelDepth);
            Inverse result = null;
            long p = -1L;
            try {
                int i;
                NrrdHeader nh = null;
                NrrdInfo ni = null;
                nh = new NrrdHeader();
                nh.readHeader(headerFile.getAbsolutePath());
                ni = new NrrdInfo(nh);
                ni.parseHeader();
                int[] dimensions = ni.getIntegerFieldChecked("dimension", 1, true);
                if (dimensions[0] != 4) {
                    throw new Exception("The inverse file must have 4 dimensions (not " + dimensions[0] + ")");
                }
                String type = ni.getStandardType(ni.getStringFieldChecked("type", 1, true)[0]);
                if (!type.equals("int16")) {
                    throw new Exception("The inverse's data must be of type signed short (int16), not " + type);
                }
                long[] requiredSizes = new long[]{modelWidth, modelHeight, modelDepth, 3L};
                long[] sizes = ni.getLongFieldChecked("sizes", dimensions[0], true);
                if (!Arrays.equals(sizes, requiredSizes)) {
                    IJ.error((String)("Sizes in one of the dimensions didn't match - required [" + requiredSizes[0] + "," + requiredSizes[1] + "," + requiredSizes[2] + "," + requiredSizes[3] + "] but got[" + sizes[0] + "," + sizes[1] + "," + sizes[2] + "," + sizes[3] + "]"));
                }
                if (ni.dataFiles.length != 3) {
                    throw new Exception("There must be exactly three data files, not: " + ni.dataFiles.length);
                }
                for (i = 0; i < ni.dataFiles.length; ++i) {
                    System.out.println("ni.dataFiles[" + i + "] is '" + ni.dataFiles[i] + "'");
                }
                result = new Inverse(template, model);
                for (i = 0; i < ni.dataFiles.length; ++i) {
                    File f = ni.dataFiles[i];
                    short[][] target = null;
                    switch (i) {
                        case 0: {
                            target = result.templateX;
                            break;
                        }
                        case 1: {
                            target = result.templateY;
                            break;
                        }
                        case 2: {
                            target = result.templateZ;
                            break;
                        }
                        default: {
                            throw new RuntimeException("BUG: i is surprising (" + i + ")");
                        }
                    }
                    DataInputStream dis = new DataInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))));
                    long expectedShorts = modelWidth * modelHeight * modelDepth;
                    for (p = 0L; p < expectedShorts; ++p) {
                        int modelX = (int)(p % (long)modelWidth);
                        int modelY = (int)(p / (long)modelWidth % (long)modelHeight);
                        int modelZ = (int)(p / (long)(modelWidth * modelHeight) % (long)modelDepth);
                        target[modelZ][modelY * modelWidth + modelX] = dis.readShort();
                    }
                    dis.close();
                }
            }
            catch (Exception e) {
                IJ.error((String)("There was an error loading the CMTK inverse: " + e));
                System.out.println("p was: " + p);
                e.printStackTrace();
                return null;
            }
            return result;
        }

        public void transformPoint(double modelX, double modelY, double modelZ, double[] transformed) {
            int mix = (int)Math.round(modelX / this.modelPixelWidth);
            int miy = (int)Math.round(modelY / this.modelPixelHeight);
            int miz = (int)Math.round(modelZ / this.modelPixelDepth);
            if (mix < 0 || miy < 0 || miz < 0 || mix >= this.modelWidth || miy >= this.modelHeight || miz >= this.modelDepth) {
                transformed[0] = Double.NaN;
                transformed[1] = Double.NaN;
                transformed[2] = Double.NaN;
            } else {
                short transformedX = this.templateX[miz][miy * this.modelWidth + mix];
                short transformedY = this.templateY[miz][miy * this.modelWidth + mix];
                short transformedZ = this.templateZ[miz][miy * this.modelWidth + mix];
                if (transformedX == Short.MIN_VALUE || transformedY == Short.MIN_VALUE || transformedZ == Short.MIN_VALUE) {
                    transformed[0] = Double.NaN;
                    transformed[1] = Double.NaN;
                    transformed[2] = Double.NaN;
                } else {
                    transformed[0] = (double)transformedX * this.templatePixelWidth;
                    transformed[1] = (double)transformedY * this.templatePixelHeight;
                    transformed[2] = (double)transformedZ * this.templatePixelDepth;
                }
            }
        }

        public void transformPoint(double modelX, double modelY, double modelZ, int[] transformed) {
            int mix = (int)Math.round(modelX / this.modelPixelWidth);
            int miy = (int)Math.round(modelY / this.modelPixelHeight);
            int miz = (int)Math.round(modelZ / this.modelPixelDepth);
            if (mix < 0 || miy < 0 || miz < 0 || mix >= this.modelWidth || miy >= this.modelHeight || miz >= this.modelDepth) {
                transformed[0] = Integer.MIN_VALUE;
                transformed[1] = Integer.MIN_VALUE;
                transformed[2] = Integer.MIN_VALUE;
            } else {
                int transformedX = this.templateX[miz][miy * this.modelWidth + mix];
                int transformedY = this.templateY[miz][miy * this.modelWidth + mix];
                int transformedZ = this.templateZ[miz][miy * this.modelWidth + mix];
                if (transformedX == Short.MIN_VALUE || transformedY == Short.MIN_VALUE || transformedZ == Short.MIN_VALUE) {
                    transformed[0] = Integer.MIN_VALUE;
                    transformed[1] = Integer.MIN_VALUE;
                    transformed[2] = Integer.MIN_VALUE;
                } else {
                    transformed[0] = transformedX;
                    transformed[1] = transformedY;
                    transformed[2] = transformedZ;
                }
            }
        }

        public void transformPoint(int modelX, int modelY, int modelZ, int[] transformed) {
            int mix = modelX;
            int miy = modelY;
            int miz = modelZ;
            if (mix < 0 || miy < 0 || miz < 0 || mix >= this.modelWidth || miy >= this.modelHeight || miz >= this.modelDepth) {
                transformed[0] = Integer.MIN_VALUE;
                transformed[1] = Integer.MIN_VALUE;
                transformed[2] = Integer.MIN_VALUE;
            } else {
                int transformedX = this.templateX[miz][miy * this.modelWidth + mix];
                int transformedY = this.templateY[miz][miy * this.modelWidth + mix];
                int transformedZ = this.templateZ[miz][miy * this.modelWidth + mix];
                if (transformedX == Short.MIN_VALUE || transformedY == Short.MIN_VALUE || transformedZ == Short.MIN_VALUE) {
                    transformed[0] = Integer.MIN_VALUE;
                    transformed[1] = Integer.MIN_VALUE;
                    transformed[2] = Integer.MIN_VALUE;
                } else {
                    transformed[0] = transformedX;
                    transformed[1] = transformedY;
                    transformed[2] = transformedZ;
                }
            }
        }

        public void transformPoint(int modelX, int modelY, int modelZ, double[] transformed) {
            int mix = modelX;
            int miy = modelY;
            int miz = modelZ;
            if (mix < 0 || miy < 0 || miz < 0 || mix >= this.modelWidth || miy >= this.modelHeight || miz >= this.modelDepth) {
                transformed[0] = Double.NaN;
                transformed[1] = Double.NaN;
                transformed[2] = Double.NaN;
            } else {
                short transformedX = this.templateX[miz][miy * this.modelWidth + mix];
                short transformedY = this.templateY[miz][miy * this.modelWidth + mix];
                short transformedZ = this.templateZ[miz][miy * this.modelWidth + mix];
                if (transformedX == Short.MIN_VALUE || transformedY == Short.MIN_VALUE || transformedZ == Short.MIN_VALUE) {
                    transformed[0] = Double.NaN;
                    transformed[1] = Double.NaN;
                    transformed[2] = Double.NaN;
                } else {
                    transformed[0] = (double)transformedX * this.templatePixelWidth;
                    transformed[1] = (double)transformedY * this.templatePixelHeight;
                    transformed[2] = (double)transformedZ * this.templatePixelDepth;
                }
            }
        }

        public ImagePlus transformImage(ImagePlus template, ImagePlus model) {
            boolean debug = false;
            int modelWidth = model.getWidth();
            int modelHeight = model.getHeight();
            int modelDepth = model.getStackSize();
            int templateWidth = template.getWidth();
            int templateHeight = template.getHeight();
            int templateDepth = template.getStackSize();
            Calibration templateCalibration = template.getCalibration();
            byte[][] transformedData = new byte[templateDepth][templateWidth * templateHeight];
            int[] transformed = new int[3];
            byte[][] originalData = new byte[modelDepth][];
            ImageStack stack = model.getStack();
            for (int z = 0; z < modelDepth; ++z) {
                originalData[z] = (byte[])stack.getPixels(z + 1);
            }
            byte[][] foundMappingData = null;
            if (debug) {
                foundMappingData = new byte[modelDepth][modelWidth * modelHeight];
            }
            for (int z = 0; z < modelDepth; ++z) {
                for (int y = 0; y < modelHeight; ++y) {
                    for (int x = 0; x < modelWidth; ++x) {
                        this.transformPoint(x, y, z, transformed);
                        int nx = transformed[0];
                        int ny = transformed[1];
                        int nz = transformed[2];
                        if (nx < 0 || ny < 0 || nz < 0 || nx >= templateWidth || ny >= templateHeight || nz >= templateDepth) continue;
                        if (debug) {
                            foundMappingData[z][y * modelWidth + x] = -1;
                        }
                        transformedData[nz][ny * templateWidth + nx] = originalData[z][y * modelWidth + x];
                    }
                }
            }
            ImageStack newStack = new ImageStack(templateWidth, templateHeight);
            for (int z = 0; z < templateDepth; ++z) {
                ByteProcessor bp = new ByteProcessor(templateWidth, templateHeight);
                bp.setPixels((Object)transformedData[z]);
                newStack.addSlice("", (ImageProcessor)bp);
            }
            ImagePlus result = new ImagePlus("Transformed " + model.getTitle(), newStack);
            result.setCalibration(templateCalibration);
            if (debug) {
                ImageStack debugStack = new ImageStack(modelWidth, modelHeight);
                for (int z = 0; z < modelDepth; ++z) {
                    ByteProcessor bp = new ByteProcessor(modelWidth, modelHeight);
                    bp.setPixels((Object)foundMappingData[z]);
                    debugStack.addSlice("", (ImageProcessor)bp);
                }
                ImagePlus debugImage = new ImagePlus("Debug Stack", debugStack);
                debugImage.show();
            }
            return result;
        }
    }
}

