/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.fxwidgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ListView;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import sc.fiji.filamentdetector.gui.controller.Controller;
import sc.fiji.filamentdetector.gui.fxwidgets.ReorderableListCell;

public class ReorderablePaneListView
extends ListView<Pane> {
    private Pane selectedPane = null;

    public <T extends Controller> ReorderablePaneListView() {
        new ReorderablePaneListView(null);
    }

    public <T extends Controller> ReorderablePaneListView(List<T> controllers) {
        this.setStyle(".table-row-cell:empty {\n    -fx-background-color: transparent;\n}");
        this.setCellFactory(param -> {
            ReorderableListCell cell = new ReorderableListCell();
            cell.setOnDragDetected(event -> {
                if (cell.isBlockReorder()) {
                    return;
                }
                if (cell.getItem() == null) {
                    return;
                }
                Image image = this.getPaneImage((Pane)cell.getItem());
                Dragboard dragboard = cell.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                ClipboardContent content = new ClipboardContent();
                content.putString("");
                dragboard.setContent((Map)content);
                dragboard.setDragView(image);
                dragboard.setDragViewOffsetY(image.getHeight() / 2.0);
                this.selectedPane = (Pane)cell.getItem();
                this.getSelectionModel().clearSelection();
                event.consume();
            });
            cell.setOnDragOver(event -> {
                if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
                }
                event.consume();
            });
            cell.setOnDragEntered(event -> {
                if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                    cell.setOpacity(0.3);
                }
            });
            cell.setOnDragExited(event -> {
                if (event.getGestureSource() != cell && event.getDragboard().hasString()) {
                    cell.setOpacity(1.0);
                }
            });
            cell.setOnDragDropped(event -> {
                if (cell.getItem() == null) {
                    return;
                }
                boolean success = false;
                Dragboard dragboard = event.getDragboard();
                if (dragboard.hasString()) {
                    ObservableList items = cell.getListView().getItems();
                    int draggedIdx = items.indexOf((Object)this.selectedPane);
                    int thisIdx = items.indexOf(cell.getItem());
                    items.set(draggedIdx, cell.getItem());
                    items.set(thisIdx, (Object)this.selectedPane);
                    ArrayList itemscopy = new ArrayList(cell.getListView().getItems());
                    cell.getListView().getItems().setAll(itemscopy);
                    if (controllers != null) {
                        Controller controller1 = (Controller)controllers.get(draggedIdx);
                        Controller controller2 = (Controller)controllers.get(thisIdx);
                        controllers.set(thisIdx, controller1);
                        controllers.set(draggedIdx, controller2);
                    }
                    success = true;
                }
                this.selectedPane = null;
                event.setDropCompleted(success);
                event.consume();
            });
            cell.setOnDragDone(Event::consume);
            return cell;
        });
        if (controllers != null) {
            for (Controller controller : controllers) {
                this.getItems().add((Object)controller.loadPane());
            }
        }
    }

    private Image getPaneImage(Pane pane) {
        WritableImage snapshotImage = new WritableImage((int)pane.getWidth(), (int)pane.getHeight());
        pane.snapshot(null, snapshotImage);
        Canvas canvas = new Canvas((double)((int)pane.getWidth()), (double)((int)pane.getHeight()));
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setFill((Paint)Color.BLACK);
        gc.fillRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        gc.setGlobalBlendMode(BlendMode.SCREEN);
        gc.setGlobalAlpha(0.7);
        gc.drawImage((Image)snapshotImage, 0.0, 0.0);
        WritableImage finalImage = new WritableImage((int)canvas.getWidth(), (int)canvas.getHeight());
        canvas.snapshot(null, finalImage);
        return finalImage;
    }
}

