/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

public class Util {
    private static final void clipHistogram(int[] hist, int[] clippedHist, int limit) {
        int clippedEntriesBefore;
        System.arraycopy(hist, 0, clippedHist, 0, hist.length);
        int clippedEntries = 0;
        do {
            clippedEntriesBefore = clippedEntries;
            clippedEntries = 0;
            for (int i = 0; i < hist.length; ++i) {
                int d = clippedHist[i] - limit;
                if (d <= 0) continue;
                clippedEntries += d;
                clippedHist[i] = limit;
            }
            int d = clippedEntries / hist.length;
            int m = clippedEntries % hist.length;
            int i = 0;
            while (i < hist.length) {
                int n = i++;
                clippedHist[n] = clippedHist[n] + d;
            }
            if (m == 0) continue;
            int s = (hist.length - 1) / m;
            for (int i2 = s / 2; i2 < hist.length; i2 += s) {
                int n = i2;
                clippedHist[n] = clippedHist[n] + 1;
            }
        } while (clippedEntries != clippedEntriesBefore);
    }

    static final float[] createTransfer(int[] hist, int limit) {
        int[] cdfs = new int[hist.length];
        Util.clipHistogram(hist, cdfs, limit);
        int hMin = hist.length - 1;
        for (int i = 0; i < hMin; ++i) {
            if (cdfs[i] == 0) continue;
            hMin = i;
        }
        int cdf = 0;
        for (int i = hMin; i < hist.length; ++i) {
            cdfs[i] = cdf += cdfs[i];
        }
        int cdfMin = cdfs[hMin];
        int cdfMax = cdfs[hist.length - 1];
        float[] transfer = new float[hist.length];
        for (int i = 0; i < transfer.length; ++i) {
            transfer[i] = (float)(cdfs[i] - cdfMin) / (float)(cdfMax - cdfMin);
        }
        return transfer;
    }

    public static final float transferValue(int v, int[] clippedHist) {
        int hMin = clippedHist.length - 1;
        for (int i = 0; i < hMin; ++i) {
            if (clippedHist[i] == 0) continue;
            hMin = i;
        }
        int cdf = 0;
        for (int i = hMin; i <= v; ++i) {
            cdf += clippedHist[i];
        }
        int cdfMax = cdf;
        for (int i = v + 1; i < clippedHist.length; ++i) {
            cdfMax += clippedHist[i];
        }
        int cdfMin = clippedHist[hMin];
        return (float)(cdf - cdfMin) / (float)(cdfMax - cdfMin);
    }

    public static final float transferValue(int v, int[] hist, int[] clippedHist, int limit) {
        Util.clipHistogram(hist, clippedHist, limit);
        return Util.transferValue(v, clippedHist);
    }
}

