/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import oldsegmenters.SegmentatorModel;

public class LabelBrush_
implements PlugIn {
    public static final String MACRO_CMD = "var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}";

    public void run(String arg) {
        System.out.println("run of LabelBrush_ ...");
        if (IJ.versionLessThan((String)"1.37c")) {
            System.err.println("Version too old");
            return;
        }
        System.out.println("loading LabelBrushTool");
        MacroInstaller installer = new MacroInstaller();
        installer.install(MACRO_CMD);
    }

    public static synchronized void label(String x, String y, String z, String flags, String width) {
        LabelBrush_.label((int)Float.parseFloat(x), (int)Float.parseFloat(y), (int)Float.parseFloat(z), (int)Float.parseFloat(flags), (int)Float.parseFloat(width));
    }

    public static synchronized void unlabel(String x, String y, String z, String flags, String width) {
        LabelBrush_.unlabel((int)Float.parseFloat(x), (int)Float.parseFloat(y), (int)Float.parseFloat(z), (int)Float.parseFloat(flags), (int)Float.parseFloat(width));
    }

    public static void label(int x, int y, int z, int flags, int width) {
        LabelBrush_.labelROI(LabelBrush_.getBrushRoi(x, y, width), LabelBrush_.getProcessor(++z), LabelBrush_.getColor());
        LabelBrush_.updateSlice(z);
    }

    public static void unlabel(int x, int y, int z, int flags, int width) {
        LabelBrush_.labelROI(LabelBrush_.getBrushRoi(x, y, width), LabelBrush_.getProcessor(++z), 0);
        LabelBrush_.updateSlice(z);
    }

    private static ImageProcessor getProcessor(int z) {
        return new SegmentatorModel(IJ.getImage()).getLabelImagePlus().getStack().getProcessor(z);
    }

    public static String getLabelMessage() {
        String message;
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            IJ.error((String)"showLabel: No current image.");
            return "";
        }
        ImageCanvas ic = imp.getCanvas();
        Point p = ic.getCursorLoc();
        int x = p.x;
        int y = p.y;
        int z = imp.getCurrentSlice() - 1;
        ImagePlus labelImagePlus = new SegmentatorModel(imp).getLabelImagePlus();
        if (labelImagePlus == null) {
            IJ.error((String)"showLabel: No label field for this image.");
            return "No label field found for: " + imp.getTitle();
        }
        ImageProcessor ip = labelImagePlus.getStack().getProcessor(z + 1);
        int color = ip.getPixel(x, y);
        if (color == 255) {
            message = "No label at (" + x + "," + y + "," + z + ") in " + labelImagePlus.getTitle();
        } else {
            AmiraParameters materials = new SegmentatorModel(IJ.getImage()).getMaterialParams();
            String materialName = materials.getMaterialName(color);
            message = "Current material is: " + materialName + " at (" + x + "," + y + "," + z + ") in " + labelImagePlus.getTitle();
        }
        return message;
    }

    private static int getColor() {
        AmiraParameters.Material material = new SegmentatorModel(IJ.getImage()).getCurrentMaterial();
        if (material == null) {
            return 0;
        }
        return material.id;
    }

    private static void updateSlice(int z) {
        new SegmentatorModel(IJ.getImage()).updateSlice(z);
    }

    public static Roi getBrushRoi(int x, int y, int width) {
        return new OvalRoi(x - width / 2, y - width / 2, width, width);
    }

    public static void labelROI(Roi roi, ImageProcessor ip, int color) {
        Rectangle bounds = roi.getBounds();
        for (int i = bounds.x; i <= bounds.x + bounds.width; ++i) {
            for (int j = bounds.y; j <= bounds.y + bounds.height; ++j) {
                if (!roi.contains(i, j)) continue;
                ip.set(i, j, color);
            }
        }
    }
}

