/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.NamedObjectException;
import org.jogamp.java3d.utils.scenegraph.io.UnsupportedUniverseException;
import org.jogamp.java3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import org.jogamp.java3d.utils.universe.SimpleUniverse;

public class SceneGraphFileWriter {
    private RandomAccessFileControl fileControl = new RandomAccessFileControl();
    private File file;

    public SceneGraphFileWriter(File file, SimpleUniverse universe, boolean writeUniverseContent, String fileDescription, Serializable fileUserData) throws IOException, UnsupportedUniverseException {
        this.file = file;
        file.createNewFile();
        if (!file.canWrite()) {
            throw new IOException("Can not Write to File");
        }
        this.fileControl.createFile(file, universe, writeUniverseContent, fileDescription, fileUserData);
    }

    public void writeBranchGraph(BranchGroup graph) throws IOException {
        this.writeBranchGraph(graph, null);
    }

    public void writeBranchGraph(BranchGroup graph, Serializable data) throws IOException {
        this.fileControl.writeBranchGraph(graph, data);
    }

    public void addObjectName(String name, SceneGraphObject object) throws NamedObjectException {
        this.fileControl.addNamedObject(name, object);
    }

    public void close() throws IOException {
        this.fileControl.close();
    }
}

