/*
 * Decompiled with CFR 0.152.
 */
package io.scif.bf.wrapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public class DataHandleAdapter
extends RandomAccessInputStream
implements IRandomAccess {
    private final DataHandle<Location> handle;

    public DataHandleAdapter(DataHandle<Location> handle) throws IOException {
        super(new byte[1]);
        this.handle = handle;
    }

    public DataHandle<Location> unwrap() {
        return this.handle;
    }

    public void setEncoding(String encoding) {
        this.handle.setEncoding(encoding);
    }

    public void seek(long pos) throws IOException {
        if (this.handle != null) {
            this.handle.seek(pos);
        }
    }

    public long length() throws IOException {
        return this.handle.length();
    }

    public void setLength(long newLength) throws IOException {
        this.handle.setLength(newLength);
    }

    public long getFilePointer() throws IOException {
        return this.handle.offset();
    }

    public boolean exists() throws IOException {
        return this.handle.exists();
    }

    public void close() throws IOException {
        this.handle.close();
    }

    public void order(boolean little) {
        this.handle.setLittleEndian(little);
    }

    public boolean isLittleEndian() {
        return this.handle.isLittleEndian();
    }

    public String readString(String lastChars) throws IOException {
        return this.handle.readString(lastChars);
    }

    public String findString(String ... terminators) throws IOException {
        return this.handle.findString(terminators);
    }

    public String findString(boolean saveString, String ... terminators) throws IOException {
        return this.handle.findString(saveString, terminators);
    }

    public String findString(int blockSize, String ... terminators) throws IOException {
        return this.handle.findString(blockSize, terminators);
    }

    public String findString(boolean saveString, int blockSize, String ... terminators) throws IOException {
        return this.handle.findString(saveString, blockSize, terminators);
    }

    public boolean readBoolean() throws IOException {
        return this.handle.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.handle.readByte();
    }

    public char readChar() throws IOException {
        return this.handle.readChar();
    }

    public double readDouble() throws IOException {
        return this.handle.readDouble();
    }

    public float readFloat() throws IOException {
        return this.handle.readFloat();
    }

    public int readInt() throws IOException {
        return this.handle.readInt();
    }

    public String readLine() throws IOException {
        return this.handle.readLine();
    }

    public String readCString() throws IOException {
        return this.handle.readCString();
    }

    public String readString(int n) throws IOException {
        return this.handle.readString(n);
    }

    public long readLong() throws IOException {
        return this.handle.readLong();
    }

    public short readShort() throws IOException {
        return this.handle.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.handle.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.handle.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.handle.readUTF();
    }

    public int skipBytes(int n) throws IOException {
        return this.handle.skipBytes(n);
    }

    public int read(byte[] array) throws IOException {
        return this.handle.read(array);
    }

    public int read(byte[] array, int offset, int n) throws IOException {
        return this.handle.read(array, offset, n);
    }

    public int read(ByteBuffer buf) throws IOException {
        return this.handle.read(buf.array());
    }

    public int read(ByteBuffer buf, int offset, int n) throws IOException {
        return this.handle.read(buf.array(), offset, n);
    }

    public void readFully(byte[] array) throws IOException {
        this.handle.readFully(array);
    }

    public void readFully(byte[] array, int offset, int n) throws IOException {
        this.handle.readFully(array, offset, n);
    }

    public int read() throws IOException {
        return this.handle.read();
    }

    public int available() throws IOException {
        if (this.handle.offset() < this.handle.length()) {
            return (int)(this.handle.offset() - this.handle.length());
        }
        return 0;
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        this.handle.seek(0L);
    }

    public void write(int b) throws IOException {
        throw this.readOnly();
    }

    private IOException readOnly() {
        return new IOException("DataHandleAdapter is read-only!");
    }

    public void write(byte[] b) throws IOException {
        throw this.readOnly();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        throw this.readOnly();
    }

    public void writeBoolean(boolean v) throws IOException {
        throw this.readOnly();
    }

    public void writeByte(int v) throws IOException {
        throw this.readOnly();
    }

    public void writeShort(int v) throws IOException {
        throw this.readOnly();
    }

    public void writeChar(int v) throws IOException {
        throw this.readOnly();
    }

    public void writeInt(int v) throws IOException {
        throw this.readOnly();
    }

    public void writeLong(long v) throws IOException {
        throw this.readOnly();
    }

    public void writeFloat(float v) throws IOException {
        throw this.readOnly();
    }

    public void writeDouble(double v) throws IOException {
        throw this.readOnly();
    }

    public void writeBytes(String s) throws IOException {
        throw this.readOnly();
    }

    public void writeChars(String s) throws IOException {
        throw this.readOnly();
    }

    public void writeUTF(String s) throws IOException {
        throw this.readOnly();
    }

    public ByteOrder getOrder() {
        return this.handle.isLittleEndian() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public void setOrder(ByteOrder order) {
        this.handle.setLittleEndian(order == ByteOrder.LITTLE_ENDIAN);
    }

    public void write(ByteBuffer buf) throws IOException {
        throw this.readOnly();
    }

    public void write(ByteBuffer buf, int off, int len) throws IOException {
        throw this.readOnly();
    }
}

