/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.morph;

import java.util.ArrayList;
import net.imglib2.AbstractCursor;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.ops.operation.iterable.unary.Max;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;

@Deprecated
public class StructuringElementCursor<T extends Type<T>>
extends AbstractCursor<T> {
    private final RandomAccess<T> m_access;
    private final long[] m_center;
    private final long[][] m_struc;
    private final int m_numStrucDimensions;
    private int m_i;

    public static <I extends IntegerType<I>> long[][] createElementFromImg(Img<I> kernel) {
        int max = ((IntegerType)new Max().compute(kernel.cursor(), (RealType)((IntegerType)kernel.firstElement()).createVariable())).getInteger();
        long[] origin = new long[kernel.numDimensions()];
        boolean customOrigin = false;
        if (max > 1) {
            Cursor c = kernel.cursor();
            while (c.hasNext()) {
                if (((IntegerType)c.next()).getInteger() <= 1) continue;
                c.localize(origin);
                customOrigin = true;
                break;
            }
        }
        if (max == 1 || !customOrigin) {
            kernel.dimensions(origin);
            for (int i = 0; i < origin.length; ++i) {
                origin[i] = origin[i] / 2L;
            }
        }
        long[] off = new long[kernel.numDimensions()];
        ArrayList<Object> offsets = new ArrayList<Object>();
        Cursor c = kernel.cursor();
        while (c.hasNext()) {
            if (((IntegerType)c.next()).getInteger() <= 0) continue;
            c.localize(off);
            for (int i = 0; i < off.length; ++i) {
                off[i] = off[i] - origin[i];
            }
            offsets.add(off.clone());
        }
        long[][] struc = new long[offsets.size()][];
        offsets.toArray((T[])struc);
        return struc;
    }

    public static boolean is4Connected(long[][] struct) {
        for (int i = 0; i < struct.length; ++i) {
            if (i > 0 && struct[i - 1].length != struct[i].length) {
                return false;
            }
            double sum = 0.0;
            for (int j = 0; j < struct.length; ++j) {
                sum += (double)(struct[i][j] * struct[i][j]);
            }
            if (!(Math.sqrt(sum) > 1.0)) continue;
            return false;
        }
        return struct.length == 2 * struct[0].length + 1;
    }

    public static boolean is8Connected(long[][] struct) {
        for (int i = 0; i < struct.length; ++i) {
            if (i > 0 && struct[i - 1].length != struct[i].length) {
                return false;
            }
            double sum = 0.0;
            for (int j = 0; j < struct.length; ++j) {
                sum += (double)(struct[i][j] * struct[i][j]);
            }
            if (!(Math.sqrt(sum) > Math.sqrt(2.0))) continue;
            return false;
        }
        return struct.length == (int)Math.pow(3.0, struct[0].length);
    }

    public StructuringElementCursor(RandomAccessible<T> accessible, Img<BitType> structuringElement) {
        this(accessible, StructuringElementCursor.createElementFromImg(structuringElement));
    }

    public StructuringElementCursor(RandomAccess<T> access, Img<BitType> structuringElement) {
        this(access, StructuringElementCursor.createElementFromImg(structuringElement));
    }

    public StructuringElementCursor(RandomAccessible<T> accessible, StructuringElementCursor<?> structuringCursor) {
        this(accessible, structuringCursor.m_struc);
    }

    public StructuringElementCursor(RandomAccess<T> access, StructuringElementCursor<?> structuringCursor) {
        this(access, structuringCursor.m_struc);
    }

    public StructuringElementCursor(RandomAccessible<T> accessible, long[][] structuringElement) {
        this(accessible.randomAccess(), structuringElement);
    }

    public StructuringElementCursor(RandomAccess<T> access, long[][] structuringElement) {
        super(access.numDimensions());
        this.m_access = access;
        this.m_center = new long[access.numDimensions()];
        this.m_struc = structuringElement;
        this.m_numStrucDimensions = this.m_struc[0].length;
    }

    public void relocate(Localizable center) {
        center.localize(this.m_center);
        this.reset();
    }

    public void relocate(long[] center) {
        System.arraycopy(center, 0, this.m_center, 0, this.m_center.length);
        this.reset();
    }

    public T get() {
        return (T)((Type)this.m_access.get());
    }

    public void fwd() {
        ++this.m_i;
        for (int i = 0; i < this.m_numStrucDimensions; ++i) {
            this.m_access.setPosition(this.m_center[i] + this.m_struc[this.m_i][i], i);
        }
    }

    public void reset() {
        this.m_access.setPosition(this.m_center);
        this.m_i = -1;
    }

    public boolean hasNext() {
        return this.m_i < this.m_struc.length - 1;
    }

    public void localize(long[] position) {
        this.m_access.localize(position);
    }

    public long getLongPosition(int d) {
        return this.m_access.getLongPosition(d);
    }

    public AbstractCursor<T> copy() {
        return this.copyCursor();
    }

    public AbstractCursor<T> copyCursor() {
        return new StructuringElementCursor<T>(this.m_access.copyRandomAccess(), this.m_struc);
    }
}

