/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.event.UndoableEditListener;
import net.imagej.ui.swing.overlay.IJDelegationSelectionTool;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.AbstractTool;

public class ToolDelegator
extends AbstractTool {
    private static final long serialVersionUID = 1L;
    protected JHotDrawTool selectionTool = new IJDelegationSelectionTool();
    protected JHotDrawTool creationTool;
    protected JHotDrawTool activeTool;
    private boolean selection;

    public ToolDelegator() {
        for (Object listener : this.listenerList.getListenerList()) {
            if (listener instanceof ToolListener) {
                this.selectionTool.addToolListener((ToolListener)listener);
            }
            if (!(listener instanceof UndoableEditListener)) continue;
            this.selectionTool.addUndoableEditListener((UndoableEditListener)listener);
        }
        this.selectionTool.setInputMap(this.getInputMap());
        this.selectionTool.setActionMap(this.getActionMap());
        this.selection = false;
    }

    public void setSelection(boolean val) {
        this.selection = val;
    }

    public void setCreationTool(JHotDrawTool creationTool) {
        this.creationTool = creationTool;
        if (creationTool == null) {
            return;
        }
        for (Object listener : this.listenerList.getListenerList()) {
            if (listener instanceof ToolListener) {
                creationTool.addToolListener((ToolListener)listener);
                continue;
            }
            if (!(listener instanceof UndoableEditListener)) continue;
            creationTool.addUndoableEditListener((UndoableEditListener)listener);
        }
        creationTool.setInputMap(this.getInputMap());
        creationTool.setActionMap(this.getActionMap());
    }

    public void draw(Graphics2D graphics) {
        if (this.activeTool != null) {
            this.activeTool.draw(graphics);
        }
    }

    public void mouseMoved(MouseEvent event) {
        this.maybeSwitchTool(event);
        if (this.activeTool != null) {
            this.activeTool.mouseMoved(event);
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (this.activeTool != null) {
            this.activeTool.mouseClicked(event);
        }
    }

    public void mousePressed(MouseEvent event) {
        this.maybeSwitchTool(event);
        if (this.activeTool != null) {
            this.activeTool.mousePressed(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.activeTool != null) {
            this.activeTool.mouseReleased(event);
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.activeTool != null) {
            this.activeTool.mouseDragged(event);
        }
    }

    public void mouseEntered(MouseEvent event) {
        this.maybeSwitchTool(event);
        if (this.activeTool != null) {
            this.activeTool.mouseEntered(event);
        }
    }

    public void mouseExited(MouseEvent event) {
        this.maybeSwitchTool(event);
        if (this.activeTool != null) {
            this.activeTool.mouseExited(event);
        }
    }

    public void activate(DrawingEditor editer) {
        super.activate(editer);
        if (this.activeTool != null) {
            this.activeTool.activate(editer);
        }
    }

    public void deactivate(DrawingEditor editer) {
        if (this.activeTool != null) {
            this.activeTool.deactivate(editer);
        }
        super.deactivate(editer);
    }

    public void addToolListener(ToolListener listener) {
        super.addToolListener(listener);
        this.selectionTool.addToolListener(listener);
        if (this.creationTool != null) {
            this.creationTool.addToolListener(listener);
        }
    }

    public void removeToolListener(ToolListener listener) {
        super.removeToolListener(listener);
        this.selectionTool.removeToolListener(listener);
        if (this.creationTool != null) {
            this.creationTool.removeToolListener(listener);
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        super.addUndoableEditListener(listener);
        this.selectionTool.addUndoableEditListener(listener);
        if (this.creationTool != null) {
            this.creationTool.addUndoableEditListener(listener);
        }
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        super.removeUndoableEditListener(listener);
        this.selectionTool.removeUndoableEditListener(listener);
        if (this.creationTool != null) {
            this.creationTool.removeUndoableEditListener(listener);
        }
    }

    public void setInputMap(InputMap map) {
        super.setInputMap(map);
        if (this.selectionTool != null) {
            this.selectionTool.setInputMap(map);
        }
        if (this.creationTool != null) {
            this.creationTool.setInputMap(map);
        }
    }

    public void setActionMap(ActionMap map) {
        super.setActionMap(map);
        if (this.selectionTool != null) {
            this.selectionTool.setActionMap(map);
        }
        if (this.creationTool != null) {
            this.creationTool.setActionMap(map);
        }
    }

    public boolean supportsHandleInteraction() {
        return true;
    }

    protected boolean maybeSwitchTool(MouseEvent event) {
        if (this.activeTool != null && this.activeTool.isConstructing()) {
            return false;
        }
        this.anchor = new Point(event.getX(), event.getY());
        JHotDrawTool tool = this.creationTool;
        DrawingView view = this.getView();
        if (view != null && view.isEnabled() && (view.findHandle(this.anchor) != null || view.findFigure(this.anchor) != null && view.findFigure(this.anchor).isSelectable())) {
            tool = this.selection ? this.selectionTool : null;
        }
        if (this.activeTool != tool) {
            if (this.activeTool != null) {
                this.activeTool.deactivate(this.getEditor());
            }
            if (tool != null) {
                tool.activate(this.getEditor());
                if (!this.isActive()) {
                    tool.deactivate(this.getEditor());
                }
            }
            this.activeTool = tool;
            return true;
        }
        return false;
    }
}

