/*
 * Decompiled with CFR 0.152.
 */
package io.scif.common;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateTools {
    public static final int UNIX = 0;
    public static final int COBOL = 1;
    public static final int MICROSOFT = 2;
    public static final int ZVI = 3;
    public static final int ALT_ZVI = 4;
    public static final long UNIX_EPOCH = 0L;
    public static final long COBOL_EPOCH = 11644473600000L;
    public static final long MICROSOFT_EPOCH = 2209143600000L;
    public static final long ZVI_EPOCH = 2921084975759000L;
    public static final long ALT_ZVI_EPOCH = 2921084284761000L;
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    private DateTools() {
    }

    public static long getMillisFromTicks(long hi, long lo) {
        long ticks = hi << 32 | lo;
        return ticks / 10000L;
    }

    public static String convertDate(long stamp, int format) {
        return DateTools.convertDate(stamp, format, ISO8601_FORMAT);
    }

    public static String convertDate(long stamp, int format, String outputFormat) {
        return DateTools.convertDate(stamp, format, outputFormat, false);
    }

    public static String convertDate(long stamp, int format, String outputFormat, boolean correctTimeZoneForGMT) {
        long ms = stamp;
        switch (format) {
            case 0: {
                ms -= 0L;
                break;
            }
            case 1: {
                ms -= 11644473600000L;
                break;
            }
            case 2: {
                ms -= 2209143600000L;
                break;
            }
            case 3: {
                ms -= 2921084975759000L;
                break;
            }
            case 4: {
                ms -= 2921084284761000L;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat(outputFormat);
        if (correctTimeZoneForGMT) {
            TimeZone tz = TimeZone.getDefault();
            ms -= (long)tz.getOffset(ms);
        }
        StringBuffer sb = new StringBuffer();
        Date d = new Date(ms);
        fmt.format(d, sb, new FieldPosition(0));
        return sb.toString();
    }

    public static String formatDate(String date, String format) {
        return DateTools.formatDate(date, format, false);
    }

    public static String formatDate(String date, String format, boolean lenient) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(lenient);
        Date d = sdf.parse(date, new ParsePosition(0));
        if (d == null) {
            return null;
        }
        sdf = new SimpleDateFormat(ISO8601_FORMAT);
        return sdf.format(d);
    }

    public static String formatDate(String date, String[] formats) {
        return DateTools.formatDate(date, formats, false);
    }

    public static String formatDate(String date, String[] formats, boolean lenient) {
        for (String format : formats) {
            String result = DateTools.formatDate(date, format, lenient);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static long getTime(String date, String format) {
        SimpleDateFormat f = new SimpleDateFormat(format);
        Date d = f.parse(date, new ParsePosition(0));
        if (d == null) {
            return -1L;
        }
        return d.getTime();
    }
}

