/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.FormatException;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.TiffService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.util.Bytes;

@Plugin(type=Service.class)
public class DefaultTiffService
extends AbstractService
implements TiffService {
    @Parameter
    private LogService log;

    @Override
    public void difference(byte[] input, IFD ifd) throws FormatException {
        int predictor = ifd.getIFDIntValue(317, 1);
        if (predictor == 2) {
            this.log.debug((Object)"performing horizontal differencing");
            int[] bitsPerSample = ifd.getBitsPerSample();
            long width = ifd.getImageWidth();
            boolean little = ifd.isLittleEndian();
            int planarConfig = ifd.getPlanarConfiguration();
            int bytes = ifd.getBytesPerSample()[0];
            int len = bytes * (planarConfig == 2 ? 1 : bitsPerSample.length);
            for (int b = input.length - bytes; b >= 0; b -= bytes) {
                if ((long)(b / len) % width == 0L) continue;
                int value = Bytes.toInt((byte[])input, (int)b, (int)bytes, (boolean)little);
                Bytes.unpack((long)(value -= Bytes.toInt((byte[])input, (int)(b - len), (int)bytes, (boolean)little)), (byte[])input, (int)b, (int)bytes, (boolean)little);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }

    @Override
    public void undifference(byte[] input, IFD ifd) throws FormatException {
        int predictor = ifd.getIFDIntValue(317, 1);
        if (predictor == 2) {
            this.log.debug((Object)"reversing horizontal differencing");
            int[] bitsPerSample = ifd.getBitsPerSample();
            int len = bitsPerSample.length;
            long width = ifd.getImageWidth();
            boolean little = ifd.isLittleEndian();
            int planarConfig = ifd.getPlanarConfiguration();
            int bytes = ifd.getBytesPerSample()[0];
            if (planarConfig == 2 || bitsPerSample[len - 1] == 0) {
                len = 1;
            }
            len *= bytes;
            for (int b = 0; b <= input.length - bytes; b += bytes) {
                if ((long)(b / len) % width == 0L) continue;
                int value = Bytes.toInt((byte[])input, (int)b, (int)bytes, (boolean)little);
                Bytes.unpack((long)(value += Bytes.toInt((byte[])input, (int)(b - len), (int)bytes, (boolean)little)), (byte[])input, (int)b, (int)bytes, (boolean)little);
            }
        } else if (predictor != 1) {
            throw new FormatException("Unknown Predictor (" + predictor + ")");
        }
    }
}

