/*
 * Decompiled with CFR 0.152.
 */
package io.scif.io.location;

import io.scif.MetadataService;
import io.scif.io.location.TestImgLocation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.scijava.io.location.AbstractLocationResolver;
import org.scijava.io.location.LocationResolver;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=LocationResolver.class, priority=100.0)
public class TestImgLocationResolver
extends AbstractLocationResolver {
    @Parameter
    private MetadataService meta;

    public TestImgLocationResolver() {
        super(new String[]{"scifioTestImg"});
    }

    public boolean supports(URI uri) {
        String scheme = uri.getScheme();
        return "scifioTestImg".equals(scheme) || "file".equals(scheme) && uri.getPath().endsWith(".fake");
    }

    public TestImgLocation resolve(URI uri) throws URISyntaxException {
        String data;
        switch (uri.getScheme()) {
            case "scifioTestImg": {
                data = uri.getHost() + "&" + uri.getQuery();
                break;
            }
            case "file": {
                String path = uri.getPath();
                data = path.substring(0, path.length() - 5);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid scheme: " + uri.getScheme());
            }
        }
        Map<String, Object> map = this.meta.parse(data);
        return TestImgLocation.fromMap(map);
    }
}

