/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformList;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.TransformMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.ExportedTile;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;
import mpicbg.trakem2.util.Pair;

public class ExportUnsignedShort {
    protected static final ShortProcessor mapIntensities(PatchIntensityRange pir, double min, double max) {
        double a = 65535.0 / (max - min);
        ImageProcessor source = pir.patch.getImageProcessor();
        short[] targetPixels = new short[source.getWidth() * source.getHeight()];
        for (int i = 0; i < targetPixels.length; ++i) {
            targetPixels[i] = (short)Math.max(0L, Math.min(65535L, Math.round((((double)source.getf(i) - pir.patch.getMin()) / pir.a - min) * a)));
        }
        ShortProcessor target = new ShortProcessor(source.getWidth(), source.getHeight(), targetPixels, null);
        target.setMinAndMax(-min * a, (1.0 - min) * a);
        return target;
    }

    protected static final void map(PatchTransform pt, double x, double y, ShortProcessor mappedIntensities, ShortProcessor target) {
        ExportUnsignedShort.map(pt, x, y, Double.NaN, mappedIntensities, target);
    }

    protected static final void map(PatchTransform pt, double x, double y, double scale, ShortProcessor mappedIntensities, ShortProcessor target) {
        ExportUnsignedShort.map(pt, x, y, Double.NaN, mappedIntensities, target, null);
    }

    protected static final void map(PatchTransform pt, double x, double y, double scale, ShortProcessor mappedIntensities, ShortProcessor target, ByteProcessor alphaTarget) {
        TranslationModel2D t = new TranslationModel2D();
        t.set(-x, -y);
        CoordinateTransformList ctl = new CoordinateTransformList();
        ctl.add(pt.ct);
        if (!Double.isNaN(scale)) {
            AffineModel2D s = new AffineModel2D();
            s.set(scale, 0.0, 0.0, scale, 0.0, 0.0);
            ctl.add((CoordinateTransform)s);
        }
        ctl.add((CoordinateTransform)t);
        CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)ctl, pt.pir.patch.getMeshResolution(), (double)pt.pir.patch.getOWidth(), (double)pt.pir.patch.getOHeight());
        TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)mesh);
        ByteProcessor alpha = null;
        mappedIntensities.setInterpolationMethod(1);
        if (pt.pir.patch.hasAlphaMask()) {
            alpha = pt.pir.patch.getAlphaMask();
            alpha.setInterpolationMethod(1);
            mapping.map(mappedIntensities, alpha, target);
        } else {
            mapping.mapInterpolated((ImageProcessor)mappedIntensities, (ImageProcessor)target);
        }
        if (null != alphaTarget) {
            if (null == alpha) {
                alpha = new ByteProcessor(pt.pir.patch.getOWidth(), pt.pir.patch.getOHeight());
                alpha.setInterpolationMethod(1);
                byte[] as = (byte[])alpha.getPixels();
                for (int i = 0; i < as.length; ++i) {
                    as[i] = -1;
                }
            }
            mapping.mapInterpolated((ImageProcessor)alpha, (ImageProcessor)alphaTarget);
        }
    }

    public static final void exportTEST(Layer layer, int tileWidth, int tileHeight) {
        ArrayList<Displayable> patches = layer.getDisplayables(Patch.class);
        ArrayList<PatchIntensityRange> patchIntensityRanges = new ArrayList<PatchIntensityRange>();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (Displayable d : patches) {
            Patch patch = (Patch)d;
            PatchIntensityRange pir = new PatchIntensityRange(patch);
            if (pir.min < min) {
                min = pir.min;
            }
            if (pir.max > max) {
                max = pir.max;
            }
            patchIntensityRanges.add(pir);
        }
        ImageStack stack = new ImageStack(tileWidth, tileHeight);
        ImagePlus imp = null;
        double minI = -min * 65535.0 / (max - min);
        double maxI = (1.0 - min) * 65535.0 / (max - min);
        int nc = (int)Math.ceil(layer.getLayerWidth() / (float)tileWidth);
        int nr = (int)Math.ceil(layer.getLayerHeight() / (float)tileHeight);
        for (int r = 0; r < nr; ++r) {
            int y0 = r * tileHeight;
            for (int c = 0; c < nc; ++c) {
                int x0 = c * tileWidth;
                Rectangle box = new Rectangle(x0, y0, tileWidth, tileHeight);
                ShortProcessor sp = new ShortProcessor(tileWidth, tileHeight);
                sp.setMinAndMax(minI, maxI);
                for (PatchIntensityRange pir : patchIntensityRanges) {
                    if (!pir.patch.getBoundingBox().intersects(box)) continue;
                    ExportUnsignedShort.map(new PatchTransform(pir), x0, y0, ExportUnsignedShort.mapIntensities(pir, min, max), sp);
                }
                stack.addSlice(r + ", " + c, (ImageProcessor)sp);
                if (null == imp && stack.getSize() > 1) {
                    imp = new ImagePlus("tiles", stack);
                    imp.show();
                }
                if (null == imp) continue;
                imp.setSlice(stack.getSize());
                imp.updateAndDraw();
            }
        }
        if (null == imp) {
            new ImagePlus("tiles", stack).show();
        }
    }

    public static final Iterable<Callable<ExportedTile>> exportTiles(Layer layer, final int tileWidth, final int tileHeight, boolean visible_only) {
        ArrayList<Displayable> patches = layer.getDisplayables(Patch.class, visible_only);
        if (patches.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<PatchIntensityRange> patchIntensityRanges = new ArrayList<PatchIntensityRange>();
        double min_ = Double.MAX_VALUE;
        double max_ = -1.7976931348623157E308;
        for (Displayable d : patches) {
            Patch patch = (Patch)d;
            PatchIntensityRange pir = new PatchIntensityRange(patch);
            if (pir.min < min_) {
                min_ = pir.min;
            }
            if (pir.max > max_) {
                max_ = pir.max;
            }
            patchIntensityRanges.add(pir);
        }
        final double min = min_;
        final double max = max_;
        final Rectangle box = layer.getMinimalBoundingBox(Patch.class, visible_only).intersection(layer.getParent().get2DBounds());
        final int nCols = (int)Math.ceil((double)box.width / (double)tileWidth);
        final int nRows = (int)Math.ceil((double)box.height / (double)tileHeight);
        final double minI = -min * 65535.0 / (max - min);
        final double maxI = (1.0 - min) * 65535.0 / (max - min);
        return new Iterable<Callable<ExportedTile>>(){

            @Override
            public Iterator<Callable<ExportedTile>> iterator() {
                return new Iterator<Callable<ExportedTile>>(){
                    private int row = 0;
                    private int col = 0;
                    private int x0;
                    private int y0;
                    private final ArrayList<PatchIntensityRange> ps;
                    {
                        this.x0 = box.x;
                        this.y0 = box.y;
                        this.ps = new ArrayList();
                        this.findNext();
                    }

                    private final void findNext() {
                        this.ps.clear();
                        while (nRows != this.row) {
                            this.x0 = box.x + this.col * tileWidth;
                            this.y0 = box.y + this.row * tileHeight;
                            Rectangle tileBounds = new Rectangle(this.x0, this.y0, tileWidth, tileHeight);
                            for (PatchIntensityRange pir : patchIntensityRanges) {
                                if (!pir.patch.getBoundingBox().intersects(tileBounds)) continue;
                                this.ps.add(pir);
                            }
                            ++this.col;
                            if (nCols == this.col) {
                                this.col = 0;
                                ++this.row;
                            }
                            if (this.ps.size() <= 0) continue;
                            break;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.ps.size() > 0;
                    }

                    @Override
                    public Callable<ExportedTile> next() {
                        final ArrayList<PatchIntensityRange> pirs = new ArrayList<PatchIntensityRange>(this.ps);
                        final int x = this.x0;
                        final int y = this.y0;
                        this.findNext();
                        return new Callable<ExportedTile>(){

                            @Override
                            public ExportedTile call() throws Exception {
                                ShortProcessor sp = new ShortProcessor(tileWidth, tileHeight);
                                sp.setMinAndMax(minI, maxI);
                                for (PatchIntensityRange pir : pirs) {
                                    ExportUnsignedShort.map(new PatchTransform(pir), x, y, ExportUnsignedShort.mapIntensities(pir, min, max), sp);
                                }
                                return new ExportedTile(sp, x, y, minI, maxI);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static final ShortProcessor makeFlatImage(List<Patch> patches, Rectangle roi) {
        return ExportUnsignedShort.makeFlatImage(patches, roi, 0.0, Double.NaN);
    }

    public static final ShortProcessor makeFlatImage(List<Patch> patches, Rectangle roi, double backgroundValue) {
        return ExportUnsignedShort.makeFlatImage(patches, roi, backgroundValue, Double.NaN);
    }

    public static final ShortProcessor makeFlatImage(List<Patch> patches, Rectangle roi, double backgroundValue, double scale) {
        return (ShortProcessor)ExportUnsignedShort.makeFlatImage(patches, (Rectangle)roi, (double)backgroundValue, (double)scale, (boolean)false).a;
    }

    public static final Pair<ShortProcessor, ByteProcessor> makeFlatImage(List<Patch> patches, Rectangle roi, double backgroundValue, double scale, boolean makeAlphaMask) {
        ArrayList<PatchIntensityRange> patchIntensityRanges = new ArrayList<PatchIntensityRange>();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (Displayable displayable : patches) {
            Patch patch = (Patch)displayable;
            PatchIntensityRange pir = new PatchIntensityRange(patch);
            if (pir.min < min) {
                min = pir.min;
            }
            if (pir.max > max) {
                max = pir.max;
            }
            patchIntensityRanges.add(pir);
        }
        double minI = -min * 65535.0 / (max - min);
        double maxI = (1.0 - min) * 65535.0 / (max - min);
        ShortProcessor sp = Double.isNaN(scale) ? new ShortProcessor(roi.width, roi.height) : new ShortProcessor((int)((double)roi.width * scale + 0.5), (int)((double)roi.height * scale + 0.5));
        sp.setMinAndMax(minI, maxI);
        if (0.0 != backgroundValue) {
            sp.setValue(backgroundValue);
            sp.setRoi(0, 0, roi.width, roi.height);
            sp.fill();
        }
        ByteProcessor alphaTarget = makeAlphaMask ? new ByteProcessor(sp.getWidth(), sp.getHeight()) : null;
        for (PatchIntensityRange pir : patchIntensityRanges) {
            ExportUnsignedShort.map(new PatchTransform(pir), roi.x, roi.y, scale, ExportUnsignedShort.mapIntensities(pir, min, max), sp, alphaTarget);
        }
        return new Pair((Object)sp, (Object)alphaTarget);
    }

    public static final ImageStack makeFlatImageStack(List<Layer> layers, Rectangle roi, double backgroundValue) {
        ImageStack stack = new ImageStack(roi.width, roi.height);
        for (Layer layer : layers) {
            stack.addSlice("", (ImageProcessor)ExportUnsignedShort.makeFlatImage(layer.getDisplayables(Patch.class, true), roi, backgroundValue));
        }
        return stack;
    }

    protected static class PatchTransform {
        final PatchIntensityRange pir;
        final CoordinateTransform ct;

        PatchTransform(PatchIntensityRange pir) {
            this.pir = pir;
            this.ct = pir.patch.getFullCoordinateTransform();
        }
    }

    protected static class PatchIntensityRange {
        public final Patch patch;
        public final double a;
        public final double min;
        public final double max;

        PatchIntensityRange(Patch patch) {
            this.patch = patch;
            this.a = patch.getMax() - patch.getMin();
            ImageProcessor ip = patch.getImageProcessor();
            ip.resetMinAndMax();
            this.min = (ip.getMin() - patch.getMin()) / this.a;
            this.max = (ip.getMax() - patch.getMin()) / this.a;
            ip.setMinAndMax(patch.getMin(), patch.getMax());
        }
    }
}

