/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.python;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.launcher.Config;
import org.scijava.log.LogService;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripting.python.RebuildEnvironment;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import org.scijava.widget.Button;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Python...", weight=10.0)})
public class OptionsPython
extends OptionsPlugin {
    private static final String DEFAULT_PYIMAGEJ = "pyimagej>=1.7.0";
    private static final String DEFAULT_APPOSE = "appose>=0.7.2";
    @Parameter
    private AppService appService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private LogService log;
    @Parameter(label="Python environment directory", persist=false)
    private File pythonDir;
    @Parameter(label="Conda dependencies", style="text area", persist=false)
    private String condaDependencies;
    @Parameter(label="Pip dependencies", style="text area", persist=false)
    private String pipDependencies;
    @Parameter(label="Build Python environment", callback="rebuildEnv")
    private Button rebuildEnvironment;
    @Parameter(label="Launch in Python mode", callback="updatePythonConfig", persist=false)
    private boolean pythonMode;
    @Parameter(required=false)
    private UIService uiService;
    private String pyimagejDependency;
    private String apposeDependency;
    private boolean initialPythonMode = false;
    private String initialCondaDependencies;
    private String initialPipDependencies;

    public File getPythonDir() {
        return this.pythonDir;
    }

    public boolean isPythonMode() {
        return this.pythonMode;
    }

    public void setPythonDir(File pythonDir) {
        if (pythonDir == null) {
            this.pythonDir = null;
        } else {
            String path = pythonDir.getPath();
            if (path != null) {
                path = (path = path.trim().replaceAll("^[\\s<>]+|[\\s<>]+$", "")).length() > 2 && path.charAt(1) == ':' ? path.substring(0, 2) + path.substring(2).replace(":", "") : path.replace(":", "");
                path = path.replaceAll("[\n\r\t]", "");
            }
            this.pythonDir = new File(path);
        }
    }

    public void setPythonMode(boolean pythonMode) {
        this.pythonMode = pythonMode;
    }

    @Override
    public void load() {
        File configFile;
        String configFileProp = System.getProperty("scijava.app.config-file");
        File file = configFile = configFileProp == null ? null : new File(configFileProp);
        if (configFile != null && configFile.canRead()) {
            try {
                String cfgLaunchMode;
                Map<String, String> config = Config.load(configFile);
                String cfgPythonDir = config.get("python-dir");
                if (cfgPythonDir != null) {
                    Path appPath = this.appService.getApp().getBaseDirectory().toPath();
                    this.pythonDir = OptionsPython.stringToFile(appPath, cfgPythonDir);
                }
                if ((cfgLaunchMode = config.get("launch-mode")) != null) {
                    this.pythonMode = cfgLaunchMode.equals("PYTHON");
                }
            }
            catch (IOException e) {
                this.log.debug(e);
            }
        }
        if (this.pythonDir == null) {
            String javaPlatform = System.getProperty("scijava.app.java-platform");
            String platform = javaPlatform != null ? javaPlatform : System.getProperty("os.name") + "-" + System.getProperty("os.arch");
            Path pythonPath = this.appService.getApp().getBaseDirectory().toPath().resolve("python").resolve(platform);
            this.pythonDir = pythonPath.toFile();
        }
        this.initialPythonMode = this.pythonMode;
        this.condaDependencies = "";
        this.pipDependencies = "";
        this.pyimagejDependency = null;
        this.apposeDependency = null;
        HashSet<String> pipBlacklist = new HashSet<String>();
        pipBlacklist.add("appose");
        pipBlacklist.add("pyimagej");
        File envFile = this.getEnvironmentYamlFile();
        if (envFile.exists()) {
            try {
                List<String> lines = Files.readAllLines(envFile.toPath());
                boolean inDeps = false;
                boolean inPip = false;
                StringJoiner condaDeps = new StringJoiner("\n");
                StringJoiner pipDeps = new StringJoiner("\n");
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (trimmed.startsWith("#") || trimmed.isEmpty()) continue;
                    if (trimmed.startsWith("dependencies:")) {
                        inDeps = true;
                        continue;
                    }
                    if (inDeps && trimmed.startsWith("- pip")) {
                        inPip = true;
                        continue;
                    }
                    if (inDeps && trimmed.startsWith("- ") && !inPip) {
                        String dep = trimmed.substring(2).trim();
                        if (dep.equals("pip")) continue;
                        condaDeps.add(dep);
                        continue;
                    }
                    if (inPip && trimmed.startsWith("- ")) {
                        String pipDep = trimmed.substring(2).trim();
                        if (pipDep.startsWith("pyimagej")) {
                            this.pyimagejDependency = pipDep;
                            continue;
                        }
                        if (pipDep.contains("appose")) {
                            this.apposeDependency = pipDep;
                            continue;
                        }
                        boolean blacklisted = false;
                        for (String bad : pipBlacklist) {
                            if (!pipDep.contains(bad)) continue;
                            blacklisted = true;
                            break;
                        }
                        if (blacklisted) continue;
                        pipDeps.add(pipDep);
                        continue;
                    }
                    if (inDeps && !trimmed.startsWith("- ") && !trimmed.isEmpty()) {
                        inDeps = false;
                    }
                    if (!inPip || trimmed.startsWith("- ") && !trimmed.isEmpty()) continue;
                    inPip = false;
                }
                this.condaDependencies = condaDeps.toString().trim();
                this.pipDependencies = pipDeps.toString().trim();
                this.initialCondaDependencies = this.condaDependencies;
                this.initialPipDependencies = this.pipDependencies;
            }
            catch (Exception e) {
                this.log.debug("Could not read environment.yml: " + e.getMessage());
            }
        }
    }

    public void rebuildEnv() {
        File environmentYaml = this.writeEnvironmentYaml();
        this.commandService.run(RebuildEnvironment.class, true, "environmentYaml", environmentYaml, "targetDir", this.pythonDir);
    }

    private File getEnvironmentYamlFile() {
        Path appPath = this.appService.getApp().getBaseDirectory().toPath();
        File environmentYaml = appPath.resolve("config").resolve("environment.yml").toFile();
        String pythonEnvFileProp = System.getProperty("scijava.app.python-env-file");
        if (pythonEnvFileProp != null) {
            environmentYaml = OptionsPython.stringToFile(appPath, pythonEnvFileProp);
        }
        return environmentYaml;
    }

    @Override
    public void save() {
        this.setPythonDir(this.pythonDir);
        String configFileProp = System.getProperty("scijava.app.config-file");
        if (configFileProp == null) {
            return;
        }
        File configFile = new File(configFileProp);
        Map<String, String> config = null;
        if (configFile.isFile()) {
            try {
                config = Config.load(configFile);
            }
            catch (IOException exc) {
                this.log.debug(exc);
            }
        }
        if (config == null) {
            config = new LinkedHashMap<String, String>();
        }
        Path appPath = this.appService.getApp().getBaseDirectory().toPath();
        config.put("python-dir", OptionsPython.fileToString(appPath, this.pythonDir));
        config.put("launch-mode", this.pythonMode ? "PYTHON" : "JVM");
        try {
            Config.save(configFile, config);
        }
        catch (IOException exc) {
            this.log.debug(exc);
        }
        if (this.pythonMode && (this.pythonDir == null || !this.pythonDir.exists())) {
            this.rebuildEnv();
        } else {
            this.writeEnvironmentYaml();
        }
        if (!this.initialPythonMode && this.pythonMode && this.uiService != null) {
            String msg = "You have just enabled Python mode. Please restart for these changes to take effect\n(once your Python environment has finished initializing).\n\nIf Fiji fails to start, try deleting your configuration file and restarting.\n\nConfiguration file: " + configFile;
            this.uiService.showDialog(msg, "Python Mode Enabled", DialogPrompt.MessageType.WARNING_MESSAGE);
        }
    }

    private File writeEnvironmentYaml() {
        File envFile = this.getEnvironmentYamlFile();
        if (this.initialCondaDependencies.equals(this.condaDependencies) && this.initialPipDependencies.equals(this.pipDependencies)) {
            return envFile;
        }
        this.initialCondaDependencies = this.condaDependencies;
        this.initialPipDependencies = this.pipDependencies;
        try {
            String name = "fiji";
            String[] channels = new String[]{"conda-forge"};
            StringBuilder yml = new StringBuilder();
            yml.append("name: ").append(name).append("\nchannels:\n");
            for (String ch : channels) {
                yml.append("  - ").append(ch).append("\n");
            }
            yml.append("dependencies:\n");
            for (String dep : this.condaDependencies.split("\n")) {
                String trimmed = dep.trim();
                if (trimmed.isEmpty()) continue;
                yml.append("  - ").append(trimmed).append("\n");
            }
            yml.append("  - pip\n");
            yml.append("  - pip:\n");
            boolean foundPyimagej = false;
            boolean foundAppose = false;
            for (String dep : this.pipDependencies.split("\n")) {
                String trimmed = dep.trim();
                if (trimmed.isEmpty()) continue;
                if (trimmed.startsWith("pyimagej")) {
                    foundPyimagej = true;
                }
                if (trimmed.contains("appose")) {
                    foundAppose = true;
                }
                yml.append("    - ").append(trimmed).append("\n");
            }
            if (!foundPyimagej) {
                String pyimagej = this.pyimagejDependency != null ? this.pyimagejDependency : DEFAULT_PYIMAGEJ;
                yml.append("    - ").append(pyimagej).append("\n");
            }
            if (!foundAppose) {
                String appose = this.apposeDependency != null ? this.apposeDependency : DEFAULT_APPOSE;
                yml.append("    - ").append(appose).append("\n");
            }
            Files.write(envFile.toPath(), yml.toString().getBytes(), new OpenOption[0]);
            this.pyimagejDependency = null;
            this.apposeDependency = null;
        }
        catch (Exception e) {
            this.log.debug("Could not write environment.yml: " + e.getMessage());
        }
        return envFile;
    }

    static File stringToFile(Path baseDir, String value) {
        Path path = Paths.get(value, new String[0]);
        Path absPath = path.isAbsolute() ? path : baseDir.resolve(path);
        return absPath.toFile();
    }

    static String fileToString(Path baseDir, File file) {
        Path filePath = file.toPath();
        Path relPath = filePath.startsWith(baseDir) ? baseDir.relativize(filePath) : filePath.toAbsolutePath();
        return relPath.toString();
    }
}

