/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.icp;

import fiji.util.KDTree;
import fiji.util.NearestNeighborSearch;
import fiji.util.node.Leaf;
import java.util.ArrayList;
import java.util.List;
import mpicbg.icp.PointMatchIdentification;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;

public class SimplePointMatchIdentification<P extends Point>
implements PointMatchIdentification<P> {
    double distanceThresold;

    public SimplePointMatchIdentification(double distanceThreshold) {
        this.distanceThresold = distanceThreshold;
    }

    public SimplePointMatchIdentification() {
        this.distanceThresold = Double.MAX_VALUE;
    }

    public void setDistanceThreshold(double distanceThreshold) {
        this.distanceThresold = distanceThreshold;
    }

    public double getDistanceThreshold() {
        return this.distanceThresold;
    }

    public ArrayList<PointMatch> assignPointMatches(List<P> target, List<P> reference) {
        ArrayList<PointMatch> pointMatches = new ArrayList<PointMatch>();
        KDTree kdTreeTarget = new KDTree(target);
        NearestNeighborSearch nnSearchTarget = new NearestNeighborSearch(kdTreeTarget);
        for (Point point : reference) {
            Point correspondingPoint = (Point)nnSearchTarget.findNearestNeighbor((Leaf)point);
            if (!((double)((Leaf)correspondingPoint).distanceTo((Leaf)point) <= this.distanceThresold)) continue;
            pointMatches.add(new PointMatch(correspondingPoint, point));
        }
        return pointMatches;
    }
}

