/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.fusion.AverageContentFactory;
import mpicbg.spim.fusion.BlendingSimpleFactory;
import mpicbg.spim.fusion.EntropyFastFactory;
import mpicbg.spim.fusion.GaussContentFactory;
import mpicbg.spim.fusion.MappingFusionParalell;
import mpicbg.spim.fusion.MappingFusionSequential;
import mpicbg.spim.fusion.MappingFusionSequentialDifferentOutput;
import mpicbg.spim.fusion.PreDeconvolutionFusion;
import mpicbg.spim.fusion.PreDeconvolutionFusionSequential;
import mpicbg.spim.fusion.SPIMImageFusion;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;

public class FusionControl {
    SPIMImageFusion fusion;

    public SPIMImageFusion getFusion() {
        return this.fusion;
    }

    public void fuse(ViewStructure viewStructure, int timePoint) {
        this.fuse(viewStructure, viewStructure, timePoint);
    }

    public void fuse(ViewStructure viewStructure, ViewStructure referenceViewStructure, int timePoint) {
        SPIMConfiguration conf = viewStructure.getSPIMConfiguration();
        ArrayList isolatedWeightenerFactories = new ArrayList();
        ArrayList combinedWeightenerFactories = new ArrayList();
        if (conf.useEntropy) {
            isolatedWeightenerFactories.add(new EntropyFastFactory(conf.processImageFactory));
        }
        if (conf.useGaussContentBased) {
            isolatedWeightenerFactories.add(new GaussContentFactory(conf.processImageFactory));
        }
        if (conf.useIntegralContentBased) {
            isolatedWeightenerFactories.add(new AverageContentFactory(conf.processImageFactory));
        }
        if (conf.useLinearBlening) {
            if (conf.isDeconvolution) {
                combinedWeightenerFactories.add(new BlendingSimpleFactory(new double[]{15.0, 15.0, 15.0}, 0.3));
            } else {
                combinedWeightenerFactories.add(new BlendingSimpleFactory(0.0, 0.3));
            }
        }
        IOFunctions.println("Fused image container: " + conf.processImageFactory.getClass().getSimpleName());
        this.fusion = conf.isDeconvolution && conf.deconvolutionLoadSequentially ? new PreDeconvolutionFusionSequential(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories) : (conf.isDeconvolution ? new PreDeconvolutionFusion(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories) : (conf.multipleImageFusion ? new MappingFusionSequentialDifferentOutput(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories, conf.numParalellViews) : (conf.paralellFusion ? new MappingFusionParalell(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories) : (conf.numParalellViews >= viewStructure.getNumViews() ? new MappingFusionParalell(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories) : new MappingFusionSequential(viewStructure, referenceViewStructure, isolatedWeightenerFactories, combinedWeightenerFactories, conf.numParalellViews)))));
        for (int channelIndex = 0; channelIndex < viewStructure.getNumChannels(); ++channelIndex) {
            int channelID = viewStructure.getChannelNum(channelIndex);
            boolean contains = false;
            for (int cF : conf.channelsFuse) {
                if (cF != channelID) continue;
                contains = true;
            }
            if (!contains) continue;
            this.fusion.fuseSPIMImages(channelIndex);
            if (conf.isDeconvolution) {
                return;
            }
            if (conf.showOutputImage) {
                if (!conf.multipleImageFusion) {
                    if (viewStructure.getDebugLevel() <= 1) {
                        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Displaying image (Channel " + channelIndex + ").");
                    }
                    this.fusion.getFusedImage().getDisplay().setMinMax();
                    String name = viewStructure.getSPIMConfiguration().inputFilePattern;
                    String replaceTP = SPIMConfiguration.getReplaceStringTimePoints(name);
                    String replaceChannel = SPIMConfiguration.getReplaceStringChannels(name);
                    if (replaceTP != null) {
                        name = name.replace(replaceTP, "" + timePoint);
                    }
                    if (replaceChannel != null) {
                        name = name.replace(replaceChannel, "" + channelID);
                    }
                    this.fusion.getFusedImage().setName("Fused_" + name);
                    ImageJFunctions.copyToImagePlus(this.fusion.getFusedImage()).show();
                } else if (channelIndex == 0) {
                    MappingFusionSequentialDifferentOutput multipleFusion = (MappingFusionSequentialDifferentOutput)this.fusion;
                    int i = 0;
                    for (ViewDataBeads view : viewStructure.getViews()) {
                        Image<FloatType> fused = multipleFusion.getFusedImage(i++);
                        String name = viewStructure.getSPIMConfiguration().inputFilePattern;
                        String replaceTP = SPIMConfiguration.getReplaceStringTimePoints(name);
                        String replaceAngle = SPIMConfiguration.getReplaceStringAngle(name);
                        String replaceChannel = SPIMConfiguration.getReplaceStringChannels(name);
                        try {
                            name = name.replace(replaceAngle, "" + view.getAcqusitionAngle());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            name = name.replace(replaceTP, "" + timePoint);
                            name = name.replace(replaceChannel, "" + channelID);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        fused.setName(name);
                        fused.getDisplay().setMinMax();
                        ImageJFunctions.copyToImagePlus(fused).show();
                        fused.close();
                    }
                }
            }
            if (conf.writeOutputImage == 1) {
                if (viewStructure.getDebugLevel() <= 1) {
                    IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Writing output file (Channel " + channelIndex + ").");
                }
                this.fusion.saveAsTiffs(conf.outputdirectory, "img_tl" + timePoint, channelIndex);
                continue;
            }
            if (conf.writeOutputImage != 2) continue;
            File dir = new File(conf.outputdirectory, "" + timePoint);
            if (!dir.exists() && !dir.mkdirs()) {
                IOFunctions.printErr("(" + new Date(System.currentTimeMillis()) + "): Cannot create directory '" + dir.getAbsolutePath() + "', quitting.");
                return;
            }
            this.fusion.saveAsTiffs(dir.getAbsolutePath(), "img_tl" + timePoint, channelIndex);
        }
        if (!conf.isDeconvolution) {
            this.fusion.closeImages();
        }
    }
}

