/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.scijava.ui.swing.script.EditorPane;

public class EditorPaneActions
extends RSyntaxTextAreaEditorKit {
    private static final long serialVersionUID = 1L;
    public static final String epaCamelCaseAction = "RTA.CamelCaseAction";
    public static final String epaLowerCaseUndAction = "RTA.LowerCaseUnderscoreSep.Action";
    public static final String epaIncreaseIndentAction = "RSTA.IncreaseIndentAction";
    public static final String epaTitleCaseAction = "RTA.TitleCaseAction";
    public static final String epaToggleCommentAltAction = "RSTA.ToggleCommentAltAction";
    private final EditorPane editorPane;

    public EditorPaneActions(EditorPane editorPane) {
        this.editorPane = editorPane;
        int defaultMod = RTextArea.getDefaultModifier();
        int shift = 64;
        InputMap map = editorPane.getInputMap();
        if (4 == RSyntaxUtilities.getOS()) {
            map.put(KeyStroke.getKeyStroke(47, defaultMod + 64), "RSTA.ToggleCommentAction");
        }
        map.put(KeyStroke.getKeyStroke(55, defaultMod), epaToggleCommentAltAction);
        map.put(KeyStroke.getKeyStroke(73, defaultMod), epaIncreaseIndentAction);
        map.put(KeyStroke.getKeyStroke(73, defaultMod + 64), "RSTA.DecreaseIndentAction");
        map.put(KeyStroke.getKeyStroke(67, defaultMod), "copy-to-clipboard");
        map.put(KeyStroke.getKeyStroke(86, defaultMod), "paste-from-clipboard");
        map.put(KeyStroke.getKeyStroke(88, defaultMod), "cut-to-clipboard");
        map.put(KeyStroke.getKeyStroke(90, defaultMod), "RTA.UndoAction");
        map.put(KeyStroke.getKeyStroke(89, defaultMod), "RTA.RedoAction");
        this.installCustomActions();
    }

    private void installCustomActions() {
        ActionMap map = this.editorPane.getActionMap();
        map.put(epaToggleCommentAltAction, (Action)((Object)new ToggleCommentAltAction()));
        map.put(epaCamelCaseAction, (Action)((Object)new CamelCaseAction()));
        map.put(epaLowerCaseUndAction, (Action)((Object)new LowerCaseUnderscoreAction()));
        map.put(epaTitleCaseAction, (Action)((Object)new TitleCaseAction()));
        if (map.get("RTA.InvertCaseAction") != null) {
            map.put("RTA.InvertCaseAction", (Action)new RTextAreaEditorKit.InvertSelectionCaseAction());
        }
        map.put(epaIncreaseIndentAction, (Action)((Object)new IncreaseIndentAction()));
        if (map.get("RSTA.DecreaseIndentAction") != null) {
            map.put("RSTA.DecreaseIndentAction", (Action)new RSyntaxTextAreaEditorKit.DecreaseIndentAction());
        }
        if (map.get("RTA.LineUpAction") != null) {
            map.put("RTA.LineUpAction", (Action)new RTextAreaEditorKit.LineMoveAction("RTA.LineUpAction", -1));
        }
        if (map.get("RTA.LineDownAction") != null) {
            map.put("RTA.LineDownAction", (Action)new RTextAreaEditorKit.LineMoveAction("RTA.LineUpAction", 1));
        }
        map.put("RTA.TimeDateAction", (Action)new RTextAreaEditorKit.TimeDateAction());
        map.put("RTA.PasteHistoryAction", (Action)((Object)new ClipboardHistoryActionImpl()));
        if (map.get("RSTA.GoToMatchingBracketAction") != null) {
            map.put("RSTA.GoToMatchingBracketAction", (Action)new RSyntaxTextAreaEditorKit.GoToMatchingBracketAction());
        }
    }

    public KeyStroke getAccelerator(String actionID) {
        Action action = this.editorPane.getActionMap().get(actionID);
        if (action == null) {
            return null;
        }
        for (KeyStroke key : this.editorPane.getInputMap().keys()) {
            if (!actionID.equals(this.editorPane.getInputMap().get(key))) continue;
            return key;
        }
        for (KeyStroke key : this.editorPane.getInputMap().allKeys()) {
            if (!actionID.equals(this.editorPane.getInputMap().get(key))) continue;
            return key;
        }
        KeyStroke[] keyStrokes = this.editorPane.getKeymap().getKeyStrokesForAction(action);
        if (keyStrokes != null && keyStrokes.length > 0) {
            return keyStrokes[0];
        }
        return (KeyStroke)action.getValue("AcceleratorKey");
    }

    public String getAcceleratorLabel(String actionID) {
        KeyStroke ks = this.getAccelerator(actionID);
        return ks == null ? "" : ks.toString().replace(" pressed ", " ").replace(" ", "+").toUpperCase();
    }

    static class IncreaseIndentAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;
        private final Segment s = new Segment();

        public IncreaseIndentAction() {
            super(EditorPaneActions.epaIncreaseIndentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            Document document = textArea.getDocument();
            Element map = document.getDefaultRootElement();
            Caret c = textArea.getCaret();
            int dot = c.getDot();
            int mark = c.getMark();
            int line1 = map.getElementIndex(dot);
            int tabSize = textArea.getTabSize();
            StringBuilder sb = new StringBuilder();
            if (textArea.getTabsEmulated()) {
                while (sb.length() < tabSize) {
                    sb.append(' ');
                }
            } else {
                sb.append('\t');
            }
            String paddingString = sb.toString();
            if (dot != mark) {
                int line2 = map.getElementIndex(mark);
                dot = Math.min(line1, line2);
                mark = Math.max(line1, line2);
                textArea.beginAtomicEdit();
                try {
                    Element elem;
                    for (line1 = dot; line1 < mark; ++line1) {
                        elem = map.getElement(line1);
                        this.handleIncreaseIndent(elem, document, paddingString);
                    }
                    elem = map.getElement(mark);
                    int start = elem.getStartOffset();
                    if (Math.max(c.getDot(), c.getMark()) == start) return;
                    this.handleIncreaseIndent(elem, document, paddingString);
                    return;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    return;
                }
                finally {
                    textArea.endAtomicEdit();
                }
            }
            Element elem = map.getElement(line1);
            try {
                this.handleIncreaseIndent(elem, document, paddingString);
                return;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
        }

        public final String getMacroID() {
            return EditorPaneActions.epaIncreaseIndentAction;
        }

        private void handleIncreaseIndent(Element elem, Document doc, String pad) throws BadLocationException {
            int start = elem.getStartOffset();
            int end = elem.getEndOffset() - 1;
            doc.getText(start, end - start, this.s);
            int i = this.s.offset;
            end = i + this.s.count;
            if (end > i || end == i && i == 0) {
                doc.insertString(start, pad, null);
            }
        }
    }

    static class LowerCaseUnderscoreAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        LowerCaseUnderscoreAction() {
            super(EditorPaneActions.epaLowerCaseUndAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            String selection = textArea.getSelectedText();
            if (selection != null) {
                textArea.replaceSelection(selection.trim().replaceAll("\\s", "_").toLowerCase());
            }
            textArea.requestFocusInWindow();
        }

        public String getMacroID() {
            return EditorPaneActions.epaLowerCaseUndAction;
        }
    }

    static class TitleCaseAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        TitleCaseAction() {
            super(EditorPaneActions.epaTitleCaseAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            String selection = textArea.getSelectedText();
            if (selection != null) {
                String[] words = selection.split("[\\W_]+");
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    word = word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
                    buffer.append(word);
                    if (i >= words.length - 1) continue;
                    buffer.append(" ");
                }
                textArea.replaceSelection(buffer.toString());
            }
            textArea.requestFocusInWindow();
        }

        public String getMacroID() {
            return EditorPaneActions.epaTitleCaseAction;
        }
    }

    static class CamelCaseAction
    extends RecordableTextAction {
        private static final long serialVersionUID = 1L;

        CamelCaseAction() {
            super(EditorPaneActions.epaCamelCaseAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            String selection = textArea.getSelectedText();
            if (selection != null) {
                String[] words = selection.split("[\\W_]+");
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    word = i == 0 ? (word.isEmpty() ? word : word.toLowerCase()) : (word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase());
                    buffer.append(word);
                }
                textArea.replaceSelection(buffer.toString());
            }
            textArea.requestFocusInWindow();
        }

        public String getMacroID() {
            return EditorPaneActions.epaCamelCaseAction;
        }
    }

    static class ClipboardHistoryActionImpl
    extends RTextAreaEditorKit.ClipboardHistoryAction {
        private static final long serialVersionUID = 1L;

        ClipboardHistoryActionImpl() {
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            boolean editingPossible;
            boolean bl = editingPossible = textArea.isEditable() && textArea.isEnabled();
            if (!editingPossible) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            super.actionPerformedImpl(e, textArea);
        }
    }

    static class ToggleCommentAltAction
    extends RSyntaxTextAreaEditorKit.ToggleCommentAction {
        private static final long serialVersionUID = 1L;

        ToggleCommentAltAction() {
            this.setName(EditorPaneActions.epaToggleCommentAltAction);
        }
    }
}

