/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.registration;

import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.realtransform.AffineTransform3D;

public class ViewRegistration
extends ViewId {
    protected final AffineTransform3D model;
    protected final ArrayList<ViewTransform> transformList;

    public ViewRegistration(int timepointId, int setupId) {
        super(timepointId, setupId);
        this.model = new AffineTransform3D();
        this.transformList = new ArrayList();
    }

    public ViewRegistration(int timepointId, int setupId, AffineTransform3D transform) {
        super(timepointId, setupId);
        this.model = transform.copy();
        this.transformList = new ArrayList();
        this.transformList.add(new ViewTransformAffine(null, transform));
    }

    public ViewRegistration(int timepointId, int setupId, ArrayList<ViewTransform> transforms) {
        super(timepointId, setupId);
        this.model = new AffineTransform3D();
        this.transformList = new ArrayList<ViewTransform>(transforms);
        this.updateModel();
    }

    public AffineTransform3D getModel() {
        return this.model;
    }

    public void updateModel() {
        this.model.identity();
        for (ViewTransform t : this.transformList) {
            this.model.concatenate(t.asAffine3D());
        }
    }

    public List<ViewTransform> getTransformList() {
        return this.transformList;
    }

    public void concatenateTransform(ViewTransform transform) {
        this.transformList.add(transform);
        this.model.concatenate(transform.asAffine3D());
    }

    public void preconcatenateTransform(ViewTransform transform) {
        this.transformList.add(0, transform);
        this.model.preConcatenate(transform.asAffine3D());
    }

    public void identity() {
        this.model.identity();
        this.transformList.clear();
    }
}

