/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.ViewId;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoMissingViews
extends XmlIoSingleton<MissingViews> {
    public XmlIoMissingViews() {
        super("MissingViews", MissingViews.class);
        this.handledTags.add("MissingView");
    }

    public Element toXml(MissingViews missingViews) {
        Element elem = super.toXml();
        ArrayList<ViewId> list = new ArrayList<ViewId>(missingViews.getMissingViews());
        Collections.sort(list);
        for (ViewId v : list) {
            Element child = new Element("MissingView");
            child.setAttribute("timepoint", Integer.toString(v.getTimePointId()));
            child.setAttribute("setup", Integer.toString(v.getViewSetupId()));
            elem.addContent((Content)child);
        }
        return elem;
    }

    @Override
    public MissingViews fromXml(Element elem) throws SpimDataException {
        MissingViews missingViews = (MissingViews)super.fromXml(elem);
        HashSet<ViewId> views = new HashSet<ViewId>();
        for (Element c : elem.getChildren("MissingView")) {
            int t = Integer.parseInt(c.getAttributeValue("timepoint"));
            int s = Integer.parseInt(c.getAttributeValue("setup"));
            views.add(new ViewId(t, s));
        }
        missingViews.setMissingViews(views);
        return missingViews;
    }
}

