/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui.sourceList;

import bigwarp.transforms.NgffTransformations;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import net.imglib2.realtransform.RealTransform;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.imglib2.N5DisplacementField;
import org.janelia.saalfeldlab.n5.universe.N5Factory;

public class BigWarpSourceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5923947651732788341L;
    protected static final String[] colNames = new String[]{"Name", "Moving", "Transform", " "};
    protected final String[] columnNames = colNames;
    protected final ArrayList<SourceRow> sources = new ArrayList();
    protected final ArrayList<RemoveRowButton> rmRowButtons = new ArrayList();
    protected static int imageColIdx = 0;
    protected static int movingColIdx = 1;
    protected static int transformColIdx = 2;
    protected static int removeColIdx = 3;
    protected Function<String, String> transformChangedCallback;
    private Component container;

    public BigWarpSourceTableModel() {
        this(null);
    }

    public BigWarpSourceTableModel(Function<String, String> transformChangedCallback) {
        this.transformChangedCallback = transformChangedCallback;
    }

    public void setContainer(Component container) {
        this.container = container;
    }

    public SourceRow get(int i) {
        return this.sources.get(i);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.sources.size();
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (c == 3) {
            return this.rmRowButtons.get(r);
        }
        return this.sources.get(r).get(c);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 1) {
            return Boolean.class;
        }
        if (col == 3) {
            return JButton.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == movingColIdx) {
            this.sources.get((int)row).moving = (Boolean)value;
        } else if (col == imageColIdx) {
            this.sources.get((int)row).srcName = (String)value;
        } else if (col == transformColIdx) {
            this.setTransform(row, (String)value);
        }
    }

    public void setTransform(int row, String value) {
        String res;
        this.sources.get((int)row).transformUrl = this.transformChangedCallback != null ? ((res = this.transformChangedCallback.apply(value)) != null ? res : value) : value;
    }

    public void add(String srcName, boolean moving, SourceType type) {
        RemoveRowButton rmButton = new RemoveRowButton(this.sources.size());
        this.rmRowButtons.add(rmButton);
        this.sources.add(new SourceRow(srcName, moving, "", type));
    }

    public void add(String srcName, boolean moving) {
        this.add(srcName, moving, SourceType.URL);
    }

    public void add(String srcName) {
        this.add(srcName, false);
    }

    public void addImagePlus(String srcName) {
        this.addImagePlus(srcName, false);
    }

    public void addImagePlus(String srcName, boolean isMoving) {
        this.add(srcName, isMoving, SourceType.IMAGEPLUS);
    }

    public void addDataset(String srcName) {
        this.addImagePlus(srcName, false);
    }

    public void addDataset(String srcName, boolean isMoving) {
        this.add(srcName, isMoving, SourceType.DATASET);
    }

    public boolean remove(int i) {
        if (i >= this.sources.size()) {
            return false;
        }
        this.sources.remove(i);
        this.rmRowButtons.remove(i);
        this.updateRmButtonIndexes();
        if (this.container != null) {
            this.container.repaint();
        }
        return true;
    }

    private void updateRmButtonIndexes() {
        for (int i = 0; i < this.rmRowButtons.size(); ++i) {
            this.rmRowButtons.get(i).setRow(i);
        }
    }

    protected static class ButtonEditor
    extends DefaultCellEditor {
        protected JButton button;
        private String label;
        private RemoveRowButton thisButton;
        private BigWarpSourceTableModel model;
        private boolean isPushed;

        public ButtonEditor(JCheckBox checkBox, BigWarpSourceTableModel model) {
            super(checkBox);
            checkBox.setText("-");
            this.model = model;
            this.button = new JButton();
            this.button.setOpaque(true);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.thisButton = (RemoveRowButton)value;
            this.label = value == null ? "" : this.thisButton.getText();
            this.button.setText(this.label);
            this.isPushed = true;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.isPushed) {
                this.model.remove(this.thisButton.getRow());
            }
            this.isPushed = false;
            return new String(this.label);
        }

        @Override
        public boolean stopCellEditing() {
            this.isPushed = false;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    protected static class ButtonRenderer
    extends JButton
    implements TableCellRenderer {
        public ButtonRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(UIManager.getColor("Button.background"));
            }
            this.setText(value == null ? "" : ((RemoveRowButton)value).getText());
            return this;
        }
    }

    protected static class RemoveRowButton
    extends JButton {
        private int row;

        public RemoveRowButton(int row) {
            super("remove");
            this.setRow(row);
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }
    }

    public static class SourceRow {
        public String srcName;
        public boolean moving;
        public String transformUrl;
        public SourceType type;

        public SourceRow(String srcName, boolean moving, String transformUrl, SourceType type) {
            this.srcName = srcName;
            this.moving = moving;
            this.transformUrl = transformUrl;
            this.type = type;
        }

        public SourceRow(String srcName, boolean moving, String transformName) {
            this(srcName, moving, transformName, SourceType.URL);
        }

        public Object get(int c) {
            if (c == 0) {
                return this.srcName;
            }
            if (c == 1) {
                return this.moving;
            }
            if (c == 2) {
                return this.transformUrl;
            }
            return null;
        }

        public RealTransform getTransform() {
            if (this.transformUrl != null && !this.transformUrl.isEmpty()) {
                String trimUrl = this.transformUrl.trim();
                try {
                    N5URI n5Uri = new N5URI(trimUrl);
                    URI uri = n5Uri.getURI();
                    if (uri.getFragment() == null) {
                        String groupPath = uri.getQuery() == null ? "dfield" : n5Uri.getGroupPath();
                        boolean isInverse = groupPath.endsWith("invdfield");
                        return N5DisplacementField.open((N5Reader)new N5Factory().openReader(n5Uri.getContainerPath()), (String)groupPath, (boolean)isInverse);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return NgffTransformations.open(trimUrl);
            }
            return null;
        }

        public Supplier<String> getTransformUri() {
            if (this.transformUrl != null && !this.transformUrl.isEmpty()) {
                return () -> this.transformUrl;
            }
            return null;
        }
    }

    public static enum SourceType {
        IMAGEPLUS,
        DATASET,
        URL;

    }
}

