/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import bdv.viewer.animate.SimilarityModel3D;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.AbstractTransformSolver;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.MaskedTransformSolver;
import bigwarp.transforms.ModelTransformSolver;
import bigwarp.transforms.WrappedCoordinateTransform;
import java.util.Arrays;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.Model;
import mpicbg.models.RigidModel2D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.SimilarityModel2D;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.MaskedSimilarityTransform;
import net.imglib2.realtransform.MaskedSimilarityTransform2D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.RealType;

public class MaskedSimRotTransformSolver<T extends RealType<T>>
extends AbstractTransformSolver<WrappedIterativeInvertibleRealTransform<?>> {
    private final AbstractTransformSolver<?> baseSolver;
    private final ModelTransformSolver interpSolver;
    private RealRandomAccessible<T> lambda;
    private final double[] center;
    private final MaskedSimilarityTransform.Interpolators interp;
    private final int ndims;

    public MaskedSimRotTransformSolver(AbstractTransformSolver<?> solver, RealRandomAccessible<T> lambda, double[] center, MaskedSimilarityTransform.Interpolators interp) {
        this(3, solver, lambda, center, interp);
    }

    public MaskedSimRotTransformSolver(int nd, AbstractTransformSolver<?> solver, RealRandomAccessible<T> lambda, double[] center, MaskedSimilarityTransform.Interpolators interp) {
        this.ndims = nd;
        this.lambda = lambda;
        this.center = center;
        this.interp = interp;
        this.baseSolver = solver;
        this.interpSolver = interp == MaskedSimilarityTransform.Interpolators.SIMILARITY ? (nd == 2 ? new ModelTransformSolver((Model<?>)new SimilarityModel2D()) : new ModelTransformSolver((Model<?>)new SimilarityModel3D())) : (nd == 2 ? new ModelTransformSolver((Model<?>)new RigidModel2D()) : new ModelTransformSolver((Model<?>)new RigidModel3D()));
        System.out.println(this);
    }

    public void setMask(RealRandomAccessible<T> lambda) {
        this.lambda = lambda;
    }

    public String toString() {
        return String.format("MaskedSolver.  center %s; interp: %s ", Arrays.toString(this.center), this.interp.toString());
    }

    public void setCenter(double[] c) {
        System.arraycopy(c, 0, this.center, 0, c.length);
    }

    public void setCenter(RealLocalizable c) {
        c.localize(this.center);
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<?> solve(double[][] mvgPts, double[][] tgtPts) {
        Object msim;
        AffineTransform2D sim;
        WrappedCoordinateTransform simXfm = this.interpSolver.solve(tgtPts, mvgPts);
        if (this.ndims == 2) {
            sim = new AffineTransform2D();
            BigWarpTransform.affine2d((AbstractAffineModel2D)this.interpSolver.getModel(), sim);
            msim = new MaskedSimilarityTransform2D<T>(sim, this.lambda, this.center, this.interp);
        } else {
            sim = BigWarpTransform.toAffine3D((AbstractAffineModel3D)this.interpSolver.getModel());
            msim = new MaskedSimilarityTransform<T>((AffineTransform3D)sim, this.lambda, this.center, this.interp);
        }
        double[][] xfmTgt = MaskedSimRotTransformSolver.transformPoints(msim, tgtPts);
        Object baseTransform = this.baseSolver.solve(mvgPts, xfmTgt);
        RealTransformSequence seq = new RealTransformSequence();
        seq.add(msim);
        seq.add(baseTransform);
        return new WrappedIterativeInvertibleRealTransform(MaskedTransformSolver.wrap((RealTransform)seq, this.lambda));
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<?> solve(LandmarkTableModel landmarkTable) {
        int numActive = landmarkTable.numActive();
        int nd = landmarkTable.getNumdims();
        double[][] mvgPts = new double[nd][numActive];
        double[][] tgtPts = new double[nd][numActive];
        landmarkTable.copyLandmarks(mvgPts, tgtPts);
        return this.solve(mvgPts, tgtPts);
    }

    private static double[][] transformPoints(RealTransform xfm, double[][] pts) {
        int nd = pts.length;
        int np = pts[0].length;
        double[] tmp = new double[nd];
        double[][] out = new double[nd][np];
        for (int i = 0; i < np; ++i) {
            int d;
            for (d = 0; d < nd; ++d) {
                tmp[d] = pts[d][i];
            }
            xfm.apply(tmp, tmp);
            for (d = 0; d < nd; ++d) {
                out[d][i] = tmp[d];
            }
        }
        return out;
    }
}

