/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.BigDataViewer;
import bdv.KeyConfigScopes;
import bdv.tools.HelpDialog;
import bdv.tools.RecordMaxProjectionDialog;
import bdv.tools.RecordMovieDialog;
import bdv.tools.ToggleDialogAction;
import bdv.tools.VisibilityAndGroupingDialog;
import bdv.tools.bookmarks.BookmarksEditor;
import bdv.tools.brightness.BrightnessDialog;
import bdv.tools.crop.CropDialog;
import bdv.tools.transformation.ManualTransformationEditor;
import java.awt.Dialog;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class BigDataViewerActions
extends Actions {
    public static final String BRIGHTNESS_SETTINGS = "brightness settings";
    public static final String VISIBILITY_AND_GROUPING = "visibility and grouping";
    public static final String SHOW_HELP = "help";
    public static final String CROP = "crop";
    public static final String MANUAL_TRANSFORM = "toggle manual transformation";
    public static final String SAVE_SETTINGS = "save settings";
    public static final String LOAD_SETTINGS = "load settings";
    public static final String EXPAND_CARDS = "expand and focus cards panel";
    public static final String COLLAPSE_CARDS = "collapse cards panel";
    public static final String RECORD_MOVIE = "record movie";
    public static final String RECORD_MAX_PROJECTION_MOVIE = "record max projection movie";
    public static final String SET_BOOKMARK = "set bookmark";
    public static final String GO_TO_BOOKMARK = "go to bookmark";
    public static final String GO_TO_BOOKMARK_ROTATION = "go to bookmark rotation";
    public static final String PREFERENCES_DIALOG = "Preferences";
    public static final String[] BRIGHTNESS_SETTINGS_KEYS = new String[]{"S"};
    public static final String[] VISIBILITY_AND_GROUPING_KEYS = new String[]{"F6"};
    public static final String[] SHOW_HELP_KEYS = new String[]{"F1", "H"};
    public static final String[] CROP_KEYS = new String[]{"F9"};
    public static final String[] MANUAL_TRANSFORM_KEYS = new String[]{"T"};
    public static final String[] SAVE_SETTINGS_KEYS = new String[]{"F11"};
    public static final String[] LOAD_SETTINGS_KEYS = new String[]{"F12"};
    public static final String[] EXPAND_CARDS_KEYS = new String[]{"P"};
    public static final String[] COLLAPSE_CARDS_KEYS = new String[]{"shift P", "shift ESCAPE"};
    public static final String[] RECORD_MOVIE_KEYS = new String[]{"F10"};
    public static final String[] RECORD_MAX_PROJECTION_MOVIE_KEYS = new String[]{"F8"};
    public static final String[] SET_BOOKMARK_KEYS = new String[]{"shift B"};
    public static final String[] GO_TO_BOOKMARK_KEYS = new String[]{"B"};
    public static final String[] GO_TO_BOOKMARK_ROTATION_KEYS = new String[]{"O"};
    public static final String[] PREFERENCES_DIALOG_KEYS = new String[]{"meta COMMA", "ctrl COMMA"};

    public static void install(Actions actions, BigDataViewer bdv) {
        BigDataViewerActions.toggleDialogAction(actions, bdv.brightnessDialog, BRIGHTNESS_SETTINGS, BRIGHTNESS_SETTINGS_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.activeSourcesDialog, VISIBILITY_AND_GROUPING, VISIBILITY_AND_GROUPING_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.helpDialog, SHOW_HELP, SHOW_HELP_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.cropDialog, CROP, CROP_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.movieDialog, RECORD_MOVIE, RECORD_MOVIE_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.movieMaxProjectDialog, RECORD_MAX_PROJECTION_MOVIE, RECORD_MAX_PROJECTION_MOVIE_KEYS);
        BigDataViewerActions.toggleDialogAction(actions, bdv.preferencesDialog, PREFERENCES_DIALOG, PREFERENCES_DIALOG_KEYS);
        BigDataViewerActions.bookmarks(actions, bdv.bookmarkEditor);
        BigDataViewerActions.manualTransform(actions, bdv.manualTransformationEditor);
        actions.runnableAction(bdv::loadSettings, LOAD_SETTINGS, LOAD_SETTINGS_KEYS);
        actions.runnableAction(bdv::saveSettings, SAVE_SETTINGS, SAVE_SETTINGS_KEYS);
        actions.runnableAction(bdv::expandAndFocusCardPanel, EXPAND_CARDS, EXPAND_CARDS_KEYS);
        actions.runnableAction(bdv::collapseCardPanel, COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS);
    }

    public static void toggleDialogAction(Actions actions, Dialog dialog, String name, String ... defaultKeyStrokes) {
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(name, dialog), defaultKeyStrokes);
    }

    public static void dialog(Actions actions, CropDialog cropDialog) {
        BigDataViewerActions.toggleDialogAction(actions, cropDialog, CROP, CROP_KEYS);
    }

    public static void dialog(Actions actions, HelpDialog helpDialog) {
        BigDataViewerActions.toggleDialogAction(actions, helpDialog, SHOW_HELP, SHOW_HELP_KEYS);
    }

    public static void dialog(Actions actions, RecordMovieDialog recordMovieDialog) {
        BigDataViewerActions.toggleDialogAction(actions, recordMovieDialog, RECORD_MOVIE, RECORD_MOVIE_KEYS);
    }

    public static void dialog(Actions actions, RecordMaxProjectionDialog recordMaxProjectionDialog) {
        BigDataViewerActions.toggleDialogAction(actions, recordMaxProjectionDialog, RECORD_MAX_PROJECTION_MOVIE, RECORD_MAX_PROJECTION_MOVIE_KEYS);
    }

    public static void bookmarks(Actions actions, BookmarksEditor bookmarksEditor) {
        actions.runnableAction(bookmarksEditor::initGoToBookmark, GO_TO_BOOKMARK, GO_TO_BOOKMARK_KEYS);
        actions.runnableAction(bookmarksEditor::initGoToBookmarkRotation, GO_TO_BOOKMARK_ROTATION, GO_TO_BOOKMARK_ROTATION_KEYS);
        actions.runnableAction(bookmarksEditor::initSetBookmark, SET_BOOKMARK, SET_BOOKMARK_KEYS);
    }

    public static void manualTransform(Actions actions, ManualTransformationEditor manualTransformationEditor) {
        actions.runnableAction(manualTransformationEditor::toggle, MANUAL_TRANSFORM, MANUAL_TRANSFORM_KEYS);
    }

    @Deprecated
    public static void dialog(Actions actions, BrightnessDialog brightnessDialog) {
        BigDataViewerActions.toggleDialogAction(actions, brightnessDialog, BRIGHTNESS_SETTINGS, BRIGHTNESS_SETTINGS_KEYS);
    }

    @Deprecated
    public static void dialog(Actions actions, VisibilityAndGroupingDialog visibilityAndGroupingDialog) {
        BigDataViewerActions.toggleDialogAction(actions, visibilityAndGroupingDialog, VISIBILITY_AND_GROUPING, VISIBILITY_AND_GROUPING_KEYS);
    }

    @Deprecated
    public static void installActionBindings(InputActionBindings inputActionBindings, BigDataViewer bdv, KeyStrokeAdder.Factory keyProperties) {
        BigDataViewerActions actions = new BigDataViewerActions(keyProperties);
        actions.dialog(bdv.brightnessDialog);
        actions.dialog(bdv.activeSourcesDialog);
        actions.dialog(bdv.helpDialog);
        actions.dialog(bdv.cropDialog);
        actions.dialog(bdv.movieDialog);
        actions.dialog(bdv.movieMaxProjectDialog);
        actions.bookmarks(bdv.bookmarkEditor);
        actions.manualTransform(bdv.manualTransformationEditor);
        actions.runnableAction(bdv::loadSettings, LOAD_SETTINGS, LOAD_SETTINGS_KEYS);
        actions.runnableAction(bdv::saveSettings, SAVE_SETTINGS, SAVE_SETTINGS_KEYS);
        actions.runnableAction(bdv::expandAndFocusCardPanel, EXPAND_CARDS, EXPAND_CARDS_KEYS);
        actions.runnableAction(bdv::collapseCardPanel, COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS);
        actions.install(inputActionBindings, "bdv");
    }

    @Deprecated
    public BigDataViewerActions(KeyStrokeAdder.Factory keyConfig) {
        super(keyConfig, new String[]{"bdv"});
    }

    @Deprecated
    public void dialog(BrightnessDialog brightnessDialog) {
        this.toggleDialogAction(brightnessDialog, BRIGHTNESS_SETTINGS, BRIGHTNESS_SETTINGS_KEYS);
    }

    @Deprecated
    public void dialog(VisibilityAndGroupingDialog visibilityAndGroupingDialog) {
        this.toggleDialogAction(visibilityAndGroupingDialog, VISIBILITY_AND_GROUPING, VISIBILITY_AND_GROUPING_KEYS);
    }

    @Deprecated
    public void toggleDialogAction(Dialog dialog, String name, String ... defaultKeyStrokes) {
        this.keyStrokeAdder.put(name, defaultKeyStrokes);
        new ToggleDialogAction(name, dialog).put(this.getActionMap());
    }

    @Deprecated
    public void dialog(CropDialog cropDialog) {
        this.toggleDialogAction(cropDialog, CROP, CROP_KEYS);
    }

    @Deprecated
    public void dialog(HelpDialog helpDialog) {
        this.toggleDialogAction(helpDialog, SHOW_HELP, SHOW_HELP_KEYS);
    }

    @Deprecated
    public void dialog(RecordMovieDialog recordMovieDialog) {
        this.toggleDialogAction(recordMovieDialog, RECORD_MOVIE, RECORD_MOVIE_KEYS);
    }

    @Deprecated
    public void dialog(RecordMaxProjectionDialog recordMaxProjectionDialog) {
        this.toggleDialogAction(recordMaxProjectionDialog, RECORD_MAX_PROJECTION_MOVIE, RECORD_MAX_PROJECTION_MOVIE_KEYS);
    }

    @Deprecated
    public void bookmarks(BookmarksEditor bookmarksEditor) {
        this.runnableAction(bookmarksEditor::initGoToBookmark, GO_TO_BOOKMARK, GO_TO_BOOKMARK_KEYS);
        this.runnableAction(bookmarksEditor::initGoToBookmarkRotation, GO_TO_BOOKMARK_ROTATION, GO_TO_BOOKMARK_ROTATION_KEYS);
        this.runnableAction(bookmarksEditor::initSetBookmark, SET_BOOKMARK, SET_BOOKMARK_KEYS);
    }

    @Deprecated
    public void manualTransform(ManualTransformationEditor manualTransformationEditor) {
        this.runnableAction(manualTransformationEditor::toggle, MANUAL_TRANSFORM, MANUAL_TRANSFORM_KEYS);
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(KeyConfigScopes.BIGDATAVIEWER, new String[]{"bdv"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(BigDataViewerActions.BRIGHTNESS_SETTINGS, BRIGHTNESS_SETTINGS_KEYS, "Show the Brightness&Colors dialog.");
            descriptions.add(BigDataViewerActions.VISIBILITY_AND_GROUPING, VISIBILITY_AND_GROUPING_KEYS, "Show the Visibility&Grouping dialog.");
            descriptions.add(BigDataViewerActions.SHOW_HELP, SHOW_HELP_KEYS, "Show the Help dialog.");
            descriptions.add(BigDataViewerActions.CROP, CROP_KEYS, "Show the Crop dialog.");
            descriptions.add(BigDataViewerActions.MANUAL_TRANSFORM, MANUAL_TRANSFORM_KEYS, "Toggle manual transformation mode.");
            descriptions.add(BigDataViewerActions.SAVE_SETTINGS, SAVE_SETTINGS_KEYS, "Save the BigDataViewer settings to a settings.xml file.");
            descriptions.add(BigDataViewerActions.LOAD_SETTINGS, LOAD_SETTINGS_KEYS, "Load the BigDataViewer settings from a settings.xml file.");
            descriptions.add(BigDataViewerActions.EXPAND_CARDS, EXPAND_CARDS_KEYS, "Expand and focus the BigDataViewer card panel");
            descriptions.add(BigDataViewerActions.COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS, "Collapse the BigDataViewer card panel");
            descriptions.add(BigDataViewerActions.RECORD_MOVIE, RECORD_MOVIE_KEYS, "Show the Record Movie dialog.");
            descriptions.add(BigDataViewerActions.RECORD_MAX_PROJECTION_MOVIE, RECORD_MAX_PROJECTION_MOVIE_KEYS, "Show the Record Max Projection Movie dialog.");
            descriptions.add(BigDataViewerActions.SET_BOOKMARK, SET_BOOKMARK_KEYS, "Set a labeled bookmark at the current location.");
            descriptions.add(BigDataViewerActions.GO_TO_BOOKMARK, GO_TO_BOOKMARK_KEYS, "Retrieve a labeled bookmark location.");
            descriptions.add(BigDataViewerActions.GO_TO_BOOKMARK_ROTATION, GO_TO_BOOKMARK_ROTATION_KEYS, "Retrieve a labeled bookmark, set only the orientation.");
            descriptions.add(BigDataViewerActions.PREFERENCES_DIALOG, PREFERENCES_DIALOG_KEYS, "Show the Preferences dialog.");
        }
    }
}

