/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcegrouptree;

import bdv.ui.SourcesTransferable;
import bdv.ui.sourcegrouptree.SourceGroupEditor;
import bdv.ui.sourcegrouptree.SourceGroupTreeCellRenderer;
import bdv.ui.sourcegrouptree.SourceGroupTreeModel;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerState;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class SourceGroupTree
extends JTree {
    private final ViewerState state;
    private final SourceGroupTreeModel model;
    private final SourceGroupTreeCellRenderer renderer;
    private final SourceGroupEditor editor;
    private Point pressedAt;
    private boolean consumeNext = false;
    private long releasedWhen = 0L;

    public SourceGroupTree(ViewerState state) {
        this(state, new InputTriggerConfig());
    }

    public SourceGroupTree(ViewerState state, InputTriggerConfig inputTriggerConfig) {
        this.state = state;
        this.model = new SourceGroupTreeModel(state);
        this.setModel(this.model);
        this.renderer = new SourceGroupTreeCellRenderer();
        this.setCellRenderer(this.renderer);
        this.editor = new SourceGroupEditor((JTree)this, this.renderer);
        this.setCellEditor(this.editor);
        this.setOpaque(false);
        this.setTransferHandler(new SourceGroupTreeTransferHandler(this, state));
        this.installActions(inputTriggerConfig);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SourceGroupTree.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SourceGroupTree.this.repaint();
            }
        });
    }

    @Override
    public void updateUI() {
        if (this.renderer != null) {
            this.renderer.updateUI();
        }
        super.updateUI();
    }

    public List<SourceAndConverter<?>> getSelectedSources() {
        ArrayList sources = new ArrayList();
        for (SourceGroup group : this.getSelectedGroups()) {
            for (SourceAndConverter<?> source : this.state.getSourcesInGroup(group)) {
                if (sources.contains(source)) continue;
                sources.add(source);
            }
        }
        sources.sort(this.state.sourceOrder());
        return sources;
    }

    private void installActions(InputTriggerConfig inputTriggerConfig) {
        InputActionBindings keybindings = InputActionBindings.installNewBindings((JComponent)this, (int)0, (boolean)false);
        Actions actions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        actions.install(keybindings, "source groups tree");
        actions.runnableAction(() -> this.toggleSelectedActive(), "toggle active", new String[]{"A"});
        actions.runnableAction(() -> this.makeSelectedActive(true), "set active", new String[]{"not mapped"});
        actions.runnableAction(() -> this.makeSelectedActive(false), "set inactive", new String[]{"not mapped"});
        actions.runnableAction(() -> this.cycleSelectedCurrent(), "cycle current", new String[]{"C"});
        actions.runnableAction(() -> this.removeSelected(), "remove sources or groups", new String[]{"DELETE", "BACK_SPACE"});
        actions.runnableAction(() -> this.editGroupName(), "edit name", new String[]{"ENTER"});
    }

    private void makeSelectedActive(boolean active) {
        List<SourceGroup> selectedGroups = this.getSelectedGroups();
        this.state.setGroupsActive(selectedGroups, active);
    }

    private void toggleSelectedActive() {
        List<SourceGroup> selectedGroups = this.getSelectedGroups();
        if (!selectedGroups.isEmpty()) {
            this.state.setGroupsActive(selectedGroups, !this.state.isGroupActive(selectedGroups.get(0)));
        }
    }

    private void cycleSelectedCurrent() {
        List<SourceGroup> selectedGroups = this.getSelectedGroups();
        if (!selectedGroups.isEmpty()) {
            SourceGroup current = this.state.getCurrentGroup();
            int i = (selectedGroups.indexOf(current) + 1) % selectedGroups.size();
            this.state.setCurrentGroup(selectedGroups.get(i));
        }
    }

    private void removeSelected() {
        Map<SourceGroup, List<SourceAndConverter<?>>> groupToSelectedSources = this.getSelectedSourcesInGroups();
        List<SourceGroup> selectedGroups = this.getSelectedGroups();
        for (SourceGroup group2 : selectedGroups) {
            groupToSelectedSources.remove(group2);
        }
        groupToSelectedSources.forEach((group, sources) -> this.state.removeSourcesFromGroup((Collection<? extends SourceAndConverter<?>>)sources, (SourceGroup)group));
        this.state.removeGroups(selectedGroups);
    }

    private void editGroupName() {
        Object obj;
        TreePath path = this.getLeadSelectionPath();
        if (path != null && (obj = path.getLastPathComponent()) instanceof SourceGroupTreeModel.GroupModel) {
            this.startEditingAtPath(path);
        }
    }

    private List<SourceGroup> getSelectedGroups() {
        ArrayList<SourceGroup> selectedGroups = new ArrayList<SourceGroup>();
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath path : selectionPaths) {
                Object obj = path.getLastPathComponent();
                if (!(obj instanceof SourceGroupTreeModel.GroupModel)) continue;
                selectedGroups.add(((SourceGroupTreeModel.GroupModel)obj).getGroup());
            }
        }
        return selectedGroups;
    }

    private Map<SourceGroup, List<SourceAndConverter<?>>> getSelectedSourcesInGroups() {
        HashMap selected = new HashMap();
        for (TreePath path : this.getSelectionPaths()) {
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof SourceGroupTreeModel.SourceModel)) continue;
            SourceGroup group = ((SourceGroupTreeModel.GroupModel)path.getParentPath().getLastPathComponent()).getGroup();
            SourceAndConverter<?> source = ((SourceGroupTreeModel.SourceModel)obj).getSource();
            selected.computeIfAbsent(group, g -> new ArrayList()).add(source);
        }
        return selected;
    }

    @Override
    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String groupName;
        if (value instanceof SourceGroupTreeModel.GroupModel && (groupName = ((SourceGroupTreeModel.GroupModel)value).getName()) != null) {
            return groupName;
        }
        return "";
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        MouseEvent modifiedMouseEvent = e;
        if (e.getModifiers() == 16) {
            if (e.getID() == 501) {
                int y;
                this.pressedAt = e.getPoint();
                int x = e.getX();
                TreePath path = this.getPathForLocation(x, y = e.getY());
                if (path != null) {
                    Rectangle bounds = this.getPathBounds(path);
                    if ((double)e.getX() >= bounds.getX() + bounds.getWidth()) {
                        modifiedMouseEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiersEx(), (int)(bounds.getX() + bounds.getWidth() - 1.0), e.getY(), 0, 0, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    }
                    if (path.getLastPathComponent() instanceof SourceGroupTreeModel.GroupModel) {
                        boolean activeHit;
                        boolean currentHit = this.renderer.currentHit(x = (int)((double)x - bounds.getX()), y = (int)((double)y - bounds.getY()));
                        boolean bl = activeHit = !currentHit && this.renderer.activeHit(x, y);
                        if ((currentHit || activeHit) && this.isPathSelected(path)) {
                            e.consume();
                            this.consumeNext = true;
                        }
                    }
                }
            } else if (e.getID() == 502) {
                int y;
                if (this.consumeNext) {
                    this.releasedWhen = e.getWhen();
                    this.consumeNext = false;
                    e.consume();
                }
                if (this.pressedAt == null) {
                    return;
                }
                Point point = e.getPoint();
                if (point.distanceSq(this.pressedAt) > 2.0) {
                    return;
                }
                int x = e.getX();
                TreePath path = this.getPathForLocation(x, y = e.getY());
                if (path != null && path.getLastPathComponent() instanceof SourceGroupTreeModel.GroupModel) {
                    boolean activeHit;
                    Rectangle bounds = this.getPathBounds(path);
                    boolean currentHit = this.renderer.currentHit(x = (int)((double)x - bounds.getX()), y = (int)((double)y - bounds.getY()));
                    boolean bl = activeHit = !currentHit && this.renderer.activeHit(x, y);
                    if (currentHit || activeHit) {
                        SourceGroup group = ((SourceGroupTreeModel.GroupModel)path.getLastPathComponent()).getGroup();
                        if (currentHit) {
                            this.state.setCurrentGroup(group);
                        } else if (this.isPathSelected(path)) {
                            this.state.setGroupsActive(this.getSelectedGroups(), !this.state.isGroupActive(group));
                        } else {
                            this.state.setGroupActive(group, !this.state.isGroupActive(group));
                        }
                    }
                }
            } else if (e.getID() == 500 && e.getWhen() == this.releasedWhen) {
                e.consume();
            }
        }
        super.processMouseEvent(modifiedMouseEvent);
    }

    @Override
    public TreePath getPathForLocation(int x, int y) {
        Rectangle pathBounds;
        TreePath closestPath = this.getClosestPathForLocation(x, y);
        if (closestPath != null && (pathBounds = this.getPathBounds(closestPath)) != null && x >= pathBounds.x && y >= pathBounds.y && y < pathBounds.y + pathBounds.height) {
            return closestPath;
        }
        return null;
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return path != null && path.getLastPathComponent() instanceof SourceGroupTreeModel.GroupModel;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.renderer.setTreeHasFocus(FlatUIUtils.isPermanentFocusOwner((Component)this));
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int[] rows = this.getSelectionRows();
        if (rows != null) {
            g.setColor(this.renderer.getBackgroundSelectionColor());
            for (int i : rows) {
                Rectangle r = this.getRowBounds(i);
                g.fillRect(0, r.y, this.getWidth(), r.height);
            }
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreePath getPathTo(SourceGroup group) {
        ViewerState viewerState = this.state;
        synchronized (viewerState) {
            if (this.state.containsGroup(group)) {
                return this.model.getPathTo(new SourceGroupTreeModel.GroupModel(group, this.state));
            }
            return null;
        }
    }

    public static class SourceGroupTreeTransferHandler
    extends TransferHandler {
        private final SourceGroupTree tree;
        private final ViewerState state;

        public SourceGroupTreeTransferHandler(SourceGroupTree tree, ViewerState state) {
            this.tree = tree;
            this.state = state;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean canDrop = support.isDataFlavorSupported(SourcesTransferable.flavor);
            support.setShowDropLocation(canDrop);
            return canDrop;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable t = support.getTransferable();
                List<SourceAndConverter<?>> sources = ((SourcesTransferable.SourceList)t.getTransferData(SourcesTransferable.flavor)).getSources();
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                if (dropLocation instanceof JTree.DropLocation) {
                    JTree.DropLocation drop = (JTree.DropLocation)dropLocation;
                    TreePath path = drop.getPath();
                    if (path == null) {
                        SourceGroup group = new SourceGroup();
                        this.state.addGroup(group);
                        this.state.setGroupName(group, "new group");
                        this.state.addSourcesToGroup(sources, group);
                        SwingUtilities.invokeLater(() -> {
                            TreePath path1 = this.tree.getPathTo(group);
                            this.tree.expandPath(path1);
                            this.tree.startEditingAtPath(path1);
                        });
                    } else {
                        SourceGroupTreeModel.GroupModel groupModel = (SourceGroupTreeModel.GroupModel)path.getPathComponent(1);
                        this.state.addSourcesToGroup(sources, groupModel.getGroup());
                        SwingUtilities.invokeLater(() -> this.tree.expandPath(this.tree.getPathTo(groupModel.getGroup())));
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

