/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultApplicationModel;
import org.jhotdraw.app.DefaultMenuBuilder;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.file.ExportFileAction;
import org.jhotdraw.app.action.view.ToggleViewPropertyAction;
import org.jhotdraw.app.action.view.ViewPropertyAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.jhotdraw.draw.tool.TextCreationTool;
import org.jhotdraw.draw.tool.Tool;
import org.jhotdraw.gui.JFileURIChooser;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.samples.net.NetView;
import org.jhotdraw.samples.net.figures.NodeFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class NetApplicationModel
extends DefaultApplicationModel {
    private static final double[] scaleFactors = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
    private DefaultDrawingEditor sharedEditor;
    private HashMap<String, Action> actions;

    @Override
    public ActionMap createActionMap(Application a, @Nullable View v) {
        ActionMap m = super.createActionMap(a, v);
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        m.put("file.export", new ExportFileAction(a, v));
        AbstractViewAction aa = new ToggleViewPropertyAction(a, v, "gridVisible");
        m.put("view.toggleGrid", aa);
        drawLabels.configureAction(aa, "view.toggleGrid");
        for (double sf : scaleFactors) {
            aa = new ViewPropertyAction(a, v, "scaleFactor", Double.TYPE, new Double(sf));
            m.put((int)(sf * 100.0) + "%", aa);
            aa.putValue("Name", (int)(sf * 100.0) + " %");
        }
        return m;
    }

    public DefaultDrawingEditor getSharedEditor() {
        if (this.sharedEditor == null) {
            this.sharedEditor = new DefaultDrawingEditor();
        }
        return this.sharedEditor;
    }

    @Override
    public void initView(Application a, View p) {
        if (a.isSharingToolsAmongViews()) {
            ((NetView)p).setEditor(this.getSharedEditor());
        }
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.net.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor);
        tb.addSeparator();
        HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.FILL_COLOR, Color.white);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        attributes.put(AttributeKeys.TEXT_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new TextCreationTool(new NodeFigure(), attributes), "edit.createNode", labels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_COLOR, new Color(153));
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new LineConnectionFigure(), attributes), "edit.createLink", labels);
    }

    @Override
    public List<JToolBar> createToolBars(Application a, @Nullable View pr) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        NetView p = (NetView)pr;
        DrawingEditor editor = p == null ? this.getSharedEditor() : p.getEditor();
        LinkedList<JToolBar> list = new LinkedList<JToolBar>();
        JToolBar tb = new JToolBar();
        this.addCreationButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.drawToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAttributesButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.attributesToolBar.title"));
        list.add(tb);
        tb = new JToolBar();
        ButtonFactory.addAlignmentButtonsTo(tb, editor);
        tb.setName(drawLabels.getString("window.alignmentToolBar.title"));
        list.add(tb);
        return list;
    }

    @Override
    protected MenuBuilder createMenuBuilder() {
        return new DefaultMenuBuilder(){

            @Override
            public void addOtherViewItems(JMenu m, Application app, @Nullable View v) {
                ActionMap am = app.getActionMap(v);
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(am.get("view.toggleGrid"));
                ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get("view.toggleGrid"));
                m.add(cbmi);
                JMenu m2 = new JMenu("Zoom");
                for (double sf : scaleFactors) {
                    String id = (int)(sf * 100.0) + "%";
                    cbmi = new JCheckBoxMenuItem(am.get(id));
                    ActionUtil.configureJCheckBoxMenuItem(cbmi, am.get(id));
                    m2.add(cbmi);
                }
                m.add(m2);
            }
        };
    }

    @Override
    public URIChooser createOpenChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram .xml", "xml"));
        return c;
    }

    @Override
    public URIChooser createSaveChooser(Application a, @Nullable View v) {
        JFileURIChooser c = new JFileURIChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Net Diagram .xml", "xml"));
        return c;
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool t, DrawingEditor editor) {
            this.tool = t;
            this.editor = editor;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

