/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.h5j.fiji.adapter;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.NewImage;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.janelia.it.jacs.shared.ffmpeg.Frame;
import org.janelia.it.jacs.shared.ffmpeg.H5JLoader;
import org.janelia.it.jacs.shared.ffmpeg.ImageStack;

public class FijiAdapter {
    public static final int POOL_TIMEOUT_IN_SECONDS = 1200;
    public static final int STD_THREAD_POOL_SIZE = 8;
    private static final boolean LOG_OK = false;

    public ImagePlus getImagePlus(File inputFile) throws Exception {
        Calibration calibration = this.createCalibration();
        H5JLoader loader = new H5JLoader(inputFile.getAbsolutePath());
        ImageStack h5jImageStack = loader.extractAllChannels();
        FileInfo fileInfo = this.createFileInfo(inputFile, h5jImageStack);
        ImagePlus rtnVal = IJ.createImage((String)inputFile.getName(), (String)"RGB black", (int)fileInfo.width, (int)fileInfo.height, (int)fileInfo.nImages);
        for (int i = 0; i < fileInfo.nImages; ++i) {
            Frame frame = h5jImageStack.frame(i);
            int channelCount = frame.imageBytes.size();
            int[] packagedInts = new int[frame.imageBytes.get(0).length];
            int channelNum = 0;
            for (byte[] nextBytes : frame.imageBytes) {
                int shifter = (channelCount - channelNum - 1) * 8;
                int j = 0;
                while (j < nextBytes.length) {
                    int nextInt = this.intValue(nextBytes, j) << shifter;
                    int n = j++;
                    packagedInts[n] = packagedInts[n] + nextInt;
                }
                ++channelNum;
            }
            rtnVal.setSlice(i);
            rtnVal.getChannelProcessor().setPixels((Object)packagedInts);
        }
        rtnVal.setFileInfo(fileInfo);
        rtnVal.setCalibration(calibration);
        h5jImageStack.release();
        return rtnVal;
    }

    public ImagePlus getMultiChannelImagePlus(File inputFile) throws Exception {
        H5JLoader loader = new H5JLoader(inputFile.getAbsolutePath());
        FileInfo fileInfo = null;
        ImagePlus rtnVal = null;
        int channelNum = 1;
        int channelCount = loader.channelNames().size();
        final double[] max = new double[channelCount];
        int bytesPerPixel = 1;
        double[] spc = null;
        String unit = "";
        for (String channelName : loader.channelNames()) {
            max[channelNum - 1] = -1.7976931348623157E308;
            final ImageStack h5jImageStack = loader.extract(channelName, channelNum - 1);
            if (rtnVal == null || fileInfo == null) {
                fileInfo = this.createFileInfo(inputFile, h5jImageStack);
                bytesPerPixel = h5jImageStack.getBytesPerPixel();
                if (bytesPerPixel == 0) {
                    bytesPerPixel = 1;
                }
                if (bytesPerPixel != 1 && bytesPerPixel != 2) {
                    throw new Exception("Unexpected value for bytes-per-pixel: " + bytesPerPixel + ", value of 1 or 2 acceptable.");
                }
                spc = h5jImageStack.getSpacings();
                unit = h5jImageStack.getUnit();
                if (unit.isEmpty()) {
                    unit = "pixels";
                }
                rtnVal = NewImage.createImage((String)inputFile.getName(), (int)(fileInfo.width - h5jImageStack.getPaddingRight()), (int)(fileInfo.height - h5jImageStack.getPaddingBottom()), (int)(channelCount * fileInfo.nImages), (int)(8 * bytesPerPixel), (int)1);
                if (!Interpreter.isBatchMode()) {
                    IJ.showStatus((String)"Loading H5J...");
                    IJ.showProgress((int)channelNum, (int)channelCount);
                }
                rtnVal = new CompositeImage(rtnVal, 1);
                rtnVal.setDimensions(channelCount, fileInfo.nImages, 1);
                rtnVal.setOpenAsHyperStack(true);
            }
            final Map imageProcessors = Collections.synchronizedMap(new HashMap());
            ExecutorService buildBPPool = Executors.newFixedThreadPool(8);
            final ExecutorService applyBPPool = Executors.newFixedThreadPool(1);
            for (int i = 0; i < fileInfo.nImages; ++i) {
                final int finalChannelNum = channelNum;
                final int finalI = i;
                final FileInfo finalFileInfo = fileInfo;
                final ImagePlus finalRtnVal = rtnVal;
                if (bytesPerPixel == 1) {
                    buildBPPool.submit(new Runnable(){

                        @Override
                        public void run() {
                            final IPKey key = FijiAdapter.this.addByteProcessor(finalChannelNum, finalI, h5jImageStack, finalFileInfo, max, imageProcessors);
                            applyBPPool.submit(new Runnable(){

                                @Override
                                public void run() {
                                    FijiAdapter.this.applyProcessorToStack(imageProcessors, key, finalRtnVal, finalChannelNum);
                                }
                            });
                        }
                    });
                    continue;
                }
                if (bytesPerPixel != 2) continue;
                buildBPPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        final IPKey key = FijiAdapter.this.addShortProcessor(finalChannelNum, finalI, h5jImageStack, finalFileInfo, max, imageProcessors);
                        applyBPPool.submit(new Runnable(){

                            @Override
                            public void run() {
                                FijiAdapter.this.applyProcessorToStack(imageProcessors, key, finalRtnVal, finalChannelNum);
                            }
                        });
                    }
                });
            }
            buildBPPool.shutdown();
            buildBPPool.awaitTermination(1200L, TimeUnit.SECONDS);
            applyBPPool.shutdown();
            applyBPPool.awaitTermination(1200L, TimeUnit.SECONDS);
            ++channelNum;
            h5jImageStack.release();
        }
        if (rtnVal != null) {
            Calibration calibration = new Calibration(rtnVal);
            calibration.fps = 20.0;
            if (spc != null) {
                calibration.pixelWidth = spc[0];
                calibration.pixelHeight = spc[1];
                calibration.pixelDepth = spc[2];
                calibration.setUnit(unit);
            }
            rtnVal.setCalibration(calibration);
            for (int c = 0; c < rtnVal.getNChannels(); ++c) {
                rtnVal.setC(c + 1);
                if (max[c] > 0.0) {
                    rtnVal.setDisplayRange(0.0, max[c]);
                    continue;
                }
                if (rtnVal.getBitDepth() > 8) {
                    rtnVal.setDisplayRange(0.0, 4095.0);
                    continue;
                }
                rtnVal.setDisplayRange(0.0, 255.0);
            }
            rtnVal.setC(1);
            rtnVal.setZ(1);
        }
        String info = loader.getAllAttributeString("/");
        info = info + loader.getAllAttributeString("/Channels");
        rtnVal.setProperty("Info", (Object)info);
        loader.close();
        return rtnVal;
    }

    private void applyProcessorToStack(Map<IPKey, ImageProcessor> imageProcessors, IPKey key, ImagePlus rtnVal, int channelNum) {
        ImageProcessor cp = imageProcessors.get(key);
        int i = key.getZ();
        rtnVal.setC(channelNum);
        rtnVal.setZ(i + 1);
        rtnVal.setProcessor(cp);
    }

    private IPKey addByteProcessor(int channelNum, int i, ImageStack h5jImageStack, FileInfo fileInfo, double[] max, Map<IPKey, ImageProcessor> imageProcessors) {
        IPKey key = new IPKey();
        key.setChannelNumber(channelNum);
        key.setZ(i);
        ByteProcessor cp = this.createByteProcessor(key, h5jImageStack, fileInfo, max);
        imageProcessors.put(key, (ImageProcessor)cp);
        return key;
    }

    private IPKey addShortProcessor(int channelNum, int i, ImageStack h5jImageStack, FileInfo fileInfo, double[] max, Map<IPKey, ImageProcessor> imageProcessors) {
        IPKey key = new IPKey();
        key.setChannelNumber(channelNum);
        key.setZ(i);
        ShortProcessor cp = this.createShortProcessor(key, h5jImageStack, fileInfo, max);
        imageProcessors.put(key, (ImageProcessor)cp);
        return key;
    }

    private ByteProcessor createByteProcessor(IPKey key, ImageStack h5jImageStack, final FileInfo fileInfo, double[] max) {
        int z = key.getZ();
        Frame frame = h5jImageStack.frame(z);
        final byte[] nextBytes = frame.imageBytes.get(0);
        final int unpaddedWidth = fileInfo.width - h5jImageStack.getPaddingRight();
        int unpaddedHeight = fileInfo.height - h5jImageStack.getPaddingBottom();
        byte[] outputBytes = null;
        if (h5jImageStack.getPaddingRight() == 0 && h5jImageStack.getPaddingBottom() == 0) {
            outputBytes = nextBytes;
        } else {
            ExecutorService copyPool = Executors.newFixedThreadPool(8);
            final byte[] targetBytes = new byte[unpaddedWidth * unpaddedHeight];
            outputBytes = targetBytes;
            int i = 0;
            while (i < unpaddedHeight) {
                final int finalI = i++;
                Runnable submissible = new Runnable(){

                    @Override
                    public void run() {
                        int srcPos = finalI * fileInfo.width;
                        int destPos = finalI * unpaddedWidth;
                        System.arraycopy(nextBytes, srcPos, targetBytes, destPos, unpaddedWidth);
                    }
                };
                copyPool.submit(submissible);
            }
            copyPool.shutdown();
            try {
                copyPool.awaitTermination(1200L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ByteProcessor cp = new ByteProcessor(unpaddedWidth, unpaddedHeight);
        cp.setPixels((Object)outputBytes);
        cp.resetMinAndMax();
        if (cp.getMax() > max[key.getChannelNumber() - 1]) {
            max[key.getChannelNumber() - 1] = cp.getMax();
        }
        return cp;
    }

    private ShortProcessor createShortProcessor(IPKey key, ImageStack h5jImageStack, final FileInfo fileInfo, double[] max) {
        int i;
        int z = key.getZ();
        Frame frame = h5jImageStack.frame(z);
        final byte[] nextBytes = frame.imageBytes.get(0);
        final int unpaddedWidth = fileInfo.width - h5jImageStack.getPaddingRight();
        int unpaddedHeight = fileInfo.height - h5jImageStack.getPaddingBottom();
        byte[] outputBytes = null;
        if (h5jImageStack.getPaddingRight() == 0 && h5jImageStack.getPaddingBottom() == 0) {
            outputBytes = nextBytes;
        } else {
            ExecutorService copyPool = Executors.newFixedThreadPool(8);
            final byte[] targetBytes = new byte[unpaddedWidth * unpaddedHeight * 2];
            outputBytes = targetBytes;
            i = 0;
            while (i < unpaddedHeight) {
                final int finalI = i++;
                Runnable submissible = new Runnable(){

                    @Override
                    public void run() {
                        int srcPos = finalI * fileInfo.width * 2;
                        int destPos = finalI * unpaddedWidth * 2;
                        System.arraycopy(nextBytes, srcPos, targetBytes, destPos, unpaddedWidth * 2);
                    }
                };
                copyPool.submit(submissible);
            }
            copyPool.shutdown();
            try {
                copyPool.awaitTermination(1200L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        ShortProcessor cp = new ShortProcessor(unpaddedWidth, unpaddedHeight);
        short[] outputShorts = new short[unpaddedWidth * unpaddedHeight];
        ByteBuffer.wrap(outputBytes).order(ByteOrder.BIG_ENDIAN).asShortBuffer().get(outputShorts);
        for (i = 0; i < outputShorts.length; ++i) {
            outputShorts[i] = (short)((outputShorts[i] & 0xFFFF) / 16);
        }
        cp.setPixels((Object)outputShorts);
        cp.resetMinAndMax();
        if (cp.getMax() > max[key.getChannelNumber() - 1]) {
            max[key.getChannelNumber() - 1] = cp.getMax();
        }
        return cp;
    }

    protected int intValue(byte[] packagedBytes, int j) {
        return packagedBytes[j] < 0 ? 256 + packagedBytes[j] : packagedBytes[j];
    }

    private Calibration createCalibration() {
        Calibration calibration = new Calibration();
        calibration.xOrigin = 0.0;
        calibration.yOrigin = 0.0;
        calibration.zOrigin = 0.0;
        calibration.loop = false;
        calibration.fps = 20.0;
        calibration.pixelDepth = 1.0;
        calibration.pixelHeight = 1.0;
        calibration.pixelWidth = 1.0;
        return calibration;
    }

    private FileInfo createFileInfo(File inputFile, ImageStack h5jImageStack) {
        FileInfo rtnVal = new FileInfo();
        rtnVal.fileName = inputFile.getName();
        rtnVal.directory = inputFile.getParentFile().getAbsolutePath();
        rtnVal.gapBetweenImages = 0;
        rtnVal.whiteIsZero = false;
        rtnVal.width = h5jImageStack.width();
        rtnVal.height = h5jImageStack.height();
        rtnVal.nImages = h5jImageStack.getNumFrames();
        rtnVal.intelByteOrder = true;
        rtnVal.offset = 0;
        rtnVal.longOffset = rtnVal.offset;
        rtnVal.pixelDepth = 8.0;
        return rtnVal;
    }

    private static class IPKey {
        private int channelNumber;
        private int z;

        private IPKey() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof IPKey)) {
                return false;
            }
            IPKey otherKey = (IPKey)other;
            return otherKey.getChannelNumber() == this.getChannelNumber() && otherKey.getZ() == this.getZ();
        }

        public int hashCode() {
            return this.z << 8 & this.channelNumber;
        }

        public int getChannelNumber() {
            return this.channelNumber;
        }

        public void setChannelNumber(int channelNumber) {
            this.channelNumber = channelNumber;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }
    }
}

