/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.displaysettings.Colormap;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import java.awt.Color;

public class SpotColorGenerator
implements FeatureColorGenerator<Spot> {
    private final String feature;
    private final Color missingValueColor;
    private final Color undefinedValueColor;
    private final Colormap colormap;
    private final double min;
    private final double max;

    public SpotColorGenerator(String feature, Color missingValueColor, Color undefinedValueColor, Colormap colormap, double min, double max) {
        this.feature = feature;
        this.missingValueColor = missingValueColor;
        this.undefinedValueColor = undefinedValueColor;
        this.colormap = colormap;
        this.min = min;
        this.max = max;
    }

    @Override
    public Color color(Spot spot) {
        Double feat = spot.getFeature(this.feature);
        if (null == feat) {
            return this.missingValueColor;
        }
        if (feat.isNaN()) {
            return this.undefinedValueColor;
        }
        return this.colormap.getPaint((feat - this.min) / (this.max - this.min));
    }
}

