/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import org.drjekyll.fontchooser.FontFamilies;
import org.drjekyll.fontchooser.FontFamily;
import org.drjekyll.fontchooser.panes.SearchListener;
import org.drjekyll.fontchooser.panes.ToolTipCellRenderer;

public class FamilyPane
extends JPanel {
    private static final long serialVersionUID = 5705429171724237594L;
    private final JList<String> familyList = new JList();
    private final SearchListener searchListener;

    public FamilyPane() {
        DefaultListModel<String> familyListModel = new DefaultListModel<String>();
        FontFamilies fontFamilies = FontFamilies.getInstance();
        this.searchListener = new SearchListener(this);
        for (FontFamily fontFamily : fontFamilies) {
            String name = fontFamily.getName();
            familyListModel.addElement(name);
            this.searchListener.addFamilyName(name);
        }
        this.initializeList(familyListModel);
        this.setMinimumSize(new Dimension(80, 50));
        this.setPreferredSize(new Dimension(240, 100));
        this.setLayout(new GridBagLayout());
        this.addSearchField();
        this.addScrollPane();
    }

    private void initializeList(ListModel<String> familyListModel) {
        this.familyList.setModel(familyListModel);
        this.familyList.getSelectionModel().setSelectionMode(0);
        this.familyList.setCellRenderer(new ToolTipCellRenderer());
    }

    private void addSearchField() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        JTextField searchField = new JTextField();
        searchField.setBorder(BorderFactory.createEmptyBorder());
        searchField.requestFocus();
        searchField.addKeyListener(this.searchListener);
        this.add((Component)new JScrollPane(searchField), gridBagConstraints);
    }

    private void addScrollPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane scrollPane = new JScrollPane(this.familyList);
        this.add((Component)scrollPane, gridBagConstraints);
    }

    public void setSelectedFamily(String family) {
        this.familyList.setSelectedValue(family, true);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.familyList.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.familyList.removeListSelectionListener(listener);
    }

    public String getSelectedFamily() {
        return this.familyList.getSelectedValue();
    }
}

