/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import QuickPALM.ProcessFrame;
import QuickPALM.ReconstructionViewer;
import QuickPALM.ViewerUpdate;
import QuickPALM.ViewerUpdateShort;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Analyse_Particles
implements PlugIn {
    ImagePlus imp;
    ImageProcessor ip;
    MyDialogs dg = new MyDialogs();
    MyFunctions f = new MyFunctions();
    MyIO io = new MyIO();

    public void run(String arg) {
        int t;
        IJ.register(Analyse_Particles.class);
        if (!this.dg.analyseParticles(this.f)) {
            return;
        }
        this.f.ptable.reset();
        if (this.dg.is3d) {
            this.dg.getCalibrationFile();
            this.io.loadTransformation(this.dg.calfile, this.f.caltable);
            this.f.initialize3d();
        }
        if (this.dg.attach) {
            this.dg.getImageDirectory();
            this.imp = this.f.getNextImage(this.dg, 0);
            if (this.imp == null) {
                IJ.error((String)"could not find image following given pattern");
                return;
            }
        } else {
            this.imp = IJ.getImage();
            if (this.imp == null) {
                IJ.noImage();
                return;
            }
            if (this.imp.getType() != 0 && this.imp.getType() != 1) {
                IJ.error((String)"8 or 16 bit greyscale image required");
                return;
            }
        }
        ReconstructionViewer viewer = new ReconstructionViewer(this.imp.getShortTitle() + " Reconstruction", this.imp.getWidth(), this.imp.getHeight(), this.dg, this.f);
        ProcessFrame[] threads = new ProcessFrame[this.dg.threads];
        int freeThread = -1;
        long time_start = System.currentTimeMillis();
        long time_took = 0L;
        long time_now = 0L;
        long nparticles = 0L;
        int s = 0;
        boolean ok = true;
        while (ok) {
            if (this.dg.attach) {
                this.imp = this.f.getNextImage(this.dg, s);
                if (this.imp == null) {
                    ok = false;
                } else {
                    this.ip = this.imp.getProcessor();
                }
            } else if (s >= this.imp.getStackSize()) {
                ok = false;
            } else {
                this.imp.setSlice(s + 1);
                this.ip = this.imp.getProcessor().duplicate();
            }
            if (ok) {
                if (s < threads.length) {
                    freeThread = s;
                } else {
                    freeThread = -1;
                    while (freeThread == -1) {
                        for (t = 0; t < threads.length; ++t) {
                            if (threads[t].isAlive()) continue;
                            freeThread = t;
                            break;
                        }
                        if (freeThread != -1) continue;
                        try {
                            Thread.currentThread();
                            Thread.sleep(1L);
                        }
                        catch (Exception e) {
                            IJ.error((String)("" + e));
                        }
                    }
                }
                threads[freeThread] = new ProcessFrame();
                threads[freeThread].mysetup(this.ip, this.f, this.dg, s);
                threads[freeThread].start();
                time_now = System.currentTimeMillis();
                time_took += time_now - time_start;
                time_start = time_now;
                if (s > 0 && s % this.dg.viewer_update == 0) {
                    IJ.showStatus((String)("Processing at " + time_took / (long)this.dg.viewer_update + " ms/frame " + ((long)this.f.ptable.getCounter() - nparticles) / (long)this.dg.viewer_update + " part/frame, detected " + nparticles + " particles"));
                    nparticles = this.f.ptable.getCounter();
                    time_took = 0L;
                    if (this.dg.viewer_accumulate == 0) {
                        ViewerUpdate vUpdate = new ViewerUpdate();
                        vUpdate.mysetup(viewer);
                        vUpdate.start();
                    } else {
                        ViewerUpdateShort vUpdateShort = new ViewerUpdateShort();
                        vUpdateShort.mysetup(viewer, Math.round(s + 1 - this.dg.viewer_accumulate / 2), Math.round(s + 1 + this.dg.viewer_accumulate / 2));
                        vUpdateShort.start();
                    }
                }
            }
            ++s;
        }
        for (t = 0; t < threads.length; ++t) {
            try {
                if (threads[t] == null) continue;
                threads[t].join();
                continue;
            }
            catch (Exception e) {
                IJ.error((String)("" + e));
            }
        }
        if (this.f.psave != null) {
            this.f.psave.close();
        }
        if (this.dg.viewer_accumulate == 0) {
            viewer.update();
        } else {
            viewer.updateShort(Math.round(s - this.dg.viewer_accumulate / 2), s);
        }
        if (this.f.ptable.getCounter() < 5000000) {
            IJ.showStatus((String)"Creating particle table, this should take a few seconds...");
            this.f.ptable.show("Results");
        } else {
            IJ.showMessage((String)"Warning", (String)"Results table has too many particles, they will not be shown but the data still exists within it\nyou can still use all the plugin functionality or save table changes though the 'Save Particle Table' command.");
        }
    }
}

