/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;

@Compression.CompressionType(value="xz")
public class XzCompression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    private static final long serialVersionUID = -7272153943564743774L;
    @Compression.CompressionParameter
    private final int preset;

    public XzCompression(int preset) {
        this.preset = preset;
    }

    public XzCompression() {
        this(6);
    }

    @Override
    public InputStream getInputStream(InputStream in) throws IOException {
        return new XZCompressorInputStream(in);
    }

    @Override
    public OutputStream getOutputStream(OutputStream out) throws IOException {
        return new XZCompressorOutputStream(out, this.preset);
    }

    @Override
    public XzCompression getReader() {
        return this;
    }

    @Override
    public XzCompression getWriter() {
        return this;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != XzCompression.class) {
            return false;
        }
        return this.preset == ((XzCompression)other).preset;
    }
}

