/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter.read;

import java.util.function.Supplier;
import net.imglib2.Cursor;
import net.imglib2.converter.AbstractConvertedCursor;
import net.imglib2.converter.BiConverter;

public class BiConvertedCursor<A, B, C>
extends AbstractConvertedCursor<A, C> {
    protected final Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier;
    protected final BiConverter<? super A, ? super B, ? super C> converter;
    protected final Cursor<B> sourceB;
    protected final Supplier<? extends C> convertedSupplier;
    protected final C converted;

    public BiConvertedCursor(Cursor<A> sourceA, Cursor<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<? extends C> convertedSupplier) {
        super(sourceA);
        this.sourceB = sourceB;
        this.converterSupplier = converterSupplier;
        this.converter = converterSupplier.get();
        this.convertedSupplier = convertedSupplier;
        this.converted = convertedSupplier.get();
    }

    public BiConvertedCursor(Cursor<A> sourceA, Cursor<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<? extends C> convertedSupplier) {
        this(sourceA, sourceB, () -> converter, convertedSupplier);
    }

    @Override
    public C get() {
        this.converter.convert(this.source.get(), this.sourceB.get(), this.converted);
        return this.converted;
    }

    @Override
    public C getType() {
        return this.converted;
    }

    @Override
    public void jumpFwd(long steps) {
        this.source.jumpFwd(steps);
        this.sourceB.jumpFwd(steps);
    }

    @Override
    public void fwd() {
        this.source.fwd();
        this.sourceB.fwd();
    }

    @Override
    public void reset() {
        this.source.reset();
        this.sourceB.reset();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public void remove() {
        this.source.remove();
        this.sourceB.remove();
    }

    @Override
    public BiConvertedCursor<A, B, C> copy() {
        return new BiConvertedCursor<A, B, C>(this.source.copy(), this.sourceB.copy(), this.converterSupplier, this.convertedSupplier);
    }
}

