/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class Calculator_Plus
implements PlugIn {
    static String title = "Calculator Plus";
    static final int SCALE = 0;
    static final int ADD = 1;
    static final int SUBTRACT = 2;
    static final int MULTIPLY = 3;
    static final int DIVIDE = 4;
    static String[] ops = new String[]{"Scale: i2 = i1 x k1 + k2", "Add: i2 = (i1+i2) x k1 + k2", "Subtract: i2 = (i1-i2) x k1 + k2", "Multiply: i2 = (i1*i2) x k1 + k2", "Divide: i2 = (i1/i2) x k1 + k2"};
    static int operation = 0;
    static double k1 = 1.0;
    static double k2 = 0.0;
    static boolean createWindow = true;
    static boolean rgbPlanes = false;
    int[] wList;
    private String[] titles;
    int i1Index;
    int i2Index;
    ImagePlus i1;
    ImagePlus i2;
    boolean replicate;

    public void run(String arg) {
        boolean calibrated;
        if (IJ.versionLessThan((String)"1.27w")) {
            return;
        }
        this.wList = WindowManager.getIDList();
        if (this.wList == null || this.wList.length < 2) {
            IJ.showMessage((String)title, (String)"There must be at least two windows open");
            return;
        }
        this.titles = new String[this.wList.length];
        for (int i = 0; i < this.wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)this.wList[i]);
            this.titles[i] = imp != null ? imp.getTitle() : "";
        }
        if (!this.showDialog()) {
            return;
        }
        long start = System.currentTimeMillis();
        boolean bl = calibrated = this.i1.getCalibration().calibrated() || this.i2.getCalibration().calibrated();
        if (calibrated) {
            createWindow = true;
        }
        if (createWindow) {
            this.i2 = this.replicate ? this.replicateImage(this.i2, calibrated, this.i1.getStackSize()) : this.duplicateImage(this.i2, calibrated);
            if (this.i2 == null) {
                IJ.showMessage((String)title, (String)"Out of memory");
                return;
            }
            this.i2.show();
        }
        this.calculate(this.i1, this.i2, k1, k2);
        IJ.showStatus((String)(IJ.d2s((double)((double)(System.currentTimeMillis() - start) / 1000.0), (int)2) + " seconds"));
    }

    public boolean showDialog() {
        GenericDialog gd = new GenericDialog(title);
        gd.addChoice("i1:", this.titles, this.titles[0]);
        gd.addChoice("i2:", this.titles, this.titles[1]);
        gd.addChoice("Operation:", ops, ops[operation]);
        gd.addNumericField("k1:", k1, 1);
        gd.addNumericField("k2:", k2, 1);
        gd.addCheckbox("Create New Window", createWindow);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        int i1Index = gd.getNextChoiceIndex();
        int i2Index = gd.getNextChoiceIndex();
        operation = gd.getNextChoiceIndex();
        k1 = gd.getNextNumber();
        k2 = gd.getNextNumber();
        createWindow = gd.getNextBoolean();
        this.i1 = WindowManager.getImage((int)this.wList[i1Index]);
        this.i2 = WindowManager.getImage((int)this.wList[i2Index]);
        if (this.i1.getBitDepth() == 24 && this.i2.getBitDepth() == 24) {
            rgbPlanes = true;
        }
        int d1 = this.i1.getStackSize();
        int d2 = this.i2.getStackSize();
        if (d2 == 1 && d1 > 1) {
            createWindow = true;
            this.replicate = true;
        }
        return true;
    }

    public void calculate(ImagePlus i1, ImagePlus i2, double k1, double k2) {
        double v2 = 0.0;
        int g = 0;
        int b = 0;
        int width = i1.getWidth();
        int height = i1.getHeight();
        int slices1 = i1.getStackSize();
        int slices2 = i2.getStackSize();
        float[] ctable1 = i1.getCalibration().getCTable();
        float[] ctable2 = i2.getCalibration().getCTable();
        ImageStack stack1 = i1.getStack();
        ImageStack stack2 = i2.getStack();
        int currentSlice = i2.getCurrentSlice();
        for (int n = 1; n <= slices2; ++n) {
            int y;
            int x;
            ImageProcessor ip1 = stack1.getProcessor(n <= slices1 ? n : slices1);
            ImageProcessor ip2 = stack2.getProcessor(n);
            ip1.setCalibrationTable(ctable1);
            ip2.setCalibrationTable(ctable2);
            if (rgbPlanes) {
                for (x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        int iv1 = ip1.getPixel(x, y);
                        int iv2 = ip2.getPixel(x, y);
                        double r1 = (iv1 & 0xFF0000) >> 16;
                        double g1 = (iv1 & 0xFF00) >> 8;
                        double b1 = iv1 & 0xFF;
                        double r2 = (iv2 & 0xFF0000) >> 16;
                        double g2 = (iv2 & 0xFF00) >> 8;
                        double b2 = iv2 & 0xFF;
                        switch (operation) {
                            case 0: {
                                r2 = r1;
                                g2 = g1;
                                b2 = b1;
                                break;
                            }
                            case 1: {
                                r2 += r1;
                                g2 += g1;
                                b2 += b1;
                                break;
                            }
                            case 2: {
                                r2 = r1 - r2;
                                g2 = g1 - g2;
                                b2 = b1 - b2;
                                break;
                            }
                            case 3: {
                                r2 *= r1;
                                g2 *= g1;
                                b2 *= b1;
                                break;
                            }
                            case 4: {
                                r2 = r2 != 0.0 ? r1 / r2 : 0.0;
                                g2 = g2 != 0.0 ? g1 / g2 : 0.0;
                                b2 = b2 != 0.0 ? b1 / b2 : 0.0;
                            }
                        }
                        r2 = r2 * k1 + k2;
                        g2 = g2 * k1 + k2;
                        b2 = b2 * k1 + k2;
                        int r = (int)Math.floor((r2 > 255.0 ? 255.0 : (r2 < 0.0 ? 0.0 : r2)) + 0.5);
                        g = (int)Math.floor((g2 > 255.0 ? 255.0 : (g2 < 0.0 ? 0.0 : g2)) + 0.5);
                        b = (int)Math.floor((b2 > 255.0 ? 255.0 : (b2 < 0.0 ? 0.0 : b2)) + 0.5);
                        ip2.putPixel(x, y, ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF));
                    }
                }
            } else {
                for (x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        double v1 = ip1.getPixelValue(x, y);
                        v2 = ip2.getPixelValue(x, y);
                        switch (operation) {
                            case 0: {
                                v2 = v1;
                                break;
                            }
                            case 1: {
                                v2 += v1;
                                break;
                            }
                            case 2: {
                                v2 = v1 - v2;
                                break;
                            }
                            case 3: {
                                v2 *= v1;
                                break;
                            }
                            case 4: {
                                v2 = v2 != 0.0 ? v1 / v2 : 0.0;
                            }
                        }
                        v2 = v2 * k1 + k2;
                        ip2.putPixelValue(x, y, v2);
                    }
                }
            }
            if (n == currentSlice) {
                i2.getProcessor().resetMinAndMax();
                i2.updateAndDraw();
            }
            IJ.showProgress((double)((double)n / (double)slices2));
            IJ.showStatus((String)(n + "/" + slices2));
        }
    }

    ImagePlus duplicateImage(ImagePlus img1, boolean calibrated) {
        ImageStack stack1 = img1.getStack();
        int width = stack1.getWidth();
        int height = stack1.getHeight();
        int n = stack1.getSize();
        ImageStack stack2 = img1.createEmptyStack();
        float[] ctable = img1.getCalibration().getCTable();
        try {
            for (int i = 1; i <= n; ++i) {
                ImageProcessor ip1 = stack1.getProcessor(i);
                ImageProcessor ip2 = ip1.duplicate();
                if (calibrated) {
                    ip2.setCalibrationTable(ctable);
                    ip2 = ip2.convertToFloat();
                }
                stack2.addSlice(stack1.getSliceLabel(i), ip2);
            }
        }
        catch (OutOfMemoryError e) {
            stack2.trim();
            stack2 = null;
            return null;
        }
        ImagePlus img2 = new ImagePlus("Result", stack2);
        return img2;
    }

    ImagePlus replicateImage(ImagePlus img1, boolean calibrated, int n) {
        ImageProcessor ip1 = img1.getProcessor();
        int width = ip1.getWidth();
        int height = ip1.getHeight();
        ImageStack stack2 = img1.createEmptyStack();
        float[] ctable = img1.getCalibration().getCTable();
        try {
            for (int i = 1; i <= n; ++i) {
                ImageProcessor ip2 = ip1.duplicate();
                if (calibrated) {
                    ip2.setCalibrationTable(ctable);
                    ip2 = ip2.convertToFloat();
                }
                stack2.addSlice(null, ip2);
            }
        }
        catch (OutOfMemoryError e) {
            stack2.trim();
            stack2 = null;
            return null;
        }
        ImagePlus img2 = new ImagePlus("Result", stack2);
        return img2;
    }
}

