/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot.jfreechart;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.scijava.plot.MarkerStyle;

class AwtMarkerStyles {
    private final boolean visible;
    private final boolean filled;
    private final Shape shape;
    private static AwtMarkerStyles none = new AwtMarkerStyles(false, false, null);
    private static AwtMarkerStyles plus = new AwtMarkerStyles(true, false, Shapes.access$000());
    private static AwtMarkerStyles x = new AwtMarkerStyles(true, false, Shapes.access$100());
    private static AwtMarkerStyles star = new AwtMarkerStyles(true, false, Shapes.access$200());
    private static AwtMarkerStyles square = new AwtMarkerStyles(true, false, Shapes.access$300());
    private static AwtMarkerStyles filledSquare = new AwtMarkerStyles(true, true, Shapes.access$300());
    private static AwtMarkerStyles circle = new AwtMarkerStyles(true, false, Shapes.access$400());
    private static AwtMarkerStyles filledCircle = new AwtMarkerStyles(true, true, Shapes.access$400());

    private AwtMarkerStyles(boolean visible, boolean filled, Shape shape) {
        this.visible = visible;
        this.filled = filled;
        this.shape = shape;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public Shape getShape() {
        return this.shape;
    }

    public static AwtMarkerStyles getInstance(MarkerStyle style) {
        if (style != null) {
            switch (style) {
                case NONE: {
                    return none;
                }
                case PLUS: {
                    return plus;
                }
                case X: {
                    return x;
                }
                case STAR: {
                    return star;
                }
                case SQUARE: {
                    return square;
                }
                case FILLEDSQUARE: {
                    return filledSquare;
                }
                case CIRCLE: {
                    return circle;
                }
                case FILLEDCIRCLE: {
                    return filledCircle;
                }
            }
        }
        return square;
    }

    private static class Shapes {
        private static Shape x = Shapes.getAwtXShape();
        private static Shape plus = Shapes.getAwtPlusShape();
        private static Shape star = Shapes.getAwtStarShape();
        private static Shape square = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
        private static Shape circle = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);

        private Shapes() {
        }

        private static Shape getAwtXShape() {
            Path2D.Double p = new Path2D.Double();
            double s = 3.0;
            ((Path2D)p).moveTo(-3.0, -3.0);
            ((Path2D)p).lineTo(3.0, 3.0);
            ((Path2D)p).moveTo(3.0, -3.0);
            ((Path2D)p).lineTo(-3.0, 3.0);
            return p;
        }

        private static Shape getAwtPlusShape() {
            Path2D.Double p = new Path2D.Double();
            double t = 4.0;
            ((Path2D)p).moveTo(0.0, -4.0);
            ((Path2D)p).lineTo(0.0, 4.0);
            ((Path2D)p).moveTo(4.0, 0.0);
            ((Path2D)p).lineTo(-4.0, 0.0);
            return p;
        }

        private static Shape getAwtStarShape() {
            Path2D.Double p = new Path2D.Double();
            double s = 3.0;
            ((Path2D)p).moveTo(-3.0, -3.0);
            ((Path2D)p).lineTo(3.0, 3.0);
            ((Path2D)p).moveTo(3.0, -3.0);
            ((Path2D)p).lineTo(-3.0, 3.0);
            double t = 4.0;
            ((Path2D)p).moveTo(0.0, -4.0);
            ((Path2D)p).lineTo(0.0, 4.0);
            ((Path2D)p).moveTo(4.0, 0.0);
            ((Path2D)p).lineTo(-4.0, 0.0);
            return p;
        }

        static /* synthetic */ Shape access$000() {
            return plus;
        }

        static /* synthetic */ Shape access$100() {
            return x;
        }

        static /* synthetic */ Shape access$200() {
            return star;
        }

        static /* synthetic */ Shape access$300() {
            return square;
        }

        static /* synthetic */ Shape access$400() {
            return circle;
        }
    }
}

