/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.AbstractArrayCursor;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayLocalizingCursor;
import net.imglib2.img.array.ArrayLocalizingSpliterator;
import net.imglib2.img.array.ArrayLocalizingSubIntervalCursor;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.array.ArraySpliterator;
import net.imglib2.img.array.ArraySubIntervalCursor;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Fraction;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.view.iteration.SubIntervalIterable;

public class ArrayImg<T extends NativeType<T>, A extends DataAccess>
extends AbstractNativeImg<T, A>
implements SubIntervalIterable<T> {
    final int[] steps;
    final int[] dim;
    private final A data;

    public ArrayImg(A data, long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        this.dim = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dim[d] = (int)dim[d];
        }
        this.steps = new int[this.n];
        IntervalIndexer.createAllocationSteps(this.dim, this.steps);
        this.data = data;
    }

    @Override
    public A update(Object o) {
        return (A)this.data.createView(o);
    }

    @Override
    public ArrayCursor<T> cursor() {
        return new ArrayCursor(this);
    }

    @Override
    public ArrayLocalizingCursor<T> localizingCursor() {
        return new ArrayLocalizingCursor(this);
    }

    @Override
    public ArrayRandomAccess<T> randomAccess() {
        return new ArrayRandomAccess(this);
    }

    @Override
    public ArrayRandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    @Override
    public ArrayImgFactory<T> factory() {
        return new ArrayImgFactory<NativeType>(this.linkedType);
    }

    public ArrayImg<T, ?> copy() {
        NativeImg copy = ((ArrayImgFactory)this.factory()).create(this.dimension);
        Cursor source = this.cursor();
        Cursor target = ((ArrayImg)copy).cursor();
        while (((AbstractArrayCursor)source).hasNext()) {
            ((NativeType)target.next()).set((Type)source.next());
        }
        return copy;
    }

    @Override
    public Cursor<T> cursor(Interval interval) {
        int dimLength = this.fastCursorAvailable(interval);
        assert (dimLength > 0);
        return new ArraySubIntervalCursor(this, (int)this.offset(interval), (int)this.size(interval, dimLength));
    }

    private long size(Interval interval, int length) {
        long size = interval.dimension(0);
        for (int d = 1; d < length; ++d) {
            size *= interval.dimension(d);
        }
        return size;
    }

    private long offset(Interval interval) {
        int maxDim = this.numDimensions() - 1;
        long i = interval.min(maxDim);
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * this.dimension(d) + interval.min(d);
        }
        return i;
    }

    private int fastCursorAvailable(Interval interval) {
        int dimIdx;
        if (!Intervals.contains((Interval)this, interval)) {
            return -1;
        }
        for (dimIdx = 0; dimIdx < this.n && interval.dimension(dimIdx) == this.dimension(dimIdx); ++dimIdx) {
        }
        if (dimIdx == this.n) {
            return dimIdx;
        }
        for (int d = ++dimIdx; d < this.n; ++d) {
            if (interval.dimension(d) == 1L) continue;
            return -1;
        }
        return dimIdx;
    }

    @Override
    public Cursor<T> localizingCursor(Interval interval) {
        int dimLength = this.fastCursorAvailable(interval);
        assert (dimLength > 0);
        return new ArrayLocalizingSubIntervalCursor(this, (int)this.offset(interval), (int)this.size(interval, dimLength));
    }

    @Override
    public boolean supportsOptimizedCursor(Interval interval) {
        return this.fastCursorAvailable(interval) > 0;
    }

    @Override
    public Object subIntervalIterationOrder(Interval interval) {
        return new FlatIterationOrder(interval);
    }

    @Override
    public LocalizableSpliterator<T> spliterator() {
        return new ArraySpliterator(this, 0, (int)this.size());
    }

    @Override
    public LocalizableSpliterator<T> localizingSpliterator() {
        return new ArrayLocalizingSpliterator(this, 0, (int)this.size());
    }

    @Deprecated
    public ArrayImg(Object data, long[] dim, Fraction entitiesPerPixel) {
        this((DataAccess)data, dim, entitiesPerPixel);
    }
}

