/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.stack;

import java.lang.reflect.Array;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.stack.NearestNeighborRealRandomAccessibleStackInterpolator;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Cast;

public class LinearRealRandomAccessibleStackInterpolator<T extends NumericType<T>>
extends NearestNeighborRealRandomAccessibleStackInterpolator<T> {
    protected RealRandomAccess<T> sliceAccess2;
    protected final T value;
    protected final T tmp;
    protected double w = 1.0;
    protected double w1 = 0.0;

    public LinearRealRandomAccessibleStackInterpolator(RealRandomAccessible<T>[] slices) {
        super(slices);
        if (slices.length > 1) {
            this.sliceAccesses[1] = slices[1].realRandomAccess();
            this.sliceAccess2 = this.sliceAccesses[1];
        } else {
            this.sliceAccess2 = this.sliceAccess;
        }
        this.value = (NumericType)((NumericType)this.sliceAccess.get()).createVariable();
        this.tmp = (NumericType)this.value.createVariable();
    }

    public LinearRealRandomAccessibleStackInterpolator(List<RealRandomAccessible<T>> slices) {
        this((RealRandomAccessible[])slices.toArray((Object[])Cast.unchecked(Array.newInstance(RealRandomAccessible.class, slices.size()))));
    }

    protected LinearRealRandomAccessibleStackInterpolator(LinearRealRandomAccessibleStackInterpolator<T> a) {
        super(a);
        if (a.sliceAccess != a.sliceAccess2) {
            this.sliceAccesses[this.sliceIndex + 1] = this.sliceAccess2 = a.sliceAccess2.copy();
        }
        this.value = (NumericType)((NumericType)this.sliceAccess.get()).createVariable();
        this.tmp = (NumericType)this.value.createVariable();
    }

    @Override
    protected int getSliceIndex(double position) {
        return Math.max(0, Math.min(this.lastSliceIndex, (int)Math.floor(position)));
    }

    @Override
    protected void setSlice(int i) {
        if (i != this.sliceIndex) {
            this.sliceIndex = i;
            RealRandomAccess access = this.getOrCreateAccess(i);
            access.setPosition(this.sliceAccess);
            this.sliceAccess = access;
            if (i < this.lastSliceIndex) {
                this.sliceAccess2 = this.getOrCreateAccess(i + 1);
                this.sliceAccess2.setPosition(this.sliceAccess);
            } else {
                this.sliceAccess2 = this.sliceAccess;
            }
        }
    }

    @Override
    protected void updateSlice(int i) {
        this.sliceIndex = i;
        this.sliceAccess = this.getOrCreateAccess(i);
        this.sliceAccess2 = i < this.lastSliceIndex ? this.getOrCreateAccess(i + 1) : this.sliceAccess;
    }

    protected void updateW() {
        this.w1 = this.position[this.sd];
        this.w1 -= Math.floor(this.w1);
        this.w = 1.0 - this.w1;
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
        if (d < this.sd) {
            this.sliceAccess.fwd(d);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.fwd(d);
            }
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
        }
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
        if (d < this.sd) {
            this.sliceAccess.bck(d);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.bck(d);
            }
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
        }
    }

    @Override
    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
        if (d < this.sd) {
            this.sliceAccess.move(distance, d);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance, d);
            }
        } else {
            this.setSlice(this.getSliceIndex(this.position[d]));
            this.updateW();
        }
    }

    @Override
    public void move(RealLocalizable distance) {
        double sliceShift = distance.getDoublePosition(this.sd);
        if (sliceShift == 0.0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void move(Localizable distance) {
        long sliceShift = distance.getLongPosition(this.sd);
        if (sliceShift == 0L) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance.getDoublePosition(d);
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void move(int[] distance) {
        int sliceShift = distance[this.sd];
        if (sliceShift == 0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void move(long[] distance) {
        long sliceShift = distance[this.sd];
        if (sliceShift == 0L) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void move(double[] distance) {
        double sliceShift = distance[this.sd];
        if (sliceShift == 0.0) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void move(float[] distance) {
        float sliceShift = distance[this.sd];
        if (sliceShift == 0.0f) {
            for (int d = 0; d < this.sd; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            this.sliceAccess.move(distance);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.move(distance);
            }
        } else {
            for (int d = 0; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
            int newSliceIndex = this.getSliceIndex(this.position[this.sd]);
            if (this.sliceIndex == newSliceIndex) {
                this.sliceAccess.move(distance);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.move(distance);
                }
            } else {
                this.updateSlice(newSliceIndex);
                this.sliceAccess.setPosition(this.position);
                if (this.sliceAccess2 != this.sliceAccess) {
                    this.sliceAccess2.setPosition(this.position);
                }
            }
            this.updateW();
        }
    }

    @Override
    public void setPosition(Localizable position) {
        int newSliceIndex = this.getSliceIndex(position.getDoublePosition(this.sd));
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position.getDoublePosition(d);
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(RealLocalizable position) {
        int newSliceIndex = this.getSliceIndex(position.getDoublePosition(this.sd));
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position.getDoublePosition(d);
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(int[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(long[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(double[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(float[] position) {
        int newSliceIndex = this.getSliceIndex(position[this.sd]);
        if (this.sliceIndex != newSliceIndex) {
            this.updateSlice(newSliceIndex);
        }
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        this.sliceAccess.setPosition(this.position);
        if (this.sliceAccess2 != this.sliceAccess) {
            this.sliceAccess2.setPosition(position);
        }
        this.updateW();
    }

    @Override
    public void setPosition(int pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(long pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(float pos, int d) {
        this.setPosition((double)pos, d);
    }

    @Override
    public void setPosition(double pos, int d) {
        this.position[d] = pos;
        if (d < this.sd) {
            this.sliceAccess.setPosition(pos, d);
            if (this.sliceAccess2 != this.sliceAccess) {
                this.sliceAccess2.setPosition(pos, d);
            }
        } else {
            this.setSlice(this.getSliceIndex(pos));
            this.updateW();
        }
    }

    @Override
    public T get() {
        NumericType a = (NumericType)this.sliceAccess.get();
        NumericType b = (NumericType)this.sliceAccess2.get();
        this.value.set((NumericType)a);
        this.value.mul(this.w);
        this.tmp.set((NumericType)b);
        this.tmp.mul(this.w1);
        this.value.add(this.tmp);
        return this.value;
    }

    @Override
    public LinearRealRandomAccessibleStackInterpolator<T> copy() {
        return new LinearRealRandomAccessibleStackInterpolator<T>(this);
    }
}

