/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util.iterationcode;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.roi.util.iterationcode.IterationCode;

public class IterationCodeBuilder
extends AbstractEuclideanSpace
implements IterationCode {
    private final TIntArrayList itcode = new TIntArrayList();
    private final long itcodeOffsetX;
    private long size;
    protected long[] prev;
    protected long[] curr;
    private final long[] bbmin;
    private final long[] bbmax;
    private boolean startedRasterization;
    private long rasterBegin;

    public IterationCodeBuilder(int numDimensions, long minX) {
        super(numDimensions);
        this.itcodeOffsetX = minX;
        this.size = 0L;
        this.prev = new long[this.n];
        this.curr = new long[this.n];
        this.bbmin = new long[this.n];
        this.bbmax = new long[this.n];
        Arrays.fill(this.bbmin, Long.MAX_VALUE);
        Arrays.fill(this.bbmax, Long.MIN_VALUE);
        this.startedRasterization = false;
        this.rasterBegin = 0L;
    }

    public void add(Localizable pos) {
        int d;
        ++this.size;
        pos.localize(this.curr);
        if (this.startedRasterization) {
            for (d = this.n - 1; d >= 0; --d) {
                if (d == 0) {
                    if (this.curr[0] == this.prev[0] + 1L) continue;
                    this.endRaster(0);
                    break;
                }
                if (this.curr[d] == this.prev[d]) continue;
                this.endRaster(d);
                break;
            }
            for (d = 0; d < this.n; ++d) {
                if (this.curr[d] < this.bbmin[d]) {
                    this.bbmin[d] = this.curr[d];
                    continue;
                }
                if (this.curr[d] <= this.bbmax[d]) continue;
                this.bbmax[d] = this.curr[d];
            }
        } else {
            this.itcode.add((int)this.itcodeOffsetX);
            for (d = 1; d < this.n; ++d) {
                this.itcode.add((int)this.curr[d]);
            }
            this.rasterBegin = this.curr[0];
            System.arraycopy(this.curr, 0, this.bbmin, 0, this.n);
            System.arraycopy(this.curr, 0, this.bbmax, 0, this.n);
            this.startedRasterization = true;
        }
        long[] tmp = this.prev;
        this.prev = this.curr;
        this.curr = tmp;
    }

    private void endRaster(int badDimension) {
        this.itcode.add((int)(this.rasterBegin - this.itcodeOffsetX));
        this.itcode.add((int)(this.prev[0] - this.itcodeOffsetX));
        if (badDimension > 0) {
            this.itcode.add(-badDimension);
            for (int d = 1; d <= badDimension; ++d) {
                this.itcode.add((int)this.curr[d]);
            }
        }
        this.rasterBegin = this.curr[0];
    }

    public void finish() {
        if (this.startedRasterization) {
            this.itcode.add((int)(this.rasterBegin - this.itcodeOffsetX));
            this.itcode.add((int)(this.prev[0] - this.itcodeOffsetX));
        }
        this.itcode.trimToSize();
        this.prev = null;
        this.curr = null;
    }

    @Override
    public TIntArrayList getItcode() {
        return this.itcode;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long[] getBoundingBoxMin() {
        return this.bbmin;
    }

    @Override
    public long[] getBoundingBoxMax() {
        return this.bbmax;
    }
}

