/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.planar.PlanarCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class PlanarLocalizableCursor<T extends Type<T>>
extends PlanarCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public PlanarLocalizableCursor(PlanarContainer<T, ?> container, Image<T> image, T type) {
        this(container, image, type, true);
    }

    PlanarLocalizableCursor(PlanarContainer<T, ?> container, Image<T> image, T type, boolean reset) {
        super(container, image, type);
        this.numDimensions = container.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = container.getDimensions();
        if (reset) {
            this.reset();
        }
    }

    @Override
    public void fwd() {
        super.fwd();
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] < this.dimensions[d]) {
                return;
            }
            this.position[d] = 0;
        }
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.isClosed = false;
        this.type.updateIndex(-1);
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
        this.sliceIndex = 0;
        this.type.updateContainer(this);
        this.hasNext = true;
    }

    @Override
    public void getPosition(int[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            pos[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

