/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.nearestneighbor;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.Interpolator2D;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class NearestNeighborInterpolator2D<T extends Type<T>>
extends NearestNeighborInterpolator<T>
implements Interpolator2D<T> {
    float x = 0.0f;
    float y = 0.0f;

    protected NearestNeighborInterpolator2D(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
    }

    @Override
    public Image<T> getImage() {
        return this.img;
    }

    @Override
    public void getPosition(float[] position) {
        position[0] = this.x;
        position[1] = this.y;
    }

    @Override
    public float[] getPosition() {
        return new float[]{this.x, this.y};
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public void moveTo(float x, float y) {
        this.x = x;
        this.y = y;
        int ix = Util.round(x);
        int iy = Util.round(y);
        this.cursor.move(ix - this.cursor.getPosition(0), 0);
        this.cursor.move(iy - this.cursor.getPosition(1), 1);
    }

    @Override
    public void moveTo(float[] pos) {
        this.moveTo(pos[0], pos[1]);
    }

    @Override
    public void moveTo(double[] pos) {
        this.moveTo((float)pos[0], (float)pos[1]);
    }

    @Override
    public void moveRel(float x, float y) {
        this.x += x;
        this.y += y;
        this.cursor.move(Util.round(this.x) - this.cursor.getPosition(0), 0);
        this.cursor.move(Util.round(this.y) - this.cursor.getPosition(1), 1);
    }

    @Override
    public void moveRel(float[] vector) {
        this.moveRel(vector[0], vector[1]);
    }

    @Override
    public void moveRel(double[] vector) {
        this.moveRel((float)vector[0], (float)vector[1]);
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        this.cursor.setPosition(Util.round(x), 0);
        this.cursor.setPosition(Util.round(y), 1);
    }

    @Override
    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1]);
    }

    @Override
    public void setPosition(double[] pos) {
        this.setPosition((float)pos[0], (float)pos[1]);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }
}

