/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomLineMesh;
import customnode.CustomMesh;
import customnode.CustomPointMesh;
import customnode.CustomQuadMesh;
import customnode.CustomTriangleMesh;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;

public class WavefrontLoader {
    private HashMap<String, CustomMesh> meshes;
    private BufferedReader in;
    private String line;
    private final ArrayList<Point3f> vertices = new ArrayList();
    private ArrayList<Point3f> indices = new ArrayList();
    private String name = null;
    private Color4f material = null;
    private int type = -1;
    private String objfile = null;

    public static HashMap<String, CustomMesh> load(String objfile) throws IOException {
        WavefrontLoader wl = new WavefrontLoader();
        try {
            wl.parse(objfile);
        }
        catch (RuntimeException e) {
            System.out.println("error reading " + wl.name);
            throw e;
        }
        return wl.meshes;
    }

    private WavefrontLoader() {
    }

    private void parse(String objfile) throws IOException {
        CustomMesh cm;
        this.objfile = objfile;
        File f = new File(objfile);
        this.in = new BufferedReader(new FileReader(objfile));
        HashMap<String, Color4f> materials = null;
        this.meshes = new HashMap();
        while ((this.line = this.in.readLine()) != null) {
            if (this.line.startsWith("mtllib")) {
                String mtlName = this.line.split("\\s+")[1].trim();
                materials = this.readMaterials(f, mtlName);
                continue;
            }
            if (this.line.startsWith("g ")) {
                if (this.name != null) {
                    cm = this.createCustomMesh();
                    if (cm != null) {
                        this.meshes.put(this.name, cm);
                    }
                    this.indices = new ArrayList();
                    this.material = null;
                }
                this.name = this.line.split("\\s+")[1].trim();
                continue;
            }
            if (this.line.startsWith("usemtl ")) {
                if (materials == null) continue;
                this.material = materials.get(this.line.split("\\s+")[1]);
                continue;
            }
            if (this.line.startsWith("v ")) {
                this.readVertex();
                continue;
            }
            if (this.line.startsWith("f ")) {
                this.readFace();
                continue;
            }
            if (this.line.startsWith("l ")) {
                this.readFace();
                continue;
            }
            if (!this.line.startsWith("p ")) continue;
            this.readFace();
        }
        if (this.name != null && this.indices.size() > 0) {
            cm = this.createCustomMesh();
            if (cm != null) {
                this.meshes.put(this.name, cm);
            }
            this.indices = new ArrayList();
            this.material = null;
        }
    }

    private CustomMesh createCustomMesh() {
        if (this.indices.size() == 0) {
            return null;
        }
        CustomMesh cm = null;
        switch (this.type) {
            case 1: {
                cm = new CustomPointMesh(this.indices);
                break;
            }
            case 2: {
                cm = new CustomLineMesh(this.indices, 0);
                break;
            }
            case 3: {
                cm = new CustomTriangleMesh(this.indices);
                break;
            }
            case 4: {
                cm = new CustomQuadMesh(this.indices);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected number of vertices for faces");
            }
        }
        cm.loadedFromFile = this.objfile;
        cm.loadedFromName = this.name;
        cm.changed = false;
        if (this.material == null) {
            return cm;
        }
        cm.setColor(new Color3f(this.material.x, this.material.y, this.material.z));
        cm.setTransparency(this.material.w);
        cm.changed = false;
        return cm;
    }

    private void readFace() {
        String[] sp = this.line.split("\\s+");
        this.type = sp.length - 1;
        for (int i = 1; i < sp.length; ++i) {
            int idx;
            block4: {
                idx = -1;
                try {
                    idx = Integer.parseInt(sp[i]) - 1;
                }
                catch (NumberFormatException e) {
                    int l = sp[i].indexOf(47);
                    if (l == -1) break block4;
                    sp[i] = sp[i].substring(0, l);
                    idx = Integer.parseInt(sp[i]) - 1;
                }
            }
            if (idx == -1) {
                throw new RuntimeException("Error parsing faces: " + this.name);
            }
            this.indices.add(this.vertices.get(idx));
        }
    }

    private void readVertex() {
        String[] sp = this.line.split("\\s+");
        this.vertices.add(new Point3f(Float.parseFloat(sp[1]), Float.parseFloat(sp[2]), Float.parseFloat(sp[3])));
    }

    private HashMap<String, Color4f> readMaterials(File objfile, String mtlFileName) throws IOException {
        File mtlFile = new File(objfile.getParentFile(), mtlFileName);
        if (mtlFile.exists()) {
            return WavefrontLoader.readMaterials(mtlFile);
        }
        mtlFile = new File(mtlFileName);
        if (mtlFile.exists()) {
            return WavefrontLoader.readMaterials(mtlFile);
        }
        return null;
    }

    private static HashMap<String, Color4f> readMaterials(File f) throws IOException {
        return WavefrontLoader.readMaterials(f.getAbsolutePath());
    }

    private static HashMap<String, Color4f> readMaterials(String file) throws IOException {
        String line;
        String name = null;
        Color4f color = null;
        HashMap<String, Color4f> materials = new HashMap<String, Color4f>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            String[] sp;
            if (line.startsWith("newmtl")) {
                if (name != null && color != null) {
                    materials.put(name, color);
                }
                sp = line.split("\\s+");
                name = sp[1].trim();
                color = null;
            }
            if (line.startsWith("Kd")) {
                sp = line.split("\\s+");
                color = new Color4f(Float.parseFloat(sp[1]), Float.parseFloat(sp[2]), Float.parseFloat(sp[3]), 1.0f);
            }
            if (!line.startsWith("d ")) continue;
            if (color == null) {
                color = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
            }
            sp = line.split("\\s+");
            color.w = 1.0f - Float.parseFloat(sp[1]);
        }
        if (name != null && color != null) {
            materials.put(name, color);
        }
        return materials;
    }
}

