/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.BehaviorCallback;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.vecmath.AxisAngle4d;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Tuple3d;
import org.jogamp.vecmath.Vector3d;

public class ViewPlatformTransformer {
    protected DefaultUniverse univ;
    protected ImageCanvas3D canvas;
    protected final Point3d rotCenter = new Point3d();
    private final BehaviorCallback callback;
    private final TransformGroup centerTG;
    private final TransformGroup rotationTG;
    private final TransformGroup zoomTG;
    private final TransformGroup translateTG;
    private final Transform3D centerXform = new Transform3D();
    private final Transform3D rotationXform = new Transform3D();
    private final Transform3D zoomXform = new Transform3D();
    private final Transform3D translateXform = new Transform3D();
    private final Point3d origin = new Point3d(0.0, 0.0, 0.0);
    private final Point3d eyePos = new Point3d();
    private final Point3d oneInX = new Point3d(1.0, 0.0, 0.0);
    private final Point3d oneInY = new Point3d(0.0, 1.0, 0.0);
    private final Point3d oneInZ = new Point3d(0.0, 0.0, 1.0);
    private final Vector3d zDir = new Vector3d();
    private final Vector3d xDir = new Vector3d();
    private final Vector3d yDir = new Vector3d();
    private final Vector3d centerV = new Vector3d();
    private final Transform3D ipToVWorld = new Transform3D();
    private final Transform3D tmp = new Transform3D();
    private final Point2d originInCanvas = new Point2d();
    private final Point3d originOnIp = new Point3d();
    private final Point3d currentPtOnIp = new Point3d();
    private final AxisAngle4d aa = new AxisAngle4d();
    private final Vector3d tmpV = new Vector3d();
    private final AxisAngle4d aa2 = new AxisAngle4d();
    private final Transform3D tmp2 = new Transform3D();
    private final Point3d tmpP = new Point3d();
    private final Transform3D ipToVWorldInverse = new Transform3D();

    public ViewPlatformTransformer(DefaultUniverse univ, BehaviorCallback callback) {
        this.univ = univ;
        this.canvas = (ImageCanvas3D)univ.getCanvas();
        this.callback = callback;
        this.centerTG = univ.getCenterTG();
        this.rotationTG = univ.getRotationTG();
        this.zoomTG = univ.getZoomTG();
        this.translateTG = univ.getTranslateTG();
        ((Image3DUniverse)univ).getGlobalCenterPoint(this.rotCenter);
    }

    public void getRotationCenter(Tuple3d ret) {
        ret.set((Tuple3d)this.rotCenter);
    }

    public void zoomTo(double distance) {
        this.zDir.set(0.0, 0.0, 1.0);
        this.zDir.scale(distance);
        this.zoomXform.set(this.zDir);
        this.zoomTG.setTransform(this.zoomXform);
        this.univ.getViewer().getView().setBackClipDistance(5.0 * distance);
        this.univ.getViewer().getView().setFrontClipDistance(5.0 * distance / 100.0);
        this.transformChanged(0, this.zoomXform);
    }

    public void updateFrontBackClip() {
        this.zoomTG.getTransform(this.zoomXform);
        this.zoomXform.get(this.zDir);
        double d = this.zDir.length();
        this.univ.getViewer().getView().setBackClipDistance(5.0 * d);
        this.univ.getViewer().getView().setFrontClipDistance(5.0 * d / 100.0);
    }

    public void zoom(int units) {
        this.origin.set(0.0, 0.0, 0.0);
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        float dD = (float)this.eyePos.distance(this.origin);
        this.originInCanvas(this.originInCanvas);
        this.canvas.getPixelLocationInImagePlate(this.originInCanvas, this.originOnIp);
        this.ipToVWorld.transform(this.originOnIp);
        float dd = (float)this.eyePos.distance(this.originOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x + 5.0), (int)Math.round(this.originInCanvas.y), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float dx = (float)this.originOnIp.distance(this.currentPtOnIp);
        this.zDir.set(0.0, 0.0, -1.0);
        float factor = dx * dD / dd;
        this.zDir.scale((double)((float)units * factor));
        this.zoomTG.getTransform(this.zoomXform);
        this.tmp.set(this.zDir);
        this.zoomXform.mul(this.tmp, this.zoomXform);
        this.zoomTG.setTransform(this.zoomXform);
        this.zoomXform.get(this.centerV);
        double distance = this.centerV.length();
        this.univ.getViewer().getView().setBackClipDistance(5.0 * distance);
        this.univ.getViewer().getView().setFrontClipDistance(5.0 * distance / 100.0);
        this.transformChanged(0, this.zoomXform);
    }

    public void centerAt(Point3d center) {
        this.centerV.set(center.x, center.y, center.z);
        this.centerXform.set(this.centerV);
        this.centerTG.setTransform(this.centerXform);
        this.centerXform.setIdentity();
        this.translateTG.setTransform(this.centerXform);
        this.transformChanged(0, this.centerXform);
        this.rotCenter.set((Tuple3d)center);
    }

    public void translateXY(int dxPix, int dyPix) {
        this.origin.set(0.0, 0.0, 0.0);
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        float dD = (float)this.eyePos.distance(this.origin);
        this.originInCanvas(this.originInCanvas);
        this.canvas.getPixelLocationInImagePlate(this.originInCanvas, this.originOnIp);
        this.ipToVWorld.transform(this.originOnIp);
        float dd = (float)this.eyePos.distance(this.originOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x + 1.0), (int)Math.round(this.originInCanvas.y), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float dx = (float)this.originOnIp.distance(this.currentPtOnIp);
        this.canvas.getPixelLocationInImagePlate((int)Math.round(this.originInCanvas.x), (int)Math.round(this.originInCanvas.y + 1.0), this.currentPtOnIp);
        this.ipToVWorld.transform(this.currentPtOnIp);
        float dy = (float)this.originOnIp.distance(this.currentPtOnIp);
        float dX = dx * (float)dxPix * dD / dd;
        float dY = dy * (float)dyPix * dD / dd;
        this.translateXY(dX, dY);
    }

    public void translate(Vector3d v) {
        this.getTranslateTranslation(this.tmpV);
        this.tmpV.sub((Tuple3d)v);
        this.translateXform.set(this.tmpV);
        this.translateTG.setTransform(this.translateXform);
        this.transformChanged(0, this.translateXform);
    }

    public void translateXY(double dx, double dy) {
        this.getXDir(this.xDir);
        this.getYDir(this.yDir);
        this.xDir.scale(dx);
        this.yDir.scale(dy);
        this.xDir.add((Tuple3d)this.yDir);
        this.translate(this.xDir);
    }

    public void rotateX(double angle) {
        this.xDir.set(1.0, 0.0, 0.0);
        this.rotate(this.xDir, angle);
    }

    public void rotateY(double angle) {
        this.yDir.set(0.0, 1.0, 0.0);
        this.rotate(this.yDir, angle);
    }

    public void rotateZ(double angle) {
        this.zDir.set(0.0, 0.0, 1.0);
        this.rotate(this.zDir, angle);
    }

    public void rotate(Vector3d axis, double angle) {
        Vector3d axisVW = new Vector3d();
        this.getAxisVworld(axis, axisVW);
        this.aa.set(axisVW, angle);
        this.tmp.set(this.aa);
        this.rotationTG.getTransform(this.rotationXform);
        this.rotationXform.mul(this.tmp, this.rotationXform);
        this.rotationTG.setTransform(this.rotationXform);
        this.transformChanged(0, this.rotationXform);
    }

    public void rotateXY(double angleX, double angleY) {
        this.getXDir(this.xDir);
        this.aa.set(this.xDir, angleX);
        this.tmp.set(this.aa);
        this.getYDir(this.yDir);
        this.aa2.set(this.yDir, angleY);
        this.tmp2.set(this.aa2);
        this.rotationTG.getTransform(this.rotationXform);
        this.rotationXform.mul(this.tmp, this.rotationXform);
        this.rotationXform.mul(this.tmp2, this.rotationXform);
        this.rotationTG.setTransform(this.rotationXform);
        this.transformChanged(0, this.rotationXform);
    }

    public void getTranslateTranslation(Vector3d v) {
        this.translateTG.getTransform(this.tmp);
        this.tmp.get(v);
    }

    public void getCenterTranslation(Vector3d v) {
        this.centerTG.getTransform(this.tmp);
        this.tmp.get(v);
    }

    public void getZoomTranslation(Vector3d v) {
        this.zoomTG.getTransform(this.tmp);
        this.tmp.get(v);
    }

    public void originInCanvas(Point2d out) {
        this.origin.set(0.0, 0.0, 0.0);
        this.pointInCanvas(this.origin, out);
    }

    public void pointInCanvas(Point3d in, Point2d out) {
        this.tmpP.set((Tuple3d)in);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorldInverse.invert(this.ipToVWorld);
        this.ipToVWorldInverse.transform(in);
        this.canvas.getPixelLocationFromImagePlate(in, out);
    }

    public double distanceEyeTo(Point3d p) {
        this.canvas.getCenterEyeInImagePlate(this.eyePos);
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.ipToVWorld.transform(this.eyePos);
        return this.eyePos.distance(p);
    }

    public double distanceEyeOrigin() {
        this.origin.set(0.0, 0.0, 0.0);
        return this.distanceEyeTo(this.origin);
    }

    public void getAxisVworld(Vector3d axis, Vector3d axisVW) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInX.set((Tuple3d)axis);
        this.ipToVWorld.transform(this.oneInX);
        this.ipToVWorld.transform(this.origin);
        axisVW.sub((Tuple3d)this.oneInX, (Tuple3d)this.origin);
        axisVW.normalize();
    }

    public void getXDir(Vector3d v) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getXDir(v, this.ipToVWorld);
    }

    public void getXDir(Vector3d v, Transform3D ipToVWorld) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInX.set(1.0, 0.0, 0.0);
        ipToVWorld.transform(this.oneInX);
        ipToVWorld.transform(this.origin);
        v.sub((Tuple3d)this.oneInX, (Tuple3d)this.origin);
        v.normalize();
    }

    public void getYDir(Vector3d v) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getYDir(v, this.ipToVWorld);
    }

    public void getYDir(Vector3d v, Transform3D ipToVWorld) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInY.set(0.0, 1.0, 0.0);
        ipToVWorld.transform(this.oneInY);
        ipToVWorld.transform(this.origin);
        v.sub((Tuple3d)this.oneInY, (Tuple3d)this.origin);
        v.normalize();
    }

    public void getZDir(Vector3d v) {
        this.canvas.getImagePlateToVworld(this.ipToVWorld);
        this.getZDir(v, this.ipToVWorld);
    }

    public void getZDir(Vector3d v, Transform3D ipToVWorld) {
        this.origin.set(0.0, 0.0, 0.0);
        this.oneInZ.set(0.0, 0.0, 1.0);
        ipToVWorld.transform(this.oneInZ);
        ipToVWorld.transform(this.origin);
        v.sub((Tuple3d)this.origin, (Tuple3d)this.oneInZ);
        v.normalize();
    }

    private void transformChanged(int type, Transform3D t) {
        if (this.callback != null) {
            this.callback.transformChanged(type, t);
        }
    }
}

