/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class SubstituteFunction
extends SpecialFunction {
    public SubstituteFunction() {
        super("substitute");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        this.checkArity(call2, 2, 1);
        Object exp2 = call2.getArgument(0);
        if (call2.getArguments().length() == 2) {
            SEXP envirSexp = context.evaluate((SEXP)call2.getArgument(1), rho);
            return SubstituteFunction.substitute(exp2, envirSexp);
        }
        return SubstituteFunction.substitute(exp2, new EnvironmentContext(rho));
    }

    public static SEXP substitute(SEXP exp2, SEXP envirSexp) {
        SubstituteContext substituteContext;
        if (envirSexp instanceof Environment) {
            substituteContext = new EnvironmentContext((Environment)envirSexp);
        } else if (envirSexp instanceof ListVector) {
            substituteContext = new ListContext((ListVector)envirSexp);
        } else if (envirSexp instanceof PairList) {
            substituteContext = new PairListContext((PairList)envirSexp);
        } else {
            throw new EvalException("Cannot substitute using environment of type %s: expected list, pairlist, or environment", envirSexp.getTypeName());
        }
        return SubstituteFunction.substitute(exp2, substituteContext);
    }

    public static SEXP substitute(SEXP exp2, SubstituteContext context) {
        SubstitutingVisitor visitor = new SubstitutingVisitor(context);
        exp2.accept(visitor);
        return visitor.getResult();
    }

    private static class PairListContext
    implements SubstituteContext {
        private PairList list;

        public PairListContext(PairList list2) {
            this.list = list2;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            for (PairList.Node node : this.list.nodes()) {
                if (node.getTag() != name) continue;
                return node.getValue();
            }
            return Symbol.UNBOUND_VALUE;
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.getVariable(name) != Symbol.UNBOUND_VALUE;
        }
    }

    private static class ListContext
    implements SubstituteContext {
        private ListVector list;

        public ListContext(ListVector list2) {
            this.list = list2;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            int index = this.list.getIndexByName(name.getPrintName());
            if (index == -1) {
                return Symbol.UNBOUND_VALUE;
            }
            return this.list.getElementAsSEXP(index);
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.list.getIndexByName(name.getPrintName()) != -1;
        }
    }

    private static class EnvironmentContext
    implements SubstituteContext {
        private final Environment rho;

        public EnvironmentContext(Environment rho) {
            this.rho = rho;
        }

        @Override
        public SEXP getVariable(Symbol name) {
            return this.rho.getVariable(name);
        }

        @Override
        public boolean hasVariable(Symbol name) {
            return this.rho.hasVariable(name);
        }
    }

    private static interface SubstituteContext {
        public SEXP getVariable(Symbol var1);

        public boolean hasVariable(Symbol var1);
    }

    public static class SubstitutingVisitor
    extends SexpVisitor<SEXP> {
        private final SubstituteContext context;
        private SEXP result;

        public SubstitutingVisitor(SubstituteContext context) {
            this.context = context;
        }

        @Override
        public void visit(FunctionCall call2) {
            this.result = new FunctionCall(this.substitute(call2.getFunction()), this.substituteArgumentList(call2.getArguments()), call2.getAttributes());
        }

        private PairList substituteArgumentList(PairList arguments) {
            PairList.Builder builder = PairList.Node.newBuilder();
            for (PairList.Node node : arguments.nodes()) {
                if (node.getValue().equals(Symbols.ELLIPSES)) {
                    SEXP extraArguments = this.context.getVariable(Symbols.ELLIPSES);
                    if (extraArguments != Symbol.UNBOUND_VALUE) {
                        builder.addAll(this.unpackPromiseList((PromisePairList)extraArguments));
                        continue;
                    }
                    builder.add(Symbols.ELLIPSES);
                    continue;
                }
                builder.add(node.getRawTag(), this.substitute(node.getValue()));
            }
            return builder.build();
        }

        @Override
        public void visit(PairList.Node pairList) {
            PairList.Builder builder = PairList.Node.newBuilder();
            for (PairList.Node node : pairList.nodes()) {
                builder.add(node.getRawTag(), this.substitute(node.getValue()));
            }
            this.result = builder.build();
        }

        @Override
        public void visit(ListVector list2) {
            ListVector.Builder builder = ListVector.newBuilder();
            for (SEXP exp2 : list2) {
                builder.add(this.substitute(exp2));
            }
            builder.copyAttributesFrom(list2);
            this.result = builder.build();
        }

        @Override
        public void visit(ExpressionVector vector2) {
            ArrayList list2 = Lists.newArrayList();
            for (SEXP exp2 : vector2) {
                list2.add(this.substitute(exp2));
            }
            this.result = new ExpressionVector(list2, vector2.getAttributes());
        }

        @Override
        public void visit(Symbol symbol2) {
            this.result = this.context.hasVariable(symbol2) ? this.unpromise(this.context.getVariable(symbol2)) : symbol2;
        }

        private PairList unpackPromiseList(PromisePairList dotExp) {
            PairList.Builder unpacked = new PairList.Builder();
            for (PairList.Node node : dotExp.nodes()) {
                unpacked.add(node.getRawTag(), this.unpromise(node.getValue()));
            }
            return unpacked.build();
        }

        private SEXP unpromise(SEXP value) {
            while (value instanceof Promise) {
                value = ((Promise)value).getExpression();
            }
            return value;
        }

        @Override
        public void visit(PromisePairList dotExp) {
            super.visit(dotExp);
        }

        @Override
        protected void unhandled(SEXP exp2) {
            this.result = exp2;
        }

        @Override
        public SEXP getResult() {
            return this.result;
        }

        private SEXP substitute(SEXP exp2) {
            return SubstituteFunction.substitute(exp2, this.context);
        }
    }
}

