/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.LocalizableSampler;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.blocks.SubArrayCopy;
import net.imglib2.blocks.TempArray;
import net.imglib2.cache.Cache;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.DiskCachedCellImgFactory;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.cache.ref.BoundedSoftRefLoaderCache;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.stream.Streams;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.Type;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.CloseableThreadLocal;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.fluent.RandomAccessibleIntervalView;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5CacheLoader;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisets;

public class N5Utils {
    private N5Utils() {
    }

    public static <T extends NativeType<T>> DataType dataType(T type) {
        if (DoubleType.class.isInstance(type)) {
            return DataType.FLOAT64;
        }
        if (FloatType.class.isInstance(type)) {
            return DataType.FLOAT32;
        }
        if (LongType.class.isInstance(type)) {
            return DataType.INT64;
        }
        if (UnsignedLongType.class.isInstance(type)) {
            return DataType.UINT64;
        }
        if (IntType.class.isInstance(type)) {
            return DataType.INT32;
        }
        if (UnsignedIntType.class.isInstance(type)) {
            return DataType.UINT32;
        }
        if (ShortType.class.isInstance(type)) {
            return DataType.INT16;
        }
        if (UnsignedShortType.class.isInstance(type)) {
            return DataType.UINT16;
        }
        if (ByteType.class.isInstance(type)) {
            return DataType.INT8;
        }
        if (UnsignedByteType.class.isInstance(type)) {
            return DataType.UINT8;
        }
        return null;
    }

    public static <T extends NativeType<T>> T type(DataType dataType) {
        switch (dataType) {
            case INT8: {
                return (T)new ByteType();
            }
            case UINT8: {
                return (T)new UnsignedByteType();
            }
            case INT16: {
                return (T)new ShortType();
            }
            case UINT16: {
                return (T)new UnsignedShortType();
            }
            case INT32: {
                return (T)new IntType();
            }
            case UINT32: {
                return (T)new UnsignedIntType();
            }
            case INT64: {
                return (T)new LongType();
            }
            case UINT64: {
                return (T)new UnsignedLongType();
            }
            case FLOAT32: {
                return (T)new FloatType();
            }
            case FLOAT64: {
                return (T)new DoubleType();
            }
        }
        return null;
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset) {
        if (N5LabelMultisets.isLabelMultisetType(n5, dataset)) {
            return N5LabelMultisets.openLabelMultiset(n5, dataset);
        }
        return N5Utils.open(n5, dataset, img -> {});
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, img -> {}, maxNumCacheEntries);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset) {
        if (N5LabelMultisets.isLabelMultisetType(n5, dataset)) {
            return N5LabelMultisets.openLabelMultiset(n5, dataset);
        }
        return N5Utils.openVolatile(n5, dataset, img -> {});
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries) {
        return N5Utils.openVolatileWithBoundedSoftRefCache(n5, dataset, img -> {}, maxNumCacheEntries);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset) {
        return N5Utils.openWithDiskCache(n5, dataset, img -> {});
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.open(n5, dataset, N5CacheLoader.setToDefaultValue(defaultValue));
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries, T defaultValue) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, N5CacheLoader.setToDefaultValue(defaultValue), maxNumCacheEntries);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.openVolatile(n5, dataset, N5CacheLoader.setToDefaultValue(defaultValue));
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries, T defaultValue) {
        return N5Utils.openVolatileWithBoundedSoftRefCache(n5, dataset, N5CacheLoader.setToDefaultValue(defaultValue), maxNumCacheEntries);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.openWithDiskCache(n5, dataset, N5CacheLoader.setToDefaultValue(defaultValue));
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, AccessFlags.setOf());
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, Set<AccessFlags> accessFlags) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, dataType -> new SoftRefLoaderCache(), accessFlags);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, blockNotFoundHandler, maxNumCacheEntries, AccessFlags.setOf());
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries, Set<AccessFlags> accessFlags) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, dataType -> new BoundedSoftRefLoaderCache(maxNumCacheEntries), accessFlags);
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, Function<DataType, LoaderCache> loaderCacheFactory, Set<AccessFlags> accessFlags) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        LoaderCache loaderCache = loaderCacheFactory.apply(attributes.getDataType());
        T type = N5Utils.type(attributes.getDataType());
        return type == null ? null : N5Utils.open(n5, dataset, blockNotFoundHandler, loaderCache, accessFlags, type);
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> CachedCellImg<T, A> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, LoaderCache<Long, Cell<A>> loaderCache, Set<AccessFlags> accessFlags, T type) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        int[] blockSize = attributes.getBlockSize();
        CellGrid grid = new CellGrid(dimensions, blockSize);
        N5CacheLoader loader = new N5CacheLoader(n5, dataset, grid, type, accessFlags, blockNotFoundHandler);
        Cache cache = loaderCache.withLoader(loader);
        CachedCellImg img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get(type, accessFlags));
        return img;
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE));
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, blockNotFoundHandler, maxNumCacheEntries, AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE));
    }

    public static <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmapsWithHandler(N5Reader n5, String group, boolean useVolatileAccess, IntFunction<Consumer<IterableInterval<T>>> blockNotFoundHandlerSupplier) {
        int numScales = n5.list(group).length;
        RandomAccessibleInterval[] mipmaps = new RandomAccessibleInterval[numScales];
        double[][] scales = new double[numScales][];
        for (int s = 0; s < numScales; ++s) {
            String datasetName = group + "/s" + s;
            long[] dimensions = (long[])n5.getAttribute(datasetName, "dimensions", long[].class);
            long[] downsamplingFactors = (long[])n5.getAttribute(datasetName, "downsamplingFactors", long[].class);
            double[] scale = new double[dimensions.length];
            if (downsamplingFactors == null) {
                int si = 1 << s;
                for (int i = 0; i < scale.length; ++i) {
                    scale[i] = si;
                }
            } else {
                for (int i = 0; i < scale.length; ++i) {
                    scale[i] = downsamplingFactors[i];
                }
            }
            CachedCellImg<T, ?> source = useVolatileAccess ? N5Utils.openVolatile(n5, datasetName, blockNotFoundHandlerSupplier.apply(s)) : N5Utils.open(n5, datasetName, blockNotFoundHandlerSupplier.apply(s));
            mipmaps[s] = source;
            scales[s] = scale;
        }
        return new ValuePair((Object)mipmaps, (Object)scales);
    }

    public static <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmaps(N5Reader n5, String group, boolean useVolatileAccess, IntFunction<T> defaultValueSupplier) {
        return N5Utils.openMipmapsWithHandler(n5, group, useVolatileAccess, s -> N5CacheLoader.setToDefaultValue((Type)defaultValueSupplier.apply(s)));
    }

    public static <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmaps(N5Reader n5, String group, boolean useVolatileAccess) {
        return N5Utils.openMipmapsWithHandler(n5, group, useVolatileAccess, s -> t -> {});
    }

    public static <T extends NativeType<T>, A extends ArrayDataAccess<A>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        int[] blockSize = attributes.getBlockSize();
        CellGrid grid = new CellGrid(dimensions, blockSize);
        T type = N5Utils.type(attributes.getDataType());
        Set accessFlags = AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE, (AccessFlags)AccessFlags.DIRTY);
        N5CacheLoader loader = new N5CacheLoader(n5, dataset, grid, type, accessFlags, blockNotFoundHandler);
        DiskCachedCellImgOptions options = (DiskCachedCellImgOptions)((DiskCachedCellImgOptions)DiskCachedCellImgOptions.options().cellDimensions(blockSize)).dirtyAccesses(true).maxCacheSize(100L);
        DiskCachedCellImgFactory factory = new DiskCachedCellImgFactory(type, options);
        return factory.createWithCacheLoader(dimensions, loader);
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset) {
        if (N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultisetBlock(labelMultisetSource, n5, dataset, attributes, gridOffset);
            return;
        }
        RandomAccessibleIntervalView gridBlocks = new CellGrid(source.dimensionsAsLongArray(), attributes.getBlockSize()).cellIntervals().view().translate(gridOffset);
        BlockWriter writer = BlockWriter.create(source.view().zeroMin(), n5, dataset, attributes);
        Streams.localizing((IterableInterval)gridBlocks).map(writer::writeTask).forEach(Runnable::run);
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveBlock(source, n5, dataset, attributes);
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset, ExecutorService exec) throws InterruptedException, ExecutionException {
        if (N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultisetBlock(labelMultisetSource, n5, dataset, gridOffset, exec);
            return;
        }
        RandomAccessibleIntervalView gridBlocks = new CellGrid(source.dimensionsAsLongArray(), attributes.getBlockSize()).cellIntervals().view().translate(gridOffset);
        BlockWriter writer = BlockWriter.create(source.view().zeroMin(), n5, dataset, attributes).threadSafe();
        List futures = Streams.localizing((IterableInterval)gridBlocks).map(writer::writeTask).map(exec::submit).collect(Collectors.toList());
        for (Future f : futures) {
            f.get();
        }
    }

    public static <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset, ExecutorService exec) throws InterruptedException, ExecutionException {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset, exec);
    }

    public static <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset, T defaultValue) {
        RandomAccessibleIntervalView gridBlocks = new CellGrid(source.dimensionsAsLongArray(), attributes.getBlockSize()).cellIntervals().view().translate(gridOffset);
        BlockWriter writer = BlockWriter.createNonEmpty(source.view().zeroMin(), n5, dataset, attributes, defaultValue);
        Streams.localizing((IterableInterval)gridBlocks).map(writer::writeTask).forEach(Runnable::run);
    }

    public static <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, T defaultValue) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultValue);
    }

    public static <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, T defaultValue) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, defaultValue);
    }

    public static <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset, T defaultValue) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultValue);
    }

    public static <T extends NativeType<T>> void save(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, int[] blockSize, Compression compression) {
        if (source.getType() instanceof LabelMultisetType) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultiset(labelMultisetSource, n5, dataset, blockSize, compression);
            return;
        }
        DatasetAttributes attributes = new DatasetAttributes(source.dimensionsAsLongArray(), blockSize, N5Utils.dataType((NativeType)source.getType()), compression);
        n5.createDataset(dataset, attributes);
        N5Utils.saveBlock(source, n5, dataset, attributes);
    }

    public static <T extends NativeType<T>> void save(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, int[] blockSize, Compression compression, ExecutorService exec) throws InterruptedException, ExecutionException {
        if (source.getType() instanceof LabelMultisetType) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultiset(labelMultisetSource, n5, dataset, blockSize, compression, exec);
            return;
        }
        DatasetAttributes attributes = new DatasetAttributes(source.dimensionsAsLongArray(), blockSize, N5Utils.dataType((NativeType)source.getType()), compression);
        n5.createDataset(dataset, attributes);
        long[] gridOffset = new long[source.numDimensions()];
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset, exec);
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset) throws InterruptedException, ExecutionException {
        N5Utils.saveRegion(source, n5, dataset, n5.getDatasetAttributes(dataset));
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, ExecutorService exec) throws InterruptedException, ExecutionException {
        N5Utils.saveRegion(source, n5, dataset, n5.getDatasetAttributes(dataset), exec);
    }

    public static <T extends NativeType<T>, P> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) throws InterruptedException, ExecutionException {
        long[] dimensions;
        Optional<long[]> newDimensionsOpt = N5Utils.saveRegionPreprocessing(source, attributes);
        if (newDimensionsOpt.isPresent()) {
            n5.setAttribute(dataset, "dimensions", (Object)newDimensionsOpt.get());
            dimensions = newDimensionsOpt.get();
        } else {
            dimensions = attributes.getDimensions();
        }
        RandomAccessibleInterval<Interval> gridBlocks = N5Utils.findBoundingGridBlocks(source, dimensions, attributes.getBlockSize());
        RegionBlockWriter writer = RegionBlockWriter.create(source, n5, dataset, attributes);
        Streams.localizing(gridBlocks).map(writer::writeTask).forEach(Runnable::run);
    }

    public static <T extends NativeType<T>, P> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, ExecutorService exec) throws InterruptedException, ExecutionException {
        long[] dimensions;
        Optional<long[]> newDimensionsOpt = N5Utils.saveRegionPreprocessing(source, attributes);
        if (newDimensionsOpt.isPresent()) {
            n5.setAttribute(dataset, "dimensions", (Object)newDimensionsOpt.get());
            dimensions = newDimensionsOpt.get();
        } else {
            dimensions = attributes.getDimensions();
        }
        RandomAccessibleInterval<Interval> gridBlocks = N5Utils.findBoundingGridBlocks(source, dimensions, attributes.getBlockSize());
        RegionBlockWriter writer = RegionBlockWriter.create(source, n5, dataset, attributes).threadSafe();
        List futures = Streams.localizing(gridBlocks).map(writer::writeTask).map(exec::submit).collect(Collectors.toList());
        for (Future f : futures) {
            f.get();
        }
    }

    private static <T extends NativeType<T>> Optional<long[]> saveRegionPreprocessing(RandomAccessibleInterval<T> source, DatasetAttributes attributes) {
        DataType dtype = attributes.getDataType();
        long[] currentDimensions = attributes.getDimensions();
        int n = currentDimensions.length;
        if (source.numDimensions() != n) {
            throw new ImgLibException(String.format("Image dimensions (%d) does not match n5 dataset dimensionalidy (%d)", source.numDimensions(), n));
        }
        DataType srcType = N5Utils.dataType((NativeType)source.getType());
        if (srcType != dtype) {
            throw new ImgLibException(String.format("Image type (%s) does not match n5 dataset type (%s)", srcType, dtype));
        }
        boolean needsPadding = false;
        long[] newDimensions = new long[n];
        for (int d = 0; d < n; ++d) {
            if (source.min(d) < 0L) {
                throw new ImgLibException(String.format("Source interval min (%d) in dimension %d must be >= 0", source.min(d), d));
            }
            if (source.max(d) + 1L > currentDimensions[d]) {
                newDimensions[d] = source.max(d) + 1L;
                needsPadding = true;
                continue;
            }
            newDimensions[d] = currentDimensions[d];
        }
        if (needsPadding) {
            return Optional.of(newDimensions);
        }
        return Optional.empty();
    }

    private static RandomAccessibleInterval<Interval> findBoundingGridBlocks(Interval sourceInterval, long[] datasetDimensions, int[] blockSize) {
        int n = sourceInterval.numDimensions();
        long[] gridMin = new long[n];
        long[] gridMax = new long[n];
        for (int d = 0; d < n; ++d) {
            gridMin[d] = Math.floorDiv(sourceInterval.min(d), (long)blockSize[d]);
            gridMax[d] = Math.floorDiv(sourceInterval.max(d), (long)blockSize[d]);
        }
        return new CellGrid(datasetDimensions, blockSize).cellIntervals().view().interval((Interval)FinalInterval.wrap((long[])gridMin, (long[])gridMax));
    }

    public static void deleteBlock(Interval interval, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset) {
        RandomAccessibleIntervalView gridBlocks = new CellGrid(interval.dimensionsAsLongArray(), attributes.getBlockSize()).cellIntervals().view().translate(gridOffset);
        Streams.localizing((IterableInterval)gridBlocks).forEach(b -> n5.deleteBlock(dataset, b.positionAsLongArray()));
    }

    public static void deleteBlock(Interval interval, N5Writer n5, String dataset, DatasetAttributes attributes) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> interval.min(d) / (long)blockSize[d]);
        N5Utils.deleteBlock(interval, n5, dataset, attributes, gridOffset);
    }

    public static void deleteBlock(Interval interval, N5Writer n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.deleteBlock(interval, n5, dataset, attributes);
    }

    public static void deleteBlock(Interval interval, N5Writer n5, String dataset, long[] gridOffset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.deleteBlock(interval, n5, dataset, attributes, gridOffset);
    }

    private static <T extends NativeType<T>> Object extractValue(T value) {
        ArrayImg img = new ArrayImgFactory(value).create(new long[]{1L});
        ((NativeType)img.firstElement()).set(value);
        return ((ArrayDataAccess)img.update(null)).getCurrentStorageArray();
    }

    private static <T extends NativeType<T>> boolean allEqual(T value, Object data) {
        PrimitiveType primitiveType = value.getNativeTypeFactory().getPrimitiveType();
        Object valueArray = N5Utils.extractValue(value);
        switch (primitiveType) {
            case BOOLEAN: {
                boolean v = ((boolean[])valueArray)[0];
                boolean[] booleans = (boolean[])data;
                for (int i = 0; i < booleans.length; ++i) {
                    if (booleans[i] == v) continue;
                    return false;
                }
                return true;
            }
            case BYTE: {
                byte v = ((byte[])valueArray)[0];
                byte[] bytes = (byte[])data;
                for (int i = 0; i < bytes.length; ++i) {
                    if (bytes[i] == v) continue;
                    return false;
                }
                return true;
            }
            case CHAR: {
                char v = ((char[])valueArray)[0];
                char[] chars = (char[])data;
                for (int i = 0; i < chars.length; ++i) {
                    if (chars[i] == v) continue;
                    return false;
                }
                return true;
            }
            case SHORT: {
                short v = ((short[])valueArray)[0];
                short[] shorts = (short[])data;
                for (int i = 0; i < shorts.length; ++i) {
                    if (shorts[i] == v) continue;
                    return false;
                }
                return true;
            }
            case INT: {
                int v = ((int[])valueArray)[0];
                int[] ints = (int[])data;
                for (int i = 0; i < ints.length; ++i) {
                    if (ints[i] == v) continue;
                    return false;
                }
                return true;
            }
            case LONG: {
                long v = ((long[])valueArray)[0];
                long[] longs = (long[])data;
                for (int i = 0; i < longs.length; ++i) {
                    if (longs[i] == v) continue;
                    return false;
                }
                return true;
            }
            case FLOAT: {
                float v = ((float[])valueArray)[0];
                float[] floats = (float[])data;
                for (int i = 0; i < floats.length; ++i) {
                    if (floats[i] == v) continue;
                    return false;
                }
                return true;
            }
            case DOUBLE: {
                double v = ((double[])valueArray)[0];
                double[] doubles = (double[])data;
                for (int i = 0; i < doubles.length; ++i) {
                    if (doubles[i] == v) continue;
                    return false;
                }
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static interface RegionBlockWriter {
        public static <T extends NativeType<T>> RegionBlockWriter create(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) {
            return new Imp(source, attributes.getDataType(), gridPosition -> (DataBlock)Cast.unchecked((Object)n5.readBlock(dataset, attributes, gridPosition)), dataBlock -> n5.writeBlock(dataset, attributes, dataBlock));
        }

        public void write(long[] var1, long[] var2, int[] var3);

        default public Runnable writeTask(LocalizableSampler<Interval> gridBlock) {
            long[] gridPos = gridBlock.positionAsLongArray();
            Interval blockInterval = (Interval)gridBlock.get();
            long[] blockMin = blockInterval.minAsLongArray();
            int[] blockSize = new int[blockInterval.numDimensions()];
            Arrays.setAll(blockSize, d -> (int)blockInterval.dimension(d));
            return () -> this.write(gridPos, blockMin, blockSize);
        }

        default public RegionBlockWriter threadSafe() {
            return this;
        }

        public static class Imp<T extends NativeType<T>, P>
        implements RegionBlockWriter {
            private final DataType dataType;
            private final Function<long[], DataBlock<P>> readBlock;
            private final Consumer<DataBlock<P>> writeBlock;
            private final Interval sourceInterval;
            private final PrimitiveBlocks<T> sourceBlocks;
            private final SubArrayCopy.Typed<P, P> subArrayCopy;
            private final TempArray<P> tempArray;
            private final int[] zeroPos;
            private final long[] intersectionMin;
            private final int[] intersectionSize;
            private final int[] intersectionOffset;
            private Supplier<Imp<T, P>> threadSafeSupplier;

            Imp(RandomAccessibleInterval<T> source, DataType dataType, Function<long[], DataBlock<P>> readBlock, Consumer<DataBlock<P>> writeBlock) {
                this.dataType = dataType;
                this.readBlock = readBlock;
                this.writeBlock = writeBlock;
                this.sourceInterval = source;
                this.sourceBlocks = PrimitiveBlocks.of(source, (PrimitiveBlocks.OnFallback)PrimitiveBlocks.OnFallback.ACCEPT);
                PrimitiveType p = ((NativeType)source.getType()).getNativeTypeFactory().getPrimitiveType();
                this.subArrayCopy = SubArrayCopy.forPrimitiveType((PrimitiveType)p);
                this.tempArray = TempArray.forPrimitiveType((PrimitiveType)p);
                int n = source.numDimensions();
                this.zeroPos = new int[n];
                this.intersectionMin = new long[n];
                this.intersectionSize = new int[n];
                this.intersectionOffset = new int[n];
            }

            private Imp(Imp<T, P> writer) {
                this.dataType = writer.dataType;
                this.readBlock = writer.readBlock;
                this.writeBlock = writer.writeBlock;
                this.sourceInterval = writer.sourceInterval;
                this.sourceBlocks = writer.sourceBlocks.independentCopy();
                this.subArrayCopy = writer.subArrayCopy;
                this.tempArray = writer.tempArray.newInstance();
                this.zeroPos = writer.zeroPos;
                int n = writer.zeroPos.length;
                this.intersectionMin = new long[n];
                this.intersectionSize = new int[n];
                this.intersectionOffset = new int[n];
            }

            @Override
            public void write(long[] gridPos, long[] blockMin, int[] blockSize) {
                int n = gridPos.length;
                for (int d2 = 0; d2 < n; ++d2) {
                    this.intersectionMin[d2] = Math.max(this.sourceInterval.min(d2), blockMin[d2]);
                    this.intersectionSize[d2] = (int)(Math.min(this.sourceInterval.max(d2) + 1L, blockMin[d2] + (long)blockSize[d2]) - this.intersectionMin[d2]);
                }
                if (Arrays.equals(this.intersectionSize, blockSize)) {
                    DataBlock dataBlock = (DataBlock)Cast.unchecked((Object)this.dataType.createDataBlock(blockSize, gridPos));
                    this.sourceBlocks.copy(blockMin, dataBlock.getData(), blockSize);
                    this.writeBlock.accept(dataBlock);
                } else {
                    DataBlock dataBlock;
                    DataBlock existingBlock = this.readBlock.apply(gridPos);
                    if (existingBlock == null) {
                        dataBlock = (DataBlock)Cast.unchecked((Object)this.dataType.createDataBlock(blockSize, gridPos));
                    } else if (Arrays.equals(existingBlock.getSize(), blockSize)) {
                        dataBlock = existingBlock;
                    } else {
                        dataBlock = (DataBlock)Cast.unchecked((Object)this.dataType.createDataBlock(blockSize, gridPos));
                        this.subArrayCopy.copy(existingBlock.getData(), existingBlock.getSize(), this.zeroPos, dataBlock.getData(), dataBlock.getSize(), this.zeroPos, existingBlock.getSize());
                    }
                    Object sourceData = this.tempArray.get((int)Intervals.numElements((int[])this.intersectionSize));
                    this.sourceBlocks.copy(this.intersectionMin, sourceData, this.intersectionSize);
                    Arrays.setAll(this.intersectionOffset, d -> (int)(this.intersectionMin[d] - blockMin[d]));
                    this.subArrayCopy.copy(sourceData, this.intersectionSize, this.zeroPos, dataBlock.getData(), dataBlock.getSize(), this.intersectionOffset, this.intersectionSize);
                    this.writeBlock.accept(dataBlock);
                }
            }

            @Override
            public RegionBlockWriter threadSafe() {
                if (this.threadSafeSupplier == null) {
                    this.threadSafeSupplier = () -> ((CloseableThreadLocal)CloseableThreadLocal.withInitial(() -> new Imp<T, P>(this))).get();
                }
                return (gridPos, blockMin, blockSize) -> this.threadSafeSupplier.get().write(gridPos, blockMin, blockSize);
            }
        }
    }

    private static interface BlockWriter {
        public static <T extends NativeType<T>> BlockWriter create(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) {
            return new Imp(source, attributes.getDataType(), dataBlock -> n5.writeBlock(dataset, attributes, dataBlock));
        }

        public static <T extends NativeType<T>> BlockWriter createNonEmpty(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, T defaultValue) {
            return new Imp(source, attributes.getDataType(), dataBlock -> {
                if (!N5Utils.allEqual(defaultValue, dataBlock.getData())) {
                    n5.writeBlock(dataset, attributes, dataBlock);
                }
            });
        }

        public void write(long[] var1, long[] var2, int[] var3);

        default public Runnable writeTask(LocalizableSampler<Interval> gridBlock) {
            long[] gridPos = gridBlock.positionAsLongArray();
            Interval blockInterval = (Interval)gridBlock.get();
            long[] blockMin = blockInterval.minAsLongArray();
            int[] blockSize = new int[blockInterval.numDimensions()];
            Arrays.setAll(blockSize, d -> (int)blockInterval.dimension(d));
            return () -> this.write(gridPos, blockMin, blockSize);
        }

        default public BlockWriter threadSafe() {
            return this;
        }

        public static class Imp<T extends NativeType<T>, P>
        implements BlockWriter {
            final DataType dataType;
            final Consumer<DataBlock<P>> writeBlock;
            final PrimitiveBlocks<T> sourceBlocks;
            final int[] zeroPos;
            private Supplier<Imp<T, P>> threadSafeSupplier;

            Imp(RandomAccessibleInterval<T> source, DataType dataType, Consumer<DataBlock<P>> writeBlock) {
                this.dataType = dataType;
                this.writeBlock = writeBlock;
                this.sourceBlocks = PrimitiveBlocks.of(source, (PrimitiveBlocks.OnFallback)PrimitiveBlocks.OnFallback.ACCEPT);
                int n = source.numDimensions();
                this.zeroPos = new int[n];
            }

            Imp(Imp<T, P> writer) {
                this.dataType = writer.dataType;
                this.writeBlock = writer.writeBlock;
                this.sourceBlocks = writer.sourceBlocks.independentCopy();
                this.zeroPos = writer.zeroPos;
            }

            @Override
            public void write(long[] gridPos, long[] blockMin, int[] blockSize) {
                DataBlock dataBlock = (DataBlock)Cast.unchecked((Object)this.dataType.createDataBlock(blockSize, gridPos));
                this.sourceBlocks.copy(blockMin, dataBlock.getData(), blockSize);
                this.writeBlock.accept(dataBlock);
            }

            @Override
            public BlockWriter threadSafe() {
                if (this.threadSafeSupplier == null) {
                    this.threadSafeSupplier = () -> ((CloseableThreadLocal)CloseableThreadLocal.withInitial(() -> new Imp<T, P>(this))).get();
                }
                return (gridPos, blockMin, blockSize) -> this.threadSafeSupplier.get().write(gridPos, blockMin, blockSize);
            }
        }
    }
}

