/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.tools.brightness.MinMaxGroup;
import bdv.tools.brightness.SetupAssignments;
import bdv.util.BdvHandle;
import bdv.util.BdvSource;
import bdv.util.Bounds;
import bdv.util.PlaceHolderConverterSetup;
import bdv.util.PlaceHolderOverlayInfo;
import bdv.util.VirtualChannels;
import bdv.viewer.SourceAndConverter;
import java.util.Collections;
import net.imglib2.type.numeric.ARGBType;

public class BdvVirtualChannelSource
extends BdvSource {
    protected final PlaceHolderConverterSetup setup;
    private final SourceAndConverter<ARGBType> source;
    private final PlaceHolderOverlayInfo info;
    private final VirtualChannels.ChannelSourceCoordinator coordinator;

    protected BdvVirtualChannelSource(BdvHandle bdv, int numTimepoints, PlaceHolderConverterSetup setup, SourceAndConverter<ARGBType> source, PlaceHolderOverlayInfo info, VirtualChannels.ChannelSourceCoordinator coordinator) {
        super(bdv, numTimepoints);
        this.setup = setup;
        this.source = source;
        this.info = info;
        this.coordinator = coordinator;
    }

    public PlaceHolderOverlayInfo getPlaceHolderOverlayInfo() {
        return this.info;
    }

    @Override
    public void removeFromBdv() {
        this.coordinator.sharedInfos.remove(this.info);
        this.getBdvHandle().remove(Collections.singletonList(this.setup), Collections.singletonList(this.source), Collections.singletonList(this.info), Collections.singletonList(this.info), Collections.singletonList(this.info), null);
        this.getBdvHandle().removeBdvSource(this);
    }

    @Override
    protected boolean isPlaceHolderSource() {
        return false;
    }

    @Override
    public void setDisplayRange(double min, double max) {
        this.setup.setDisplayRange(min, max);
    }

    @Override
    public void setDisplayRangeBounds(double min, double max) {
        this.getBdvHandle().getConverterSetups().getBounds().setBounds(this.setup, new Bounds(min, max));
        SetupAssignments sa = this.getBdvHandle().getSetupAssignments();
        MinMaxGroup group = sa.getMinMaxGroup(this.setup);
        group.setRange(min, max);
    }

    @Override
    public void setColor(ARGBType color) {
        this.setup.setColor(color);
    }

    @Override
    public void setCurrent() {
        this.getBdvHandle().getViewerPanel().state().setCurrentSource(this.source);
    }

    @Override
    public boolean isCurrent() {
        return this.getBdvHandle().getViewerPanel().state().isCurrentSource(this.source);
    }

    @Override
    public void setActive(boolean isActive) {
        this.getBdvHandle().getViewerPanel().state().setSourceActive(this.source, isActive);
    }
}

