/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.Collection;
import stitching.model.InvertibleModel;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.PointMatch;

public class TranslationModel2D
extends InvertibleModel {
    protected static final int MIN_SET_SIZE = 1;
    protected final float[] translation = new float[2];

    public float[] getTranslation() {
        return this.translation;
    }

    @Override
    public final int getMinSetSize() {
        return 1;
    }

    @Override
    public float[] apply(float[] point) {
        assert (point.length == 2) : "2d translations can be applied to 2d points only.";
        return new float[]{point[0] + this.translation[0], point[1] + this.translation[1]};
    }

    @Override
    public void applyInPlace(float[] point) {
        assert (point.length == 2) : "2d translations can be applied to 2d points only.";
        point[0] = point[0] + this.translation[0];
        point[1] = point[1] + this.translation[1];
    }

    @Override
    public float[] applyInverse(float[] point) {
        assert (point.length == 2) : "2d translations can be applied to 2d points only.";
        return new float[]{point[0] - this.translation[0], point[1] - this.translation[1]};
    }

    @Override
    public void applyInverseInPlace(float[] point) {
        assert (point.length == 2) : "2d translations can be applied to 2d points only.";
        point[0] = point[0] - this.translation[0];
        point[1] = point[1] - this.translation[1];
    }

    @Override
    public String toString() {
        return "[1,2](" + this.translation[0] + "," + this.translation[1] + ") " + this.cost;
    }

    @Override
    public final void fit(Collection<PointMatch> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d translation model, at least " + 1 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            ws += (double)w;
            pcx += w * p[0];
            pcy += w * p[1];
            qcx += w * q[0];
            qcy += w * q[1];
        }
        pcx = (float)((double)pcx / ws);
        pcy = (float)((double)pcy / ws);
        qcx = (float)((double)qcx / ws);
        qcy = (float)((double)qcy / ws);
        this.translation[0] = qcx - pcx;
        this.translation[1] = qcy - pcy;
    }

    @Override
    public final void shake(Collection<PointMatch> matches, float scale, float[] center) {
    }

    @Override
    public TranslationModel2D clone() {
        TranslationModel2D tm = new TranslationModel2D();
        tm.translation[0] = this.translation[0];
        tm.translation[1] = this.translation[1];
        tm.cost = this.cost;
        return tm;
    }
}

