/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;

public class InfoDialog
extends JDialog {
    private final String OS = System.getProperty("os.name").toLowerCase();
    private JPanel panel;

    public InfoDialog(Container parent, String name, String documentation) {
        this.setTitle(name);
        this.createUI(documentation);
        this.setModal(true);
        this.setSize(this.panel.getPreferredSize());
        this.setLocationRelativeTo(parent);
    }

    private void createUI(String documentation) {
        this.panel = new JPanel();
        this.panel.setLayout((LayoutManager)new MigLayout("", "[left]"));
        JEditorPane docoPane = new JEditorPane();
        docoPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        docoPane.setEditorKit(new HTMLEditorKit());
        docoPane.setText(documentation);
        docoPane.setEditable(false);
        docoPane.setPreferredSize(new Dimension(200, 200));
        docoPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        InfoDialog.this.openURLInBrowser(hle.getURL().toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.panel.add((Component)new JScrollPane(docoPane), "gaptop10, wrap");
        JButton doneButton = new JButton("Done");
        this.panel.add((Component)doneButton, "align right, gapbottom5, split 2");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.dispose();
            }
        });
        this.add(this.panel);
    }

    private void openURLInBrowser(String url) throws IOException, InterruptedException {
        if (this.OS.indexOf("win") >= 0) {
            Runtime.getRuntime().exec("rundll32 url.dll, FileProtocolHandler " + url);
        } else if (this.OS.indexOf("mac") >= 0) {
            String[] args = new String[]{"osascript", "-e", "open location \"" + url + "\""};
            Runtime.getRuntime().exec(args);
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "chrome"};
            String browser = null;
            for (int i = 0; i < browsers.length && browser == null; ++i) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[i]}).waitFor() != 0) continue;
                browser = browsers[i];
            }
            if (browser == null) {
                throw new FileNotFoundException("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }
}

