/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.geometry;

import org.scijava.vecmath.Tuple2f;
import org.scijava.vecmath.Tuple3f;

class Basic {
    static final double D_RND_MAX = 2.147483647E9;

    Basic() {
    }

    static double detExp(double u_x, double u_y, double u_z, double v_x, double v_y, double v_z, double w_x, double w_y, double w_z) {
        return u_x * (v_y * w_z - v_z * w_y) - u_y * (v_x * w_z - v_z * w_x) + u_z * (v_x * w_y - v_y * w_x);
    }

    static double det3D(Tuple3f u, Tuple3f v, Tuple3f w) {
        return u.x * (v.y * w.z - v.z * w.y) - u.y * (v.x * w.z - v.z * w.x) + u.z * (v.x * w.y - v.y * w.x);
    }

    static double det2D(Tuple2f u, Tuple2f v, Tuple2f w) {
        return (u.x - v.x) * (v.y - w.y) + (v.y - u.y) * (v.x - w.x);
    }

    static double length2(Tuple3f u) {
        return u.x * u.x + u.y * u.y + u.z * u.z;
    }

    static double lengthL1(Tuple3f u) {
        return Math.abs(u.x) + Math.abs(u.y) + Math.abs(u.z);
    }

    static double lengthL2(Tuple3f u) {
        return Math.sqrt(u.x * u.x + u.y * u.y + u.z * u.z);
    }

    static double dotProduct(Tuple3f u, Tuple3f v) {
        return u.x * v.x + u.y * v.y + u.z * v.z;
    }

    static double dotProduct2D(Tuple2f u, Tuple2f v) {
        return u.x * v.x + u.y * v.y;
    }

    static void vectorProduct(Tuple3f p, Tuple3f q, Tuple3f r) {
        r.x = p.y * q.z - q.y * p.z;
        r.y = q.x * p.z - p.x * q.z;
        r.z = p.x * q.y - q.x * p.y;
    }

    static void vectorAdd(Tuple3f p, Tuple3f q, Tuple3f r) {
        r.x = p.x + q.x;
        r.y = p.y + q.y;
        r.z = p.z + q.z;
    }

    static void vectorSub(Tuple3f p, Tuple3f q, Tuple3f r) {
        r.x = p.x - q.x;
        r.y = p.y - q.y;
        r.z = p.z - q.z;
    }

    static void vectorAdd2D(Tuple2f p, Tuple2f q, Tuple2f r) {
        r.x = p.x + q.x;
        r.y = p.y + q.y;
    }

    static void vectorSub2D(Tuple2f p, Tuple2f q, Tuple2f r) {
        r.x = p.x - q.x;
        r.y = p.y - q.y;
    }

    static void invertVector(Tuple3f p) {
        p.x = -p.x;
        p.y = -p.y;
        p.z = -p.z;
    }

    static void divScalar(double scalar, Tuple3f u) {
        u.x = (float)((double)u.x / scalar);
        u.y = (float)((double)u.y / scalar);
        u.z = (float)((double)u.z / scalar);
    }

    static void multScalar2D(double scalar, Tuple2f u) {
        u.x = (float)((double)u.x * scalar);
        u.y = (float)((double)u.y * scalar);
    }

    static int signEps(double x, double eps) {
        return x <= eps ? (x < -eps ? -1 : 0) : 1;
    }
}

