/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class Fill_holes
implements PlugIn {
    private static boolean debug = false;
    public static final String MACRO_CMD = "var leftClick=16, alt=9;\nmacro 'Fill hole Tool - C111O11ffC100T6c0aF' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  call('Fill_holes.fillHoles', x,y,z,flags);\n  exit(); }\n}\n\n";

    public void run(String arg) {
        MacroInstaller installer = new MacroInstaller();
        installer.install(MACRO_CMD);
    }

    public static synchronized void fillHoles(String x, String y, String z, String flags) {
        Fill_holes.fillHoles(Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(z));
    }

    public static synchronized void fillHoles(int x, int y, int z) {
        ImagePlus imp = IJ.getImage();
        Roi roi = imp.getRoi();
        if (roi == null || roi.getType() != 9) {
            IJ.showMessage((String)"Image with composite selection required");
            return;
        }
        if (roi.contains(x, y)) {
            IJ.showMessage((String)"There is no hole at the specified location");
            return;
        }
        if (roi instanceof ShapeRoi) {
            try {
                Roi[] rois = ((ShapeRoi)roi).getRois();
                imp.killRoi();
                Object containingRois = null;
                RoiNode root = new RoiNode(new ShapeRoi(new Roi(0, 0, imp.getWidth(), imp.getHeight())), true);
                for (int i = 0; i < rois.length; ++i) {
                    root.add(new RoiNode(new ShapeRoi(rois[i])));
                }
                RoiNode clickedRoiNode = Fill_holes.findNodeForPosition(root, x, y);
                clickedRoiNode.remove();
                ShapeRoi newRoi = new ShapeRoi(new Roi(0, 0, imp.getWidth(), imp.getHeight()));
                root.createRoi(newRoi);
                imp.setRoi((Roi)newRoi);
                imp.updateAndDraw();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static RoiNode findNodeForPosition(RoiNode root, int x, int y) {
        RoiNode parent = root;
        RoiNode clickedRoiNode = null;
        while (parent != null) {
            boolean found = false;
            for (int i = 0; i < parent.size(); ++i) {
                clickedRoiNode = parent.children().get(i);
                if (!clickedRoiNode.roi.contains(x, y)) continue;
                found = true;
                break;
            }
            if (!found) {
                clickedRoiNode = parent;
                break;
            }
            parent = clickedRoiNode;
        }
        return clickedRoiNode;
    }

    private static void dbg(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    static class RoiNode {
        private RoiNode parent;
        private List<RoiNode> children;
        private ShapeRoi roi;
        private boolean isRoot = false;
        private int level;

        public RoiNode(ShapeRoi roi, boolean isRoot) {
            this(roi);
            this.isRoot = isRoot;
            if (isRoot) {
                this.level = 0;
            }
        }

        public RoiNode(ShapeRoi roi) {
            this.roi = roi;
            this.children = new ArrayList<RoiNode>();
        }

        public int getLevel() {
            return this.level;
        }

        public boolean containsChild(RoiNode child) {
            return this.children.contains(child);
        }

        public List<RoiNode> children() {
            return this.children;
        }

        public List<RoiNode> grandchildren() {
            ArrayList<RoiNode> grandchildren = new ArrayList<RoiNode>();
            for (int i = 0; i < this.children.size(); ++i) {
                RoiNode child = this.children.get(i);
                grandchildren.addAll(child.children);
            }
            return grandchildren;
        }

        public int size() {
            return this.children.size();
        }

        public ShapeRoi getRoi() {
            return this.roi;
        }

        public RoiNode getParent() {
            return this.parent;
        }

        public void setParent(RoiNode parent) {
            this.parent = parent;
        }

        public void updateLevels() {
            this.level = this.isRoot ? 0 : this.parent.level + 1;
            for (int i = 0; i < this.size(); ++i) {
                this.children.get(i).updateLevels();
            }
        }

        public void createRoi(ShapeRoi newRoi) {
            if (this.level % 2 == 0) {
                newRoi.not(this.roi);
            } else {
                newRoi.or(this.roi);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.children.get(i).createRoi(newRoi);
            }
        }

        public void add(RoiNode newNode) {
            RoiNode child;
            int i;
            Fill_holes.dbg("\n\n" + this + ".add(" + newNode + ")...");
            if (!this.contains(newNode)) {
                Fill_holes.dbg("  this node does not contain it, give it to the parents");
                this.parent.add(newNode);
                return;
            }
            for (i = 0; i < this.children.size(); ++i) {
                child = this.children.get(i);
                if (!child.contains(newNode)) continue;
                Fill_holes.dbg("My child " + child + " contains " + newNode + ", give the responsibility to her");
                child.add(newNode);
                return;
            }
            Fill_holes.dbg("None of my children contains " + newNode + ", so I must be the father myself ;)");
            newNode.setParent(this);
            Fill_holes.dbg("But perhaps I can give some of my children to her...");
            for (i = 0; i < this.children.size(); ++i) {
                child = this.children.get(i);
                if (!newNode.contains(child)) continue;
                Fill_holes.dbg(newNode + " contains " + child);
                newNode.children.add(child);
                child.setParent(newNode);
                this.children.remove(child);
                --i;
            }
            this.children.add(newNode);
            this.updateLevels();
        }

        public void remove() {
            if (this.isRoot) {
                return;
            }
            this.parent.children.addAll(this.grandchildren());
            this.parent.children.remove(this);
            this.parent.updateLevels();
        }

        public boolean contains(RoiNode r) {
            if (this.isRoot) {
                return true;
            }
            int x0 = r.roi.getPolygon().xpoints[0];
            int y0 = r.roi.getPolygon().ypoints[0];
            return this.roi.contains(x0, y0);
        }

        public String longString() {
            String s = "";
            for (int i = 0; i < this.level; ++i) {
                s = s + "  ";
            }
            s = s + "\\--" + this + "  parent: " + this.parent;
            return s;
        }

        public String toString() {
            Rectangle bounds = this.roi.getBounds();
            return "[" + bounds.width + "; " + bounds.height + "] (" + this.level + ")";
        }

        public void print() {
            System.out.print(this.longString() + "\n");
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.get(i).print();
            }
        }
    }
}

