/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.table;

import com.opencsv.CSVWriter;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.displaysettings.ColorIcon;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TablePanel<O> {
    private static final int ROW_HEIGHT = 26;
    private final JTable table;
    private final List<Class<?>> columnClasses;
    private final List<String> mapToTooltip;
    private final Function<O, String> labelGenerator;
    private final BiConsumer<O, String> labelSetter;
    private final List<O> objects;
    private final List<String> features;
    private final BiFunction<O, String, Double> featureFun;
    private final Map<String, String> featureNames;
    private final Map<String, String> featureShortNames;
    private final Map<String, String> featureUnits;
    private final TObjectIntHashMap<O> map;
    private final Supplier<FeatureColorGenerator<O>> colorSupplier;
    private final String manualColorFeature;
    private boolean useColoring;
    private final JPanel panel = new JPanel();

    public TablePanel(Iterable<O> objects, List<String> features, BiFunction<O, String, Double> featureFun, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, String> featureUnits, Map<String, Boolean> isInts, Map<String, String> infoTexts, Supplier<FeatureColorGenerator<O>> colorSupplier, Function<O, String> labelGenerator, BiConsumer<O, String> labelSetter) {
        this(objects, features, featureFun, featureNames, featureShortNames, featureUnits, isInts, infoTexts, colorSupplier, labelGenerator, labelSetter, null, null);
    }

    public TablePanel(Iterable<O> objects, final List<String> features, BiFunction<O, String, Double> featureFun, Map<String, String> featureNames, Map<String, String> featureShortNames, Map<String, String> featureUnits, Map<String, Boolean> isInts, Map<String, String> infoTexts, Supplier<FeatureColorGenerator<O>> colorSupplier, Function<O, String> labelGenerator, final BiConsumer<O, String> labelSetter, final String manualColorFeature, final BiConsumer<O, Color> colorSetter) {
        this.featureFun = featureFun;
        this.featureNames = featureNames;
        this.featureShortNames = featureShortNames;
        this.featureUnits = featureUnits;
        this.colorSupplier = colorSupplier;
        this.manualColorFeature = manualColorFeature;
        this.objects = new ArrayList<O>();
        this.map = new TObjectIntHashMap(10, 0.5f, -1);
        this.features = features;
        this.labelGenerator = labelGenerator;
        this.labelSetter = labelSetter;
        this.columnClasses = new ArrayList();
        this.mapToTooltip = new ArrayList<String>();
        MyTableModel tableModel = new MyTableModel();
        boolean skipLabelColumn = labelGenerator == null;
        final int labelColumnShift = skipLabelColumn ? 0 : 1;
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        this.table = new JTable(this, tableModel, tableColumnModel){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ TablePanel this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            @Override
            public boolean isCellEditable(int row, int viewcolumn) {
                int column = this.convertColumnIndexToModel(viewcolumn);
                return labelSetter != null && column == 0 || colorSetter != null && column >= labelColumnShift && ((String)features.get(column - labelColumnShift)).equals(manualColorFeature);
            }
        };
        this.table.setColumnModel(tableColumnModel);
        this.setObjects(objects);
        this.table.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "startEditing");
        this.table.setRowHeight(26);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setGridColor(this.table.getTableHeader().getBackground());
        this.columnClasses.clear();
        ArrayList<Object> headerLine = new ArrayList<Object>();
        this.mapToTooltip.clear();
        this.table.getTableHeader().addMouseMotionListener(new MyTableToolTipProvider());
        int colIndex = 0;
        if (!skipLabelColumn) {
            headerLine.add("<html><b>Label<br> <br></html>");
            this.mapToTooltip.add("Object name");
            this.columnClasses.add(String.class);
            tableColumnModel.addColumn(new TableColumn(colIndex++));
        }
        for (String feature : features) {
            Class pclass = feature.equals(manualColorFeature) ? Color.class : (isInts.get(feature) != false ? Integer.class : Double.class);
            this.columnClasses.add(pclass);
            String tooltipStr = "<html>" + featureNames.get(feature);
            String infoText = infoTexts.get(feature);
            if (infoText != null) {
                tooltipStr = tooltipStr + "<p>" + infoText + "</p>";
            }
            tooltipStr = tooltipStr + "</html>";
            this.mapToTooltip.add(tooltipStr);
            String units = featureUnits.get(feature);
            String headerStr = "<html><center><b>" + featureShortNames.get(feature) + "</b><br>";
            headerStr = headerStr + (String)(units == null || units.isEmpty() ? "<br> </html>" : "(" + units + ")</html>");
            headerLine.add(headerStr);
            tableColumnModel.addColumn(new TableColumn(colIndex++));
        }
        TableRowSorter<MyTableModel> sorter = new TableRowSorter<MyTableModel>(tableModel);
        this.table.setRowSorter(sorter);
        for (int c = 0; c < this.columnClasses.size(); ++c) {
            if (this.columnClasses.get(c).equals(Integer.class)) {
                sorter.setComparator(c, (i1, i2) -> Integer.compare((Integer)i1, (Integer)i2));
                continue;
            }
            if (this.columnClasses.get(c).equals(Double.class)) {
                sorter.setComparator(c, (d1, d2) -> Double.compare((Double)d1, (Double)d2));
                continue;
            }
            if (this.columnClasses.get(c).equals(Color.class)) {
                sorter.setComparator(c, (c1, c2) -> c1.toString().compareTo(c2.toString()));
                continue;
            }
            sorter.setComparator(c, Comparator.naturalOrder());
        }
        MyTableCellRenderer cellRenderer = new MyTableCellRenderer();
        int colorcolumn = features.indexOf(manualColorFeature) + 1;
        for (int c = 0; c < tableColumnModel.getColumnCount(); ++c) {
            TableColumn column = tableColumnModel.getColumn(c);
            column.setHeaderValue(headerLine.get(c));
            column.setCellRenderer(cellRenderer);
            if (c == colorcolumn && null != colorSetter) {
                column.setCellEditor(new MyColorEditor(colorSetter));
                continue;
            }
            if (c != 0 || null == labelSetter) continue;
            column.setCellEditor(new MyLabelEditor());
        }
        JScrollPane scrollPane = new JScrollPane(this.table, 20, 30);
        this.table.setAutoResizeMode(0);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)scrollPane, "Center");
    }

    public void setUseColoring(boolean useColoring) {
        this.useColoring = useColoring;
    }

    public void setObjects(Iterable<O> objects) {
        this.objects.clear();
        this.map.clear();
        int index = 0;
        for (O o : objects) {
            this.objects.add(o);
            this.map.put(o, index++);
        }
        ((MyTableModel)this.table.getModel()).fireTableDataChanged();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public JTable getTable() {
        return this.table;
    }

    public O getObjectForViewRow(int viewRowIndex) {
        if (viewRowIndex < 0) {
            return null;
        }
        int modelRow = this.table.convertRowIndexToModel(viewRowIndex);
        return this.objects.get(modelRow);
    }

    public int getViewRowForObject(O o) {
        int modelRow = this.map.get(o);
        if (modelRow < 0) {
            return -1;
        }
        try {
            return this.table.convertRowIndexToView(modelRow);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    public void scrollToObject(O o) {
        Rectangle rect = this.table.getVisibleRect();
        int row = this.getViewRowForObject(o);
        Rectangle cellRect = this.table.getCellRect(row, 0, true);
        cellRect.setLocation(rect.x, cellRect.y);
        this.table.scrollRectToVisible(cellRect);
    }

    public void exportToCsv(File file) throws IOException {
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(file), ',', '\u0000', '\"', "\n");){
            String feature;
            int i;
            int nCols = this.table.getColumnCount();
            boolean skipLabelColumn = this.labelGenerator == null;
            int labelColumnShift = skipLabelColumn ? 0 : 1;
            String[] content = new String[nCols];
            boolean skipThirdLine = true;
            boolean skipSecondLine = true;
            for (i = labelColumnShift; i < content.length; ++i) {
                feature = this.features.get(i - labelColumnShift);
                String name = this.featureNames.get(this.features.get(i - labelColumnShift));
                String shortName = this.featureShortNames.get(this.features.get(i - labelColumnShift));
                if (!feature.equals(name)) {
                    skipSecondLine = false;
                }
                if (name.equals(shortName)) continue;
                skipThirdLine = false;
            }
            if (!skipLabelColumn) {
                content[0] = "LABEL";
            }
            for (i = labelColumnShift; i < content.length; ++i) {
                content[i] = this.features.get(i - labelColumnShift);
            }
            writer.writeNext(content);
            if (!skipSecondLine) {
                if (!skipLabelColumn) {
                    content[0] = "Label";
                }
                for (i = labelColumnShift; i < content.length; ++i) {
                    content[i] = this.featureNames.get(this.features.get(i - labelColumnShift));
                }
                writer.writeNext(content);
            }
            if (!skipThirdLine) {
                if (!skipLabelColumn) {
                    content[0] = "Label";
                }
                for (i = labelColumnShift; i < content.length; ++i) {
                    content[i] = this.featureShortNames.get(this.features.get(i - labelColumnShift));
                }
                writer.writeNext(content);
            }
            if (!skipLabelColumn) {
                content[0] = "";
            }
            for (i = labelColumnShift; i < content.length; ++i) {
                String unitsStr;
                feature = this.features.get(i - labelColumnShift);
                String units = this.featureUnits.get(feature);
                content[i] = unitsStr = units == null || units.isEmpty() ? "" : "(" + units + ")";
            }
            writer.writeNext(content);
            int nRows = this.table.getRowCount();
            TableModel model = this.table.getModel();
            for (int r = 0; r < nRows; ++r) {
                int row = this.table.convertRowIndexToModel(r);
                for (int col = 0; col < nCols; ++col) {
                    Object obj = model.getValueAt(row, col);
                    if (null == obj) {
                        content[col] = "";
                        continue;
                    }
                    if (obj instanceof Integer) {
                        content[col] = Integer.toString((Integer)obj);
                        continue;
                    }
                    if (obj instanceof Double) {
                        content[col] = Double.toString((Double)obj);
                        continue;
                    }
                    if (obj instanceof Boolean) {
                        content[col] = (Boolean)obj != false ? "1" : "0";
                        continue;
                    }
                    if (obj instanceof Color) {
                        Color color = (Color)obj;
                        content[col] = String.format("r=%d;g=%d;b=%d", color.getRed(), color.getGreen(), color.getBlue());
                        continue;
                    }
                    content[col] = obj.toString();
                }
                writer.writeNext(content);
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return TablePanel.this.objects.size();
        }

        @Override
        public int getColumnCount() {
            return TablePanel.this.columnClasses.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            int skipLabelColumn;
            if (rowIndex < 0) {
                return null;
            }
            Object o = TablePanel.this.objects.get(rowIndex);
            if (null == o) {
                return null;
            }
            int n = skipLabelColumn = TablePanel.this.labelGenerator == null ? 0 : 1;
            if (columnIndex == 0 && TablePanel.this.labelGenerator != null) {
                return TablePanel.this.labelGenerator.apply(o);
            }
            String feature = TablePanel.this.features.get(columnIndex - skipLabelColumn);
            Double val = TablePanel.this.featureFun.apply(o, feature);
            if (feature.equals(TablePanel.this.manualColorFeature)) {
                return val == null ? null : new Color(val.intValue(), true);
            }
            if (val == null) {
                return null;
            }
            if (TablePanel.this.columnClasses.get(columnIndex).equals(Integer.class)) {
                return val.intValue();
            }
            return val;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (TablePanel.this.labelSetter == null) {
                return;
            }
            if (columnIndex == 0) {
                Object o = TablePanel.this.objects.get(rowIndex);
                if (null == o) {
                    return;
                }
                TablePanel.this.labelSetter.accept(o, (String)aValue);
            }
        }
    }

    private class MyTableToolTipProvider
    extends MouseMotionAdapter {
        private int previousCol = -1;

        private MyTableToolTipProvider() {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TableColumnModel tableColumnModel = TablePanel.this.table.getColumnModel();
            int col = tableColumnModel.getColumnIndexAtX(evt.getX());
            int vColIndex = TablePanel.this.table.convertColumnIndexToModel(col);
            if (vColIndex != this.previousCol) {
                if (vColIndex >= 0 && vColIndex < TablePanel.this.mapToTooltip.size()) {
                    TablePanel.this.table.getTableHeader().setToolTipText(TablePanel.this.mapToTooltip.get(vColIndex));
                    this.previousCol = vColIndex;
                } else {
                    TablePanel.this.table.getTableHeader().setToolTipText("");
                }
            }
        }
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private final Border normalBorder;
        private final DecimalFormat nf;
        private static final long serialVersionUID = 1L;
        private final FeatureColorGenerator<O> defaultColoring;
        private final ColorIcon colorIcon;

        public MyTableCellRenderer() {
            this.normalBorder = ((JLabel)super.getTableCellRendererComponent(TablePanel.this.table, "", false, false, 0, 0)).getBorder();
            this.nf = new DecimalFormat();
            DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
            formatSymbols.setNaN("NaN");
            this.nf.setDecimalFormatSymbols(formatSymbols);
            this.colorIcon = new ColorIcon(new Color(0));
            Color bgColor = UIManager.getColor("Table.background");
            this.defaultColoring = o -> bgColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FeatureColorGenerator coloring = TablePanel.this.useColoring ? TablePanel.this.colorSupplier.get() : this.defaultColoring;
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setBorder(this.normalBorder);
            Object o = TablePanel.this.getObjectForViewRow(row);
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(table.getSelectionForeground());
            } else {
                Color bgColor = coloring.color(o);
                c.setBackground(bgColor);
                c.setForeground(GuiUtils.textColorForBackground(bgColor));
            }
            if (hasFocus) {
                c.setBackground(table.getSelectionBackground().darker().darker());
                c.setForeground(table.getSelectionForeground());
            }
            c.setIcon(null);
            if (value instanceof Double) {
                this.setHorizontalAlignment(4);
                Double doubleValue = (Double)value;
                this.setText(this.nf.format(doubleValue));
            } else if (value instanceof Number) {
                this.setHorizontalAlignment(4);
            } else if (value instanceof Color) {
                this.colorIcon.setColor((Color)value);
                c.setIcon(this.colorIcon);
                c.setText(null);
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            return c;
        }
    }

    private class MyColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JColorChooser colorChooser = new JColorChooser();
        private static final long serialVersionUID = 1L;
        private final BiConsumer<O, Color> colorSetter;

        public MyColorEditor(BiConsumer<O, Color> colorSetter) {
            this.colorSetter = colorSetter;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, int column) {
            final ColorIcon icon = new ColorIcon((Color)value, 16, 0);
            JButton button = new JButton(icon);
            button.setHorizontalAlignment(0);
            button.addActionListener(e -> {
                this.colorChooser.setColor((Color)value);
                JDialog d = JColorChooser.createDialog(button, "Choose a color", true, this.colorChooser, new ActionListener(){
                    final /* synthetic */ MyColorEditor this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Color c = this.this$1.colorChooser.getColor();
                        if (c != null) {
                            int[] rows = this.this$1.TablePanel.this.getTable().getSelectedRows();
                            if (rows.length > 1) {
                                for (int r : rows) {
                                    Object o = this.this$1.TablePanel.this.getObjectForViewRow(r);
                                    this.this$1.colorSetter.accept(o, c);
                                }
                                this.this$1.TablePanel.this.panel.repaint();
                            } else {
                                Object o = this.this$1.TablePanel.this.getObjectForViewRow(row);
                                this.this$1.colorSetter.accept(o, c);
                            }
                            icon.setColor(c);
                        }
                    }
                }, null);
                d.setVisible(true);
            });
            return button;
        }
    }

    private static class MyLabelEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public MyLabelEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField textfield = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            SwingUtilities.invokeLater(() -> textfield.selectAll());
            return textfield;
        }
    }
}

